/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Arrays;
import java.util.Map;

public final class Code93Reader
extends OneDReader {
    private static final String ALPHABET_STRING = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*";
    private static final char[] ALPHABET = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ-. $/+%abcd*".toCharArray();
    private static final int[] CHARACTER_ENCODINGS = new int[]{276, 328, 324, 322, 296, 292, 290, 336, 274, 266, 424, 420, 418, 404, 402, 394, 360, 356, 354, 308, 282, 344, 332, 326, 300, 278, 436, 434, 428, 422, 406, 410, 364, 358, 310, 314, 302, 468, 466, 458, 366, 374, 430, 294, 474, 470, 306, 350};
    private static final int ASTERISK_ENCODING = CHARACTER_ENCODINGS[47];
    private final StringBuilder decodeRowResult = new StringBuilder(20);
    private final int[] counters = new int[6];

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        int n2;
        int n3;
        char c;
        int[] nArray = this.findAsteriskPattern(bitArray);
        int n4 = bitArray.getNextSet(nArray[1]);
        int n5 = bitArray.getSize();
        int[] nArray2 = this.counters;
        Arrays.fill(nArray2, 0);
        StringBuilder stringBuilder = this.decodeRowResult;
        stringBuilder.setLength(0);
        do {
            Code93Reader.recordPattern(bitArray, n4, nArray2);
            n3 = Code93Reader.toPattern(nArray2);
            if (n3 < 0) {
                throw NotFoundException.getNotFoundInstance();
            }
            c = Code93Reader.patternToChar(n3);
            stringBuilder.append(c);
            n2 = n4;
            for (int n6 : nArray2) {
                n4 += n6;
            }
            n4 = bitArray.getNextSet(n4);
        } while (c != '*');
        stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        n3 = 0;
        for (int n6 : nArray2) {
            n3 += n6;
        }
        if (n4 == n5 || !bitArray.get(n4)) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (stringBuilder.length() < 2) {
            throw NotFoundException.getNotFoundInstance();
        }
        Code93Reader.checkChecksums(stringBuilder);
        stringBuilder.setLength(stringBuilder.length() - 2);
        String string = Code93Reader.decodeExtended(stringBuilder);
        float f = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f2 = (float)n2 + (float)n3 / 2.0f;
        return new Result(string, null, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, BarcodeFormat.CODE_93);
    }

    private int[] findAsteriskPattern(BitArray bitArray) throws NotFoundException {
        int n = bitArray.getSize();
        int n2 = bitArray.getNextSet(0);
        Arrays.fill(this.counters, 0);
        int[] nArray = this.counters;
        int n3 = n2;
        boolean bl = false;
        int n4 = nArray.length;
        int n5 = 0;
        for (int i = n2; i < n; ++i) {
            if (bitArray.get(i) ^ bl) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (n5 == n4 - 1) {
                if (Code93Reader.toPattern(nArray) == ASTERISK_ENCODING) {
                    return new int[]{n3, i};
                }
                n3 += nArray[0] + nArray[1];
                System.arraycopy(nArray, 2, nArray, 0, n4 - 2);
                nArray[n4 - 2] = 0;
                nArray[n4 - 1] = 0;
                --n5;
            } else {
                ++n5;
            }
            nArray[n5] = 1;
            bl = !bl;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int toPattern(int[] nArray) {
        int n;
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        int[] nArray2 = nArray;
        int n5 = nArray2.length;
        for (n2 = 0; n2 < n5; ++n2) {
            n = nArray2[n2];
            n4 += n;
        }
        int n6 = 0;
        for (n5 = 0; n5 < n3; ++n5) {
            n2 = (nArray[n5] << 8) * 9 / n4;
            n = n2 >> 8;
            if ((n2 & 0xFF) > 127) {
                ++n;
            }
            if (n < 1 || n > 4) {
                return -1;
            }
            if ((n5 & 1) == 0) {
                for (int i = 0; i < n; ++i) {
                    n6 = n6 << 1 | 1;
                }
                continue;
            }
            n6 <<= n;
        }
        return n6;
    }

    private static char patternToChar(int n) throws NotFoundException {
        for (int i = 0; i < CHARACTER_ENCODINGS.length; ++i) {
            if (CHARACTER_ENCODINGS[i] != n) continue;
            return ALPHABET[i];
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static String decodeExtended(CharSequence charSequence) throws FormatException {
        int n = charSequence.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        for (int i = 0; i < n; ++i) {
            char c = charSequence.charAt(i);
            if (c >= 'a' && c <= 'd') {
                if (i >= n - 1) {
                    throw FormatException.getFormatInstance();
                }
                char c2 = charSequence.charAt(i + 1);
                int n2 = 0;
                switch (c) {
                    case 'd': {
                        if (c2 >= 'A' && c2 <= 'Z') {
                            n2 = (char)(c2 + 32);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'a': {
                        if (c2 >= 'A' && c2 <= 'Z') {
                            n2 = (char)(c2 - 64);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'b': {
                        if (c2 >= 'A' && c2 <= 'E') {
                            n2 = (char)(c2 - 38);
                            break;
                        }
                        if (c2 >= 'F' && c2 <= 'W') {
                            n2 = (char)(c2 - 11);
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                    case 'c': {
                        if (c2 >= 'A' && c2 <= 'O') {
                            n2 = (char)(c2 - 32);
                            break;
                        }
                        if (c2 == 'Z') {
                            n2 = 58;
                            break;
                        }
                        throw FormatException.getFormatInstance();
                    }
                }
                stringBuilder.append((char)n2);
                ++i;
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static void checkChecksums(CharSequence charSequence) throws ChecksumException {
        int n = charSequence.length();
        Code93Reader.checkOneChecksum(charSequence, n - 2, 20);
        Code93Reader.checkOneChecksum(charSequence, n - 1, 15);
    }

    private static void checkOneChecksum(CharSequence charSequence, int n, int n2) throws ChecksumException {
        int n3 = 1;
        int n4 = 0;
        for (int i = n - 1; i >= 0; --i) {
            n4 += n3 * ALPHABET_STRING.indexOf(charSequence.charAt(i));
            if (++n3 <= n2) continue;
            n3 = 1;
        }
        if (charSequence.charAt(n) != ALPHABET[n4 % 47]) {
            throw ChecksumException.getChecksumInstance();
        }
    }
}

