/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class EAN13Reader
extends UPCEANReader {
    static final int[] FIRST_DIGIT_ENCODINGS = new int[]{0, 11, 13, 14, 19, 25, 28, 21, 22, 26};
    private final int[] decodeMiddleCounters = new int[4];

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int n;
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n2 = bitArray.getSize();
        int n3 = nArray[1];
        int n4 = 0;
        for (int i = 0; i < 6 && n3 < n2; ++i) {
            n = EAN13Reader.decodeDigit(bitArray, nArray2, n3, L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n % 10));
            for (int n5 : nArray2) {
                n3 += n5;
            }
            if (n < 10) continue;
            n4 |= 1 << 5 - i;
        }
        EAN13Reader.determineFirstDigit(stringBuilder, n4);
        int[] nArray3 = EAN13Reader.findGuardPattern(bitArray, n3, true, MIDDLE_PATTERN);
        n3 = nArray3[1];
        for (n = 0; n < 6 && n3 < n2; ++n) {
            int n6 = EAN13Reader.decodeDigit(bitArray, nArray2, n3, L_PATTERNS);
            stringBuilder.append((char)(48 + n6));
            for (int n7 : nArray2) {
                n3 += n7;
            }
        }
        return n3;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_13;
    }

    private static void determineFirstDigit(StringBuilder stringBuilder, int n) throws NotFoundException {
        for (int i = 0; i < 10; ++i) {
            if (n != FIRST_DIGIT_ENCODINGS[i]) continue;
            stringBuilder.insert(0, (char)(48 + i));
            return;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

