/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class EAN8Reader
extends UPCEANReader {
    private final int[] decodeMiddleCounters = new int[4];

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int n;
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n2 = bitArray.getSize();
        int n3 = nArray[1];
        for (int i = 0; i < 4 && n3 < n2; ++i) {
            n = EAN8Reader.decodeDigit(bitArray, nArray2, n3, L_PATTERNS);
            stringBuilder.append((char)(48 + n));
            for (int n4 : nArray2) {
                n3 += n4;
            }
        }
        int[] nArray3 = EAN8Reader.findGuardPattern(bitArray, n3, true, MIDDLE_PATTERN);
        n3 = nArray3[1];
        for (n = 0; n < 4 && n3 < n2; ++n) {
            int n5 = EAN8Reader.decodeDigit(bitArray, nArray2, n3, L_PATTERNS);
            stringBuilder.append((char)(48 + n5));
            for (int n6 : nArray2) {
                n3 += n6;
            }
        }
        return n3;
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.EAN_8;
    }
}

