/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.OneDReader;
import java.util.Map;

public final class ITFReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 107;
    private static final int MAX_INDIVIDUAL_VARIANCE = 199;
    private static final int W = 3;
    private static final int N = 1;
    private static final int[] DEFAULT_ALLOWED_LENGTHS = new int[]{48, 44, 24, 20, 18, 16, 14, 12, 10, 8, 6};
    private int narrowLineWidth = -1;
    private static final int[] START_PATTERN = new int[]{1, 1, 1, 1};
    private static final int[] END_PATTERN_REVERSED = new int[]{1, 1, 3};
    static final int[][] PATTERNS = new int[][]{{1, 1, 3, 3, 1}, {3, 1, 1, 1, 3}, {1, 3, 1, 1, 3}, {3, 3, 1, 1, 1}, {1, 1, 3, 1, 3}, {3, 1, 3, 1, 1}, {1, 3, 3, 1, 1}, {1, 1, 1, 3, 3}, {3, 1, 1, 3, 1}, {1, 3, 1, 3, 1}};

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map<DecodeHintType, ?> map) throws FormatException, NotFoundException {
        int[] nArray = this.decodeStart(bitArray);
        int[] nArray2 = this.decodeEnd(bitArray);
        StringBuilder stringBuilder = new StringBuilder(20);
        ITFReader.decodeMiddle(bitArray, nArray[1], nArray2[0], stringBuilder);
        String string = stringBuilder.toString();
        int[] nArray3 = null;
        if (map != null) {
            nArray3 = (int[])map.get((Object)DecodeHintType.ALLOWED_LENGTHS);
        }
        if (nArray3 == null) {
            nArray3 = DEFAULT_ALLOWED_LENGTHS;
        }
        int n2 = string.length();
        boolean bl = false;
        for (int n3 : nArray3) {
            if (n2 != n3) continue;
            bl = true;
            break;
        }
        if (!bl) {
            throw FormatException.getFormatInstance();
        }
        return new Result(string, null, new ResultPoint[]{new ResultPoint(nArray[1], n), new ResultPoint(nArray2[0], n)}, BarcodeFormat.ITF);
    }

    private static void decodeMiddle(BitArray bitArray, int n, int n2, StringBuilder stringBuilder) throws NotFoundException {
        int[] nArray = new int[10];
        int[] nArray2 = new int[5];
        int[] nArray3 = new int[5];
        while (n < n2) {
            int n3;
            ITFReader.recordPattern(bitArray, n, nArray);
            for (n3 = 0; n3 < 5; ++n3) {
                int n4 = n3 << 1;
                nArray2[n3] = nArray[n4];
                nArray3[n3] = nArray[n4 + 1];
            }
            n3 = ITFReader.decodeDigit(nArray2);
            stringBuilder.append((char)(48 + n3));
            n3 = ITFReader.decodeDigit(nArray3);
            stringBuilder.append((char)(48 + n3));
            for (int n5 : nArray) {
                n += n5;
            }
        }
    }

    int[] decodeStart(BitArray bitArray) throws NotFoundException {
        int n = ITFReader.skipWhiteSpace(bitArray);
        int[] nArray = ITFReader.findGuardPattern(bitArray, n, START_PATTERN);
        this.narrowLineWidth = nArray[1] - nArray[0] >> 2;
        this.validateQuietZone(bitArray, nArray[0]);
        return nArray;
    }

    private void validateQuietZone(BitArray bitArray, int n) throws NotFoundException {
        int n2 = this.narrowLineWidth * 10;
        n2 = n2 < n ? n2 : n;
        for (int i = n - 1; n2 > 0 && i >= 0 && !bitArray.get(i); --n2, --i) {
        }
        if (n2 != 0) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    private static int skipWhiteSpace(BitArray bitArray) throws NotFoundException {
        int n = bitArray.getSize();
        int n2 = bitArray.getNextSet(0);
        if (n2 == n) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int[] decodeEnd(BitArray bitArray) throws NotFoundException {
        bitArray.reverse();
        try {
            int n = ITFReader.skipWhiteSpace(bitArray);
            int[] nArray = ITFReader.findGuardPattern(bitArray, n, END_PATTERN_REVERSED);
            this.validateQuietZone(bitArray, nArray[0]);
            int n2 = nArray[0];
            nArray[0] = bitArray.getSize() - nArray[1];
            nArray[1] = bitArray.getSize() - n2;
            int[] nArray2 = nArray;
            return nArray2;
        }
        finally {
            bitArray.reverse();
        }
    }

    private static int[] findGuardPattern(BitArray bitArray, int n, int[] nArray) throws NotFoundException {
        int n2 = nArray.length;
        int[] nArray2 = new int[n2];
        int n3 = bitArray.getSize();
        boolean bl = false;
        int n4 = 0;
        int n5 = n;
        for (int i = n; i < n3; ++i) {
            if (bitArray.get(i) ^ bl) {
                int n6 = n4;
                nArray2[n6] = nArray2[n6] + 1;
                continue;
            }
            if (n4 == n2 - 1) {
                if (ITFReader.patternMatchVariance(nArray2, nArray, 199) < 107) {
                    return new int[]{n5, i};
                }
                n5 += nArray2[0] + nArray2[1];
                System.arraycopy(nArray2, 2, nArray2, 0, n2 - 2);
                nArray2[n2 - 2] = 0;
                nArray2[n2 - 1] = 0;
                --n4;
            } else {
                ++n4;
            }
            nArray2[n4] = 1;
            bl = !bl;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static int decodeDigit(int[] nArray) throws NotFoundException {
        int n = 107;
        int n2 = -1;
        int n3 = PATTERNS.length;
        for (int i = 0; i < n3; ++i) {
            int[] nArray2 = PATTERNS[i];
            int n4 = ITFReader.patternMatchVariance(nArray, nArray2, 199);
            if (n4 >= n) continue;
            n = n4;
            n2 = i;
        }
        if (n2 >= 0) {
            return n2;
        }
        throw NotFoundException.getNotFoundInstance();
    }
}

