/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;

public abstract class OneDReader
implements Reader {
    protected static final int INTEGER_MATH_SHIFT = 8;
    protected static final int PATTERN_MATCH_RESULT_SCALE_FACTOR = 256;

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, FormatException {
        try {
            return this.doDecode(binaryBitmap, map);
        }
        catch (NotFoundException notFoundException) {
            boolean bl;
            boolean bl2 = bl = map != null && map.containsKey((Object)DecodeHintType.TRY_HARDER);
            if (bl && binaryBitmap.isRotateSupported()) {
                BinaryBitmap binaryBitmap2 = binaryBitmap.rotateCounterClockwise();
                Result result = this.doDecode(binaryBitmap2, map);
                Map<ResultMetadataType, Object> map2 = result.getResultMetadata();
                int n = 270;
                if (map2 != null && map2.containsKey((Object)ResultMetadataType.ORIENTATION)) {
                    n = (n + (Integer)map2.get((Object)ResultMetadataType.ORIENTATION)) % 360;
                }
                result.putMetadata(ResultMetadataType.ORIENTATION, n);
                ResultPoint[] resultPointArray = result.getResultPoints();
                if (resultPointArray != null) {
                    int n2 = binaryBitmap2.getHeight();
                    for (int i = 0; i < resultPointArray.length; ++i) {
                        resultPointArray[i] = new ResultPoint((float)n2 - resultPointArray[i].getY() - 1.0f, resultPointArray[i].getX());
                    }
                }
                return result;
            }
            throw notFoundException;
        }
    }

    @Override
    public void reset() {
    }

    private Result doDecode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> object) throws NotFoundException {
        int n = binaryBitmap.getWidth();
        int n2 = binaryBitmap.getHeight();
        BitArray bitArray = new BitArray(n);
        int n3 = n2 >> 1;
        boolean bl = object != null && object.containsKey((Object)DecodeHintType.TRY_HARDER);
        int n4 = Math.max(1, n2 >> (bl ? 8 : 5));
        int n5 = bl ? n2 : 15;
        for (int i = 0; i < n5; ++i) {
            int n6 = i + 1 >> 1;
            boolean bl2 = (i & 1) == 0;
            int n7 = n3 + n4 * (bl2 ? n6 : -n6);
            if (n7 < 0 || n7 >= n2) break;
            try {
                bitArray = binaryBitmap.getBlackRow(n7, bitArray);
            }
            catch (NotFoundException notFoundException) {
                continue;
            }
            for (int j = 0; j < 2; ++j) {
                Object object2;
                if (j == 1) {
                    bitArray.reverse();
                    if (object != null && object.containsKey((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK)) {
                        object2 = new EnumMap(DecodeHintType.class);
                        object2.putAll(object);
                        object2.remove((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
                        object = object2;
                    }
                }
                try {
                    object2 = this.decodeRow(n7, bitArray, (Map<DecodeHintType, ?>)object);
                    if (j == 1) {
                        ((Result)object2).putMetadata(ResultMetadataType.ORIENTATION, 180);
                        ResultPoint[] resultPointArray = ((Result)object2).getResultPoints();
                        if (resultPointArray != null) {
                            resultPointArray[0] = new ResultPoint((float)n - resultPointArray[0].getX() - 1.0f, resultPointArray[0].getY());
                            resultPointArray[1] = new ResultPoint((float)n - resultPointArray[1].getX() - 1.0f, resultPointArray[1].getY());
                        }
                    }
                    return object2;
                }
                catch (ReaderException readerException) {
                    continue;
                }
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    protected static void recordPattern(BitArray bitArray, int n, int[] nArray) throws NotFoundException {
        int n2;
        int n3 = nArray.length;
        Arrays.fill(nArray, 0, n3, 0);
        int n4 = bitArray.getSize();
        if (n >= n4) {
            throw NotFoundException.getNotFoundInstance();
        }
        boolean bl = !bitArray.get(n);
        int n5 = 0;
        for (n2 = n; n2 < n4; ++n2) {
            if (bitArray.get(n2) ^ bl) {
                int n6 = n5;
                nArray[n6] = nArray[n6] + 1;
                continue;
            }
            if (++n5 == n3) break;
            nArray[n5] = 1;
            bl = !bl;
        }
        if (n5 != n3 && (n5 != n3 - 1 || n2 != n4)) {
            throw NotFoundException.getNotFoundInstance();
        }
    }

    protected static void recordPatternInReverse(BitArray bitArray, int n, int[] nArray) throws NotFoundException {
        int n2 = nArray.length;
        boolean bl = bitArray.get(n);
        while (n > 0 && n2 >= 0) {
            if (bitArray.get(--n) == bl) continue;
            --n2;
            bl = !bl;
        }
        if (n2 >= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        OneDReader.recordPattern(bitArray, n + 1, nArray);
    }

    protected static int patternMatchVariance(int[] nArray, int[] nArray2, int n) {
        int n2;
        int n3 = nArray.length;
        int n4 = 0;
        int n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            n4 += nArray[n2];
            n5 += nArray2[n2];
        }
        if (n4 < n5) {
            return Integer.MAX_VALUE;
        }
        n2 = (n4 << 8) / n5;
        n = n * n2 >> 8;
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            int n7;
            int n8 = nArray[i] << 8;
            int n9 = nArray2[i] * n2;
            int n10 = n7 = n8 > n9 ? n8 - n9 : n9 - n8;
            if (n7 > n) {
                return Integer.MAX_VALUE;
            }
            n6 += n7;
        }
        return n6 / n4;
    }

    public abstract Result decodeRow(int var1, BitArray var2, Map<DecodeHintType, ?> var3) throws NotFoundException, ChecksumException, FormatException;
}

