/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.Writer;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import java.util.Map;

public abstract class OneDimensionalCodeWriter
implements Writer {
    @Override
    public final BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2) throws WriterException {
        return this.encode(string, barcodeFormat, n, n2, null);
    }

    @Override
    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, int n2, Map<EncodeHintType, ?> map) throws WriterException {
        Object object;
        if (string.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (n < 0 || n2 < 0) {
            throw new IllegalArgumentException("Negative size is not allowed. Input: " + n + "x" + n2);
        }
        int n3 = this.getDefaultMargin();
        if (map != null && (object = (Object)((Integer)map.get((Object)EncodeHintType.MARGIN))) != null) {
            n3 = (Integer)object;
        }
        object = this.encode(string);
        return OneDimensionalCodeWriter.renderResult((boolean[])object, n, n2, n3);
    }

    private static BitMatrix renderResult(boolean[] blArray, int n, int n2, int n3) {
        int n4 = blArray.length;
        int n5 = n4 + n3;
        int n6 = Math.max(n, n5);
        int n7 = Math.max(1, n2);
        int n8 = n6 / n5;
        int n9 = (n6 - n4 * n8) / 2;
        BitMatrix bitMatrix = new BitMatrix(n6, n7);
        int n10 = 0;
        int n11 = n9;
        while (n10 < n4) {
            if (blArray[n10]) {
                bitMatrix.setRegion(n11, 0, n8, n7);
            }
            ++n10;
            n11 += n8;
        }
        return bitMatrix;
    }

    protected static int appendPattern(boolean[] blArray, int n, int[] nArray, boolean bl) {
        boolean bl2 = bl;
        int n2 = 0;
        for (int n3 : nArray) {
            for (int i = 0; i < n3; ++i) {
                blArray[n++] = bl2;
            }
            n2 += n3;
            bl2 = !bl2;
        }
        return n2;
    }

    public int getDefaultMargin() {
        return 10;
    }

    public abstract boolean[] encode(String var1);
}

