/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.NotFoundException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;
import java.util.EnumMap;
import java.util.Map;

final class UPCEANExtension5Support {
    private static final int[] CHECK_DIGIT_ENCODINGS = new int[]{24, 20, 18, 17, 12, 6, 3, 10, 9, 5};
    private final int[] decodeMiddleCounters = new int[4];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder();

    UPCEANExtension5Support() {
    }

    Result decodeRow(int n, BitArray bitArray, int[] nArray) throws NotFoundException {
        StringBuilder stringBuilder = this.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n2 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        String string = stringBuilder.toString();
        Map<ResultMetadataType, Object> map = UPCEANExtension5Support.parseExtensionString(string);
        Result result = new Result(string, null, new ResultPoint[]{new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n), new ResultPoint(n2, n)}, BarcodeFormat.UPC_EAN_EXTENSION);
        if (map != null) {
            result.putAllMetadata(map);
        }
        return result;
    }

    int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int n;
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n2 = bitArray.getSize();
        int n3 = nArray[1];
        int n4 = 0;
        for (n = 0; n < 5 && n3 < n2; ++n) {
            int n5 = UPCEANReader.decodeDigit(bitArray, nArray2, n3, UPCEANReader.L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n5 % 10));
            for (int n6 : nArray2) {
                n3 += n6;
            }
            if (n5 >= 10) {
                n4 |= 1 << 4 - n;
            }
            if (n == 4) continue;
            n3 = bitArray.getNextSet(n3);
            n3 = bitArray.getNextUnset(n3);
        }
        if (stringBuilder.length() != 5) {
            throw NotFoundException.getNotFoundInstance();
        }
        n = UPCEANExtension5Support.determineCheckDigit(n4);
        if (UPCEANExtension5Support.extensionChecksum(stringBuilder.toString()) != n) {
            throw NotFoundException.getNotFoundInstance();
        }
        return n3;
    }

    private static int extensionChecksum(CharSequence charSequence) {
        int n;
        int n2 = charSequence.length();
        int n3 = 0;
        for (n = n2 - 2; n >= 0; n -= 2) {
            n3 += charSequence.charAt(n) - 48;
        }
        n3 *= 3;
        for (n = n2 - 1; n >= 0; n -= 2) {
            n3 += charSequence.charAt(n) - 48;
        }
        return (n3 *= 3) % 10;
    }

    private static int determineCheckDigit(int n) throws NotFoundException {
        for (int i = 0; i < 10; ++i) {
            if (n != CHECK_DIGIT_ENCODINGS[i]) continue;
            return i;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    private static Map<ResultMetadataType, Object> parseExtensionString(String string) {
        if (string.length() != 5) {
            return null;
        }
        String string2 = UPCEANExtension5Support.parseExtension5String(string);
        if (string2 == null) {
            return null;
        }
        EnumMap<ResultMetadataType, Object> enumMap = new EnumMap<ResultMetadataType, Object>(ResultMetadataType.class);
        enumMap.put(ResultMetadataType.SUGGESTED_PRICE, string2);
        return enumMap;
    }

    private static String parseExtension5String(String string) {
        String string2;
        switch (string.charAt(0)) {
            case '0': {
                string2 = "\u00c2\u00a3";
                break;
            }
            case '5': {
                string2 = "$";
                break;
            }
            case '9': {
                if ("90000".equals(string)) {
                    return null;
                }
                if ("99991".equals(string)) {
                    return "0.00";
                }
                if ("99990".equals(string)) {
                    return "Used";
                }
                string2 = "";
                break;
            }
            default: {
                string2 = "";
            }
        }
        int n = Integer.parseInt(string.substring(1));
        String string3 = String.valueOf(n / 100);
        int n2 = n % 100;
        Object object = n2 < 10 ? "0" + n2 : String.valueOf(n2);
        return string2 + string3 + "." + (String)object;
    }
}

