/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.ResultPointCallback;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.EANManufacturerOrgSupport;
import com.google.zxing.oned.OneDReader;
import com.google.zxing.oned.UPCEANExtensionSupport;
import java.util.Arrays;
import java.util.Map;

public abstract class UPCEANReader
extends OneDReader {
    private static final int MAX_AVG_VARIANCE = 122;
    private static final int MAX_INDIVIDUAL_VARIANCE = 179;
    static final int[] START_END_PATTERN = new int[]{1, 1, 1};
    static final int[] MIDDLE_PATTERN = new int[]{1, 1, 1, 1, 1};
    static final int[][] L_PATTERNS = new int[][]{{3, 2, 1, 1}, {2, 2, 2, 1}, {2, 1, 2, 2}, {1, 4, 1, 1}, {1, 1, 3, 2}, {1, 2, 3, 1}, {1, 1, 1, 4}, {1, 3, 1, 2}, {1, 2, 1, 3}, {3, 1, 1, 2}};
    static final int[][] L_AND_G_PATTERNS = new int[20][];
    private final StringBuilder decodeRowStringBuffer = new StringBuilder(20);
    private final UPCEANExtensionSupport extensionReader = new UPCEANExtensionSupport();
    private final EANManufacturerOrgSupport eanManSupport = new EANManufacturerOrgSupport();

    protected UPCEANReader() {
    }

    static int[] findStartGuardPattern(BitArray bitArray) throws NotFoundException {
        boolean bl = false;
        int[] nArray = null;
        int n = 0;
        int[] nArray2 = new int[START_END_PATTERN.length];
        while (!bl) {
            Arrays.fill(nArray2, 0, START_END_PATTERN.length, 0);
            nArray = UPCEANReader.findGuardPattern(bitArray, n, false, START_END_PATTERN, nArray2);
            int n2 = nArray[0];
            int n3 = n2 - ((n = nArray[1]) - n2);
            if (n3 < 0) continue;
            bl = bitArray.isRange(n3, n2, false);
        }
        return nArray;
    }

    @Override
    public Result decodeRow(int n, BitArray bitArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        return this.decodeRow(n, bitArray, UPCEANReader.findStartGuardPattern(bitArray), map);
    }

    public Result decodeRow(int n, BitArray bitArray, int[] nArray, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        Object object;
        int n2;
        int n3;
        ResultPointCallback resultPointCallback;
        ResultPointCallback resultPointCallback2 = resultPointCallback = map == null ? null : (ResultPointCallback)map.get((Object)DecodeHintType.NEED_RESULT_POINT_CALLBACK);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray[0] + nArray[1]) / 2.0f, n));
        }
        StringBuilder stringBuilder = this.decodeRowStringBuffer;
        stringBuilder.setLength(0);
        int n4 = this.decodeMiddle(bitArray, nArray, stringBuilder);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint(n4, n));
        }
        int[] nArray2 = this.decodeEnd(bitArray, n4);
        if (resultPointCallback != null) {
            resultPointCallback.foundPossibleResultPoint(new ResultPoint((float)(nArray2[0] + nArray2[1]) / 2.0f, n));
        }
        if ((n3 = (n2 = nArray2[1]) + (n2 - nArray2[0])) >= bitArray.getSize() || !bitArray.isRange(n2, n3, false)) {
            throw NotFoundException.getNotFoundInstance();
        }
        String string = stringBuilder.toString();
        if (string.length() < 8) {
            throw FormatException.getFormatInstance();
        }
        if (!this.checkChecksum(string)) {
            throw ChecksumException.getChecksumInstance();
        }
        float f = (float)(nArray[1] + nArray[0]) / 2.0f;
        float f2 = (float)(nArray2[1] + nArray2[0]) / 2.0f;
        BarcodeFormat barcodeFormat = this.getBarcodeFormat();
        Result result = new Result(string, null, new ResultPoint[]{new ResultPoint(f, n), new ResultPoint(f2, n)}, barcodeFormat);
        try {
            object = this.extensionReader.decodeRow(n, bitArray, nArray2[1]);
            result.putMetadata(ResultMetadataType.UPC_EAN_EXTENSION, ((Result)object).getText());
            result.putAllMetadata(((Result)object).getResultMetadata());
            result.addResultPoints(((Result)object).getResultPoints());
        }
        catch (ReaderException readerException) {
            // empty catch block
        }
        if ((barcodeFormat == BarcodeFormat.EAN_13 || barcodeFormat == BarcodeFormat.UPC_A) && (object = this.eanManSupport.lookupCountryIdentifier(string)) != null) {
            result.putMetadata(ResultMetadataType.POSSIBLE_COUNTRY, object);
        }
        return result;
    }

    boolean checkChecksum(String string) throws ChecksumException, FormatException {
        return UPCEANReader.checkStandardUPCEANChecksum(string);
    }

    static boolean checkStandardUPCEANChecksum(CharSequence charSequence) throws FormatException {
        int n;
        int n2;
        int n3 = charSequence.length();
        if (n3 == 0) {
            return false;
        }
        int n4 = 0;
        for (n2 = n3 - 2; n2 >= 0; n2 -= 2) {
            n = charSequence.charAt(n2) - 48;
            if (n < 0 || n > 9) {
                throw FormatException.getFormatInstance();
            }
            n4 += n;
        }
        n4 *= 3;
        for (n2 = n3 - 1; n2 >= 0; n2 -= 2) {
            n = charSequence.charAt(n2) - 48;
            if (n < 0 || n > 9) {
                throw FormatException.getFormatInstance();
            }
            n4 += n;
        }
        return n4 % 10 == 0;
    }

    int[] decodeEnd(BitArray bitArray, int n) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n, false, START_END_PATTERN);
    }

    static int[] findGuardPattern(BitArray bitArray, int n, boolean bl, int[] nArray) throws NotFoundException {
        return UPCEANReader.findGuardPattern(bitArray, n, bl, nArray, new int[nArray.length]);
    }

    private static int[] findGuardPattern(BitArray bitArray, int n, boolean bl, int[] nArray, int[] nArray2) throws NotFoundException {
        int n2 = nArray.length;
        int n3 = bitArray.getSize();
        boolean bl2 = bl;
        n = bl ? bitArray.getNextUnset(n) : bitArray.getNextSet(n);
        int n4 = 0;
        int n5 = n;
        for (int i = n; i < n3; ++i) {
            if (bitArray.get(i) ^ bl2) {
                int n6 = n4;
                nArray2[n6] = nArray2[n6] + 1;
                continue;
            }
            if (n4 == n2 - 1) {
                if (UPCEANReader.patternMatchVariance(nArray2, nArray, 179) < 122) {
                    return new int[]{n5, i};
                }
                n5 += nArray2[0] + nArray2[1];
                System.arraycopy(nArray2, 2, nArray2, 0, n2 - 2);
                nArray2[n2 - 2] = 0;
                nArray2[n2 - 1] = 0;
                --n4;
            } else {
                ++n4;
            }
            nArray2[n4] = 1;
            bl2 = !bl2;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    static int decodeDigit(BitArray bitArray, int[] nArray, int n, int[][] nArray2) throws NotFoundException {
        UPCEANReader.recordPattern(bitArray, n, nArray);
        int n2 = 122;
        int n3 = -1;
        int n4 = nArray2.length;
        for (int i = 0; i < n4; ++i) {
            int[] nArray3 = nArray2[i];
            int n5 = UPCEANReader.patternMatchVariance(nArray, nArray3, 179);
            if (n5 >= n2) continue;
            n2 = n5;
            n3 = i;
        }
        if (n3 >= 0) {
            return n3;
        }
        throw NotFoundException.getNotFoundInstance();
    }

    abstract BarcodeFormat getBarcodeFormat();

    protected abstract int decodeMiddle(BitArray var1, int[] var2, StringBuilder var3) throws NotFoundException;

    static {
        System.arraycopy(L_PATTERNS, 0, L_AND_G_PATTERNS, 0, 10);
        for (int i = 10; i < 20; ++i) {
            int[] nArray = L_PATTERNS[i - 10];
            int[] nArray2 = new int[nArray.length];
            for (int j = 0; j < nArray.length; ++j) {
                nArray2[j] = nArray[nArray.length - j - 1];
            }
            UPCEANReader.L_AND_G_PATTERNS[i] = nArray2;
        }
    }
}

