/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.common.BitArray;
import com.google.zxing.oned.UPCEANReader;

public final class UPCEReader
extends UPCEANReader {
    private static final int[] MIDDLE_END_PATTERN = new int[]{1, 1, 1, 1, 1, 1};
    private static final int[][] NUMSYS_AND_CHECK_DIGIT_PATTERNS = new int[][]{{56, 52, 50, 49, 44, 38, 35, 42, 41, 37}, {7, 11, 13, 14, 19, 25, 28, 21, 22, 26}};
    private final int[] decodeMiddleCounters = new int[4];

    @Override
    protected int decodeMiddle(BitArray bitArray, int[] nArray, StringBuilder stringBuilder) throws NotFoundException {
        int[] nArray2 = this.decodeMiddleCounters;
        nArray2[0] = 0;
        nArray2[1] = 0;
        nArray2[2] = 0;
        nArray2[3] = 0;
        int n = bitArray.getSize();
        int n2 = nArray[1];
        int n3 = 0;
        for (int i = 0; i < 6 && n2 < n; ++i) {
            int n4 = UPCEReader.decodeDigit(bitArray, nArray2, n2, L_AND_G_PATTERNS);
            stringBuilder.append((char)(48 + n4 % 10));
            for (int n5 : nArray2) {
                n2 += n5;
            }
            if (n4 < 10) continue;
            n3 |= 1 << 5 - i;
        }
        UPCEReader.determineNumSysAndCheckDigit(stringBuilder, n3);
        return n2;
    }

    @Override
    protected int[] decodeEnd(BitArray bitArray, int n) throws NotFoundException {
        return UPCEReader.findGuardPattern(bitArray, n, true, MIDDLE_END_PATTERN);
    }

    @Override
    protected boolean checkChecksum(String string) throws FormatException, ChecksumException {
        return super.checkChecksum(UPCEReader.convertUPCEtoUPCA(string));
    }

    private static void determineNumSysAndCheckDigit(StringBuilder stringBuilder, int n) throws NotFoundException {
        for (int i = 0; i <= 1; ++i) {
            for (int j = 0; j < 10; ++j) {
                if (n != NUMSYS_AND_CHECK_DIGIT_PATTERNS[i][j]) continue;
                stringBuilder.insert(0, (char)(48 + i));
                stringBuilder.append((char)(48 + j));
                return;
            }
        }
        throw NotFoundException.getNotFoundInstance();
    }

    @Override
    BarcodeFormat getBarcodeFormat() {
        return BarcodeFormat.UPC_E;
    }

    public static String convertUPCEtoUPCA(String string) {
        char[] cArray = new char[6];
        string.getChars(1, 7, cArray, 0);
        StringBuilder stringBuilder = new StringBuilder(12);
        stringBuilder.append(string.charAt(0));
        char c = cArray[5];
        switch (c) {
            case '0': 
            case '1': 
            case '2': {
                stringBuilder.append(cArray, 0, 2);
                stringBuilder.append(c);
                stringBuilder.append("0000");
                stringBuilder.append(cArray, 2, 3);
                break;
            }
            case '3': {
                stringBuilder.append(cArray, 0, 3);
                stringBuilder.append("00000");
                stringBuilder.append(cArray, 3, 2);
                break;
            }
            case '4': {
                stringBuilder.append(cArray, 0, 4);
                stringBuilder.append("00000");
                stringBuilder.append(cArray[4]);
                break;
            }
            default: {
                stringBuilder.append(cArray, 0, 5);
                stringBuilder.append("0000");
                stringBuilder.append(c);
            }
        }
        stringBuilder.append(string.charAt(7));
        return stringBuilder.toString();
    }
}

