/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.oned.rss.expanded.decoders;

import com.google.zxing.common.BitArray;
import com.google.zxing.oned.rss.expanded.decoders.AbstractExpandedDecoder;

abstract class AI01decoder
extends AbstractExpandedDecoder {
    protected static final int GTIN_SIZE = 40;

    AI01decoder(BitArray bitArray) {
        super(bitArray);
    }

    protected final void encodeCompressedGtin(StringBuilder stringBuilder, int n) {
        stringBuilder.append("(01)");
        int n2 = stringBuilder.length();
        stringBuilder.append('9');
        this.encodeCompressedGtinWithoutAI(stringBuilder, n, n2);
    }

    protected final void encodeCompressedGtinWithoutAI(StringBuilder stringBuilder, int n, int n2) {
        for (int i = 0; i < 4; ++i) {
            int n3 = this.getGeneralDecoder().extractNumericValueFromBitArray(n + 10 * i, 10);
            if (n3 / 100 == 0) {
                stringBuilder.append('0');
            }
            if (n3 / 10 == 0) {
                stringBuilder.append('0');
            }
            stringBuilder.append(n3);
        }
        AI01decoder.appendCheckDigit(stringBuilder, n2);
    }

    private static void appendCheckDigit(StringBuilder stringBuilder, int n) {
        int n2 = 0;
        for (int i = 0; i < 13; ++i) {
            int n3 = stringBuilder.charAt(i + n) - 48;
            n2 += (i & 1) == 0 ? 3 * n3 : n3;
        }
        if ((n2 = 10 - n2 % 10) == 10) {
            n2 = 0;
        }
        stringBuilder.append(n2);
    }
}

