/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.pdf417.PDF417ResultMetadata;
import java.math.BigInteger;
import java.util.Arrays;

final class DecodedBitStreamParser {
    private static final int TEXT_COMPACTION_MODE_LATCH = 900;
    private static final int BYTE_COMPACTION_MODE_LATCH = 901;
    private static final int NUMERIC_COMPACTION_MODE_LATCH = 902;
    private static final int BYTE_COMPACTION_MODE_LATCH_6 = 924;
    private static final int BEGIN_MACRO_PDF417_CONTROL_BLOCK = 928;
    private static final int BEGIN_MACRO_PDF417_OPTIONAL_FIELD = 923;
    private static final int MACRO_PDF417_TERMINATOR = 922;
    private static final int MODE_SHIFT_TO_BYTE_COMPACTION_MODE = 913;
    private static final int MAX_NUMERIC_CODEWORDS = 15;
    private static final int PL = 25;
    private static final int LL = 27;
    private static final int AS = 27;
    private static final int ML = 28;
    private static final int AL = 28;
    private static final int PS = 29;
    private static final int PAL = 29;
    private static final char[] PUNCT_CHARS;
    private static final char[] MIXED_CHARS;
    private static final BigInteger[] EXP900;
    private static final int NUMBER_OF_SEQUENCE_CODEWORDS = 2;

    private DecodedBitStreamParser() {
    }

    static DecoderResult decode(int[] nArray, String string) throws FormatException {
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 2);
        int n = 1;
        int n2 = nArray[n++];
        PDF417ResultMetadata pDF417ResultMetadata = new PDF417ResultMetadata();
        while (n < nArray[0]) {
            switch (n2) {
                case 900: {
                    n = DecodedBitStreamParser.textCompaction(nArray, n, stringBuilder);
                    break;
                }
                case 901: 
                case 913: 
                case 924: {
                    n = DecodedBitStreamParser.byteCompaction(n2, nArray, n, stringBuilder);
                    break;
                }
                case 902: {
                    n = DecodedBitStreamParser.numericCompaction(nArray, n, stringBuilder);
                    break;
                }
                case 928: {
                    n = DecodedBitStreamParser.decodeMacroBlock(nArray, n, pDF417ResultMetadata);
                    break;
                }
                case 922: 
                case 923: {
                    throw FormatException.getFormatInstance();
                }
                default: {
                    --n;
                    n = DecodedBitStreamParser.textCompaction(nArray, n, stringBuilder);
                }
            }
            if (n < nArray.length) {
                n2 = nArray[n++];
                continue;
            }
            throw FormatException.getFormatInstance();
        }
        if (stringBuilder.length() == 0) {
            throw FormatException.getFormatInstance();
        }
        DecoderResult decoderResult = new DecoderResult(null, stringBuilder.toString(), null, string);
        decoderResult.setOther(pDF417ResultMetadata);
        return decoderResult;
    }

    private static int decodeMacroBlock(int[] nArray, int n, PDF417ResultMetadata pDF417ResultMetadata) throws FormatException {
        if (n + 2 > nArray[0]) {
            throw FormatException.getFormatInstance();
        }
        int[] nArray2 = new int[2];
        int n2 = 0;
        while (n2 < 2) {
            nArray2[n2] = nArray[n];
            ++n2;
            ++n;
        }
        pDF417ResultMetadata.setSegmentIndex(Integer.parseInt(DecodedBitStreamParser.decodeBase900toBase10(nArray2, 2)));
        StringBuilder stringBuilder = new StringBuilder();
        n = DecodedBitStreamParser.textCompaction(nArray, n, stringBuilder);
        pDF417ResultMetadata.setFileId(stringBuilder.toString());
        if (nArray[n] == 923) {
            int[] nArray3 = new int[nArray[0] - ++n];
            int n3 = 0;
            boolean bl = false;
            block4: while (n < nArray[0] && !bl) {
                int n4;
                if ((n4 = nArray[n++]) < 900) {
                    nArray3[n3++] = n4;
                    continue;
                }
                switch (n4) {
                    case 922: {
                        pDF417ResultMetadata.setLastSegment(true);
                        ++n;
                        bl = true;
                        continue block4;
                    }
                }
                throw FormatException.getFormatInstance();
            }
            pDF417ResultMetadata.setOptionalData(Arrays.copyOf(nArray3, n3));
        } else if (nArray[n] == 922) {
            pDF417ResultMetadata.setLastSegment(true);
            ++n;
        }
        return n;
    }

    private static int textCompaction(int[] nArray, int n, StringBuilder stringBuilder) {
        int[] nArray2 = new int[nArray[0] - n << 1];
        int[] nArray3 = new int[nArray[0] - n << 1];
        int n2 = 0;
        boolean bl = false;
        while (n < nArray[0] && !bl) {
            int n3;
            if ((n3 = nArray[n++]) < 900) {
                nArray2[n2] = n3 / 30;
                nArray2[n2 + 1] = n3 % 30;
                n2 += 2;
                continue;
            }
            switch (n3) {
                case 900: {
                    nArray2[n2++] = 900;
                    break;
                }
                case 901: 
                case 902: 
                case 922: 
                case 923: 
                case 924: 
                case 928: {
                    --n;
                    bl = true;
                    break;
                }
                case 913: {
                    nArray2[n2] = 913;
                    nArray3[n2] = n3 = nArray[n++];
                    ++n2;
                }
            }
        }
        DecodedBitStreamParser.decodeTextCompaction(nArray2, nArray3, n2, stringBuilder);
        return n;
    }

    private static void decodeTextCompaction(int[] nArray, int[] nArray2, int n, StringBuilder stringBuilder) {
        Mode mode = Mode.ALPHA;
        Mode mode2 = Mode.ALPHA;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray[i];
            int n3 = 0;
            switch (mode) {
                case ALPHA: {
                    if (n2 < 26) {
                        n3 = (char)(65 + n2);
                        break;
                    }
                    if (n2 == 26) {
                        n3 = 32;
                        break;
                    }
                    if (n2 == 27) {
                        mode = Mode.LOWER;
                        break;
                    }
                    if (n2 == 28) {
                        mode = Mode.MIXED;
                        break;
                    }
                    if (n2 == 29) {
                        mode2 = mode;
                        mode = Mode.PUNCT_SHIFT;
                        break;
                    }
                    if (n2 == 913) {
                        stringBuilder.append((char)nArray2[i]);
                        break;
                    }
                    if (n2 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case LOWER: {
                    if (n2 < 26) {
                        n3 = (char)(97 + n2);
                        break;
                    }
                    if (n2 == 26) {
                        n3 = 32;
                        break;
                    }
                    if (n2 == 27) {
                        mode2 = mode;
                        mode = Mode.ALPHA_SHIFT;
                        break;
                    }
                    if (n2 == 28) {
                        mode = Mode.MIXED;
                        break;
                    }
                    if (n2 == 29) {
                        mode2 = mode;
                        mode = Mode.PUNCT_SHIFT;
                        break;
                    }
                    if (n2 == 913) {
                        stringBuilder.append((char)nArray2[i]);
                        break;
                    }
                    if (n2 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case MIXED: {
                    if (n2 < 25) {
                        n3 = MIXED_CHARS[n2];
                        break;
                    }
                    if (n2 == 25) {
                        mode = Mode.PUNCT;
                        break;
                    }
                    if (n2 == 26) {
                        n3 = 32;
                        break;
                    }
                    if (n2 == 27) {
                        mode = Mode.LOWER;
                        break;
                    }
                    if (n2 == 28) {
                        mode = Mode.ALPHA;
                        break;
                    }
                    if (n2 == 29) {
                        mode2 = mode;
                        mode = Mode.PUNCT_SHIFT;
                        break;
                    }
                    if (n2 == 913) {
                        stringBuilder.append((char)nArray2[i]);
                        break;
                    }
                    if (n2 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case PUNCT: {
                    if (n2 < 29) {
                        n3 = PUNCT_CHARS[n2];
                        break;
                    }
                    if (n2 == 29) {
                        mode = Mode.ALPHA;
                        break;
                    }
                    if (n2 == 913) {
                        stringBuilder.append((char)nArray2[i]);
                        break;
                    }
                    if (n2 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case ALPHA_SHIFT: {
                    mode = mode2;
                    if (n2 < 26) {
                        n3 = (char)(65 + n2);
                        break;
                    }
                    if (n2 == 26) {
                        n3 = 32;
                        break;
                    }
                    if (n2 != 900) break;
                    mode = Mode.ALPHA;
                    break;
                }
                case PUNCT_SHIFT: {
                    mode = mode2;
                    if (n2 < 29) {
                        n3 = PUNCT_CHARS[n2];
                        break;
                    }
                    if (n2 == 29) {
                        mode = Mode.ALPHA;
                        break;
                    }
                    if (n2 == 913) {
                        stringBuilder.append((char)nArray2[i]);
                        break;
                    }
                    if (n2 != 900) break;
                    mode = Mode.ALPHA;
                }
            }
            if (n3 == 0) continue;
            stringBuilder.append((char)n3);
        }
    }

    private static int byteCompaction(int n, int[] nArray, int n2, StringBuilder stringBuilder) {
        block11: {
            block10: {
                int n3;
                if (n != 901) break block10;
                int n4 = 0;
                long l = 0L;
                char[] cArray = new char[6];
                int[] nArray2 = new int[6];
                boolean bl = false;
                int n5 = nArray[n2++];
                while (n2 < nArray[0] && !bl) {
                    nArray2[n4++] = n5;
                    l = 900L * l + (long)n5;
                    if ((n5 = nArray[n2++]) == 900 || n5 == 901 || n5 == 902 || n5 == 924 || n5 == 928 || n5 == 923 || n5 == 922) {
                        --n2;
                        bl = true;
                        continue;
                    }
                    if (n4 % 5 != 0 || n4 <= 0) continue;
                    for (n3 = 0; n3 < 6; ++n3) {
                        cArray[5 - n3] = (char)(l % 256L);
                        l >>= 8;
                    }
                    stringBuilder.append(cArray);
                    n4 = 0;
                }
                if (n2 == nArray[0] && n5 < 900) {
                    nArray2[n4++] = n5;
                }
                for (n3 = 0; n3 < n4; ++n3) {
                    stringBuilder.append((char)nArray2[n3]);
                }
                break block11;
            }
            if (n != 924) break block11;
            int n6 = 0;
            long l = 0L;
            boolean bl = false;
            while (n2 < nArray[0] && !bl) {
                int n7;
                if ((n7 = nArray[n2++]) < 900) {
                    ++n6;
                    l = 900L * l + (long)n7;
                } else if (n7 == 900 || n7 == 901 || n7 == 902 || n7 == 924 || n7 == 928 || n7 == 923 || n7 == 922) {
                    --n2;
                    bl = true;
                }
                if (n6 % 5 != 0 || n6 <= 0) continue;
                char[] cArray = new char[6];
                for (int i = 0; i < 6; ++i) {
                    cArray[5 - i] = (char)(l & 0xFFL);
                    l >>= 8;
                }
                stringBuilder.append(cArray);
                n6 = 0;
            }
        }
        return n2;
    }

    private static int numericCompaction(int[] nArray, int n, StringBuilder stringBuilder) throws FormatException {
        int n2 = 0;
        boolean bl = false;
        int[] nArray2 = new int[15];
        while (n < nArray[0] && !bl) {
            int n3 = nArray[n++];
            if (n == nArray[0]) {
                bl = true;
            }
            if (n3 < 900) {
                nArray2[n2] = n3;
                ++n2;
            } else if (n3 == 900 || n3 == 901 || n3 == 924 || n3 == 928 || n3 == 923 || n3 == 922) {
                --n;
                bl = true;
            }
            if (n2 % 15 != 0 && n3 != 902 && !bl) continue;
            String string = DecodedBitStreamParser.decodeBase900toBase10(nArray2, n2);
            stringBuilder.append(string);
            n2 = 0;
        }
        return n;
    }

    private static String decodeBase900toBase10(int[] nArray, int n) throws FormatException {
        BigInteger bigInteger = BigInteger.ZERO;
        for (int i = 0; i < n; ++i) {
            bigInteger = bigInteger.add(EXP900[n - i - 1].multiply(BigInteger.valueOf(nArray[i])));
        }
        String string = bigInteger.toString();
        if (string.charAt(0) != '1') {
            throw FormatException.getFormatInstance();
        }
        return string.substring(1);
    }

    static {
        BigInteger bigInteger;
        PUNCT_CHARS = new char[]{';', '<', '>', '@', '[', '\\', '}', '_', '`', '~', '!', '\r', '\t', ',', ':', '\n', '-', '.', '$', '/', '\"', '|', '*', '(', ')', '?', '{', '}', '\''};
        MIXED_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '&', '\r', '\t', ',', ':', '#', '-', '.', '$', '/', '+', '%', '*', '=', '^'};
        EXP900 = new BigInteger[16];
        DecodedBitStreamParser.EXP900[0] = BigInteger.ONE;
        DecodedBitStreamParser.EXP900[1] = bigInteger = BigInteger.valueOf(900L);
        for (int i = 2; i < EXP900.length; ++i) {
            DecodedBitStreamParser.EXP900[i] = EXP900[i - 1].multiply(bigInteger);
        }
    }

    private static enum Mode {
        ALPHA,
        LOWER,
        MIXED,
        PUNCT,
        ALPHA_SHIFT,
        PUNCT_SHIFT;

    }
}

