/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.decoder.BarcodeMetadata;
import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import com.google.zxing.pdf417.decoder.DetectionResultColumn;
import com.google.zxing.pdf417.decoder.DetectionResultRowIndicatorColumn;
import java.util.Formatter;

final class DetectionResult {
    private static final int ADJUST_ROW_NUMBER_SKIP = 2;
    private final BarcodeMetadata barcodeMetadata;
    private final DetectionResultColumn[] detectionResultColumns;
    private BoundingBox boundingBox;
    private final int barcodeColumnCount;

    DetectionResult(BarcodeMetadata barcodeMetadata, BoundingBox boundingBox) {
        this.barcodeMetadata = barcodeMetadata;
        this.barcodeColumnCount = barcodeMetadata.getColumnCount();
        this.boundingBox = boundingBox;
        this.detectionResultColumns = new DetectionResultColumn[this.barcodeColumnCount + 2];
    }

    DetectionResultColumn[] getDetectionResultColumns() {
        int n;
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[0]);
        this.adjustIndicatorColumnRowNumbers(this.detectionResultColumns[this.barcodeColumnCount + 1]);
        int n2 = 928;
        do {
            n = n2;
        } while ((n2 = this.adjustRowNumbers()) > 0 && n2 < n);
        return this.detectionResultColumns;
    }

    private void adjustIndicatorColumnRowNumbers(DetectionResultColumn detectionResultColumn) {
        if (detectionResultColumn != null) {
            ((DetectionResultRowIndicatorColumn)detectionResultColumn).adjustCompleteIndicatorColumnRowNumbers(this.barcodeMetadata);
        }
    }

    private int adjustRowNumbers() {
        int n = this.adjustRowNumbersByRow();
        if (n == 0) {
            return 0;
        }
        for (int i = 1; i < this.barcodeColumnCount + 1; ++i) {
            Codeword[] codewordArray = this.detectionResultColumns[i].getCodewords();
            for (int j = 0; j < codewordArray.length; ++j) {
                if (codewordArray[j] == null || codewordArray[j].hasValidRowNumber()) continue;
                this.adjustRowNumbers(i, j, codewordArray);
            }
        }
        return n;
    }

    private int adjustRowNumbersByRow() {
        this.adjustRowNumbersFromBothRI();
        int n = this.adjustRowNumbersFromLRI();
        return n + this.adjustRowNumbersFromRRI();
    }

    private void adjustRowNumbersFromBothRI() {
        if (this.detectionResultColumns[0] == null || this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return;
        }
        Codeword[] codewordArray = this.detectionResultColumns[0].getCodewords();
        Codeword[] codewordArray2 = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        for (int i = 0; i < codewordArray.length; ++i) {
            if (codewordArray[i] == null || codewordArray2[i] == null || codewordArray[i].getRowNumber() != codewordArray2[i].getRowNumber()) continue;
            for (int j = 1; j <= this.barcodeColumnCount; ++j) {
                Codeword codeword = this.detectionResultColumns[j].getCodewords()[i];
                if (codeword == null) continue;
                codeword.setRowNumber(codewordArray[i].getRowNumber());
                if (codeword.hasValidRowNumber()) continue;
                this.detectionResultColumns[j].getCodewords()[i] = null;
            }
        }
    }

    private int adjustRowNumbersFromRRI() {
        if (this.detectionResultColumns[this.barcodeColumnCount + 1] == null) {
            return 0;
        }
        int n = 0;
        Codeword[] codewordArray = this.detectionResultColumns[this.barcodeColumnCount + 1].getCodewords();
        for (int i = 0; i < codewordArray.length; ++i) {
            if (codewordArray[i] == null) continue;
            int n2 = codewordArray[i].getRowNumber();
            int n3 = 0;
            for (int j = this.barcodeColumnCount + 1; j > 0 && n3 < 2; --j) {
                Codeword codeword = this.detectionResultColumns[j].getCodewords()[i];
                if (codeword == null) continue;
                n3 = DetectionResult.adjustRowNumberIfValid(n2, n3, codeword);
                if (codeword.hasValidRowNumber()) continue;
                ++n;
            }
        }
        return n;
    }

    private int adjustRowNumbersFromLRI() {
        if (this.detectionResultColumns[0] == null) {
            return 0;
        }
        int n = 0;
        Codeword[] codewordArray = this.detectionResultColumns[0].getCodewords();
        for (int i = 0; i < codewordArray.length; ++i) {
            if (codewordArray[i] == null) continue;
            int n2 = codewordArray[i].getRowNumber();
            int n3 = 0;
            for (int j = 1; j < this.barcodeColumnCount + 1 && n3 < 2; ++j) {
                Codeword codeword = this.detectionResultColumns[j].getCodewords()[i];
                if (codeword == null) continue;
                n3 = DetectionResult.adjustRowNumberIfValid(n2, n3, codeword);
                if (codeword.hasValidRowNumber()) continue;
                ++n;
            }
        }
        return n;
    }

    private static int adjustRowNumberIfValid(int n, int n2, Codeword codeword) {
        if (codeword == null) {
            return n2;
        }
        if (!codeword.hasValidRowNumber()) {
            if (codeword.isValidRowNumber(n)) {
                codeword.setRowNumber(n);
                n2 = 0;
            } else {
                ++n2;
            }
        }
        return n2;
    }

    private void adjustRowNumbers(int n, int n2, Codeword[] codewordArray) {
        Codeword[] codewordArray2;
        Codeword codeword = codewordArray[n2];
        Codeword[] codewordArray3 = codewordArray2 = this.detectionResultColumns[n - 1].getCodewords();
        if (this.detectionResultColumns[n + 1] != null) {
            codewordArray3 = this.detectionResultColumns[n + 1].getCodewords();
        }
        Codeword[] codewordArray4 = new Codeword[14];
        codewordArray4[2] = codewordArray2[n2];
        codewordArray4[3] = codewordArray3[n2];
        if (n2 > 0) {
            codewordArray4[0] = codewordArray[n2 - 1];
            codewordArray4[4] = codewordArray2[n2 - 1];
            codewordArray4[5] = codewordArray3[n2 - 1];
        }
        if (n2 > 1) {
            codewordArray4[8] = codewordArray[n2 - 2];
            codewordArray4[10] = codewordArray2[n2 - 2];
            codewordArray4[11] = codewordArray3[n2 - 2];
        }
        if (n2 < codewordArray.length - 1) {
            codewordArray4[1] = codewordArray[n2 + 1];
            codewordArray4[6] = codewordArray2[n2 + 1];
            codewordArray4[7] = codewordArray3[n2 + 1];
        }
        if (n2 < codewordArray.length - 2) {
            codewordArray4[9] = codewordArray[n2 + 2];
            codewordArray4[12] = codewordArray2[n2 + 2];
            codewordArray4[13] = codewordArray3[n2 + 2];
        }
        for (Codeword codeword2 : codewordArray4) {
            if (!DetectionResult.adjustRowNumber(codeword, codeword2)) continue;
            return;
        }
    }

    private static boolean adjustRowNumber(Codeword codeword, Codeword codeword2) {
        if (codeword2 == null) {
            return false;
        }
        if (codeword2.hasValidRowNumber() && codeword2.getBucket() == codeword.getBucket()) {
            codeword.setRowNumber(codeword2.getRowNumber());
            return true;
        }
        return false;
    }

    int getBarcodeColumnCount() {
        return this.barcodeColumnCount;
    }

    int getBarcodeRowCount() {
        return this.barcodeMetadata.getRowCount();
    }

    int getBarcodeECLevel() {
        return this.barcodeMetadata.getErrorCorrectionLevel();
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    void setDetectionResultColumn(int n, DetectionResultColumn detectionResultColumn) {
        this.detectionResultColumns[n] = detectionResultColumn;
    }

    DetectionResultColumn getDetectionResultColumn(int n) {
        return this.detectionResultColumns[n];
    }

    public String toString() {
        DetectionResultColumn detectionResultColumn = this.detectionResultColumns[0];
        if (detectionResultColumn == null) {
            detectionResultColumn = this.detectionResultColumns[this.barcodeColumnCount + 1];
        }
        Formatter formatter = new Formatter();
        for (int i = 0; i < detectionResultColumn.getCodewords().length; ++i) {
            formatter.format("CW %3d:", i);
            for (int j = 0; j < this.barcodeColumnCount + 2; ++j) {
                if (this.detectionResultColumns[j] == null) {
                    formatter.format("    |   ", new Object[0]);
                    continue;
                }
                Codeword codeword = this.detectionResultColumns[j].getCodewords()[i];
                if (codeword == null) {
                    formatter.format("    |   ", new Object[0]);
                    continue;
                }
                formatter.format(" %3d|%3d", codeword.getRowNumber(), codeword.getValue());
            }
            formatter.format("\n", new Object[0]);
        }
        String string = formatter.toString();
        formatter.close();
        return string;
    }
}

