/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import java.util.Formatter;

class DetectionResultColumn {
    private static final int MAX_NEARBY_DISTANCE = 5;
    private final BoundingBox boundingBox;
    private final Codeword[] codewords;

    DetectionResultColumn(BoundingBox boundingBox) {
        this.boundingBox = new BoundingBox(boundingBox);
        this.codewords = new Codeword[boundingBox.getMaxY() - boundingBox.getMinY() + 1];
    }

    final Codeword getCodewordNearby(int n) {
        Codeword codeword = this.getCodeword(n);
        if (codeword != null) {
            return codeword;
        }
        for (int i = 1; i < 5; ++i) {
            int n2 = this.imageRowToCodewordIndex(n) - i;
            if (n2 >= 0 && (codeword = this.codewords[n2]) != null) {
                return codeword;
            }
            n2 = this.imageRowToCodewordIndex(n) + i;
            if (n2 >= this.codewords.length || (codeword = this.codewords[n2]) == null) continue;
            return codeword;
        }
        return null;
    }

    final int imageRowToCodewordIndex(int n) {
        return n - this.boundingBox.getMinY();
    }

    final void setCodeword(int n, Codeword codeword) {
        this.codewords[this.imageRowToCodewordIndex((int)n)] = codeword;
    }

    final Codeword getCodeword(int n) {
        return this.codewords[this.imageRowToCodewordIndex(n)];
    }

    final BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    final Codeword[] getCodewords() {
        return this.codewords;
    }

    public String toString() {
        Formatter formatter = new Formatter();
        int n = 0;
        for (Codeword codeword : this.codewords) {
            if (codeword == null) {
                formatter.format("%3d:    |   \n", n++);
                continue;
            }
            formatter.format("%3d: %3d|%3d\n", n++, codeword.getRowNumber(), codeword.getValue());
        }
        String string = formatter.toString();
        formatter.close();
        return string;
    }
}

