/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.ResultPoint;
import com.google.zxing.pdf417.decoder.BarcodeMetadata;
import com.google.zxing.pdf417.decoder.BarcodeValue;
import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import com.google.zxing.pdf417.decoder.DetectionResultColumn;

final class DetectionResultRowIndicatorColumn
extends DetectionResultColumn {
    private final boolean isLeft;

    DetectionResultRowIndicatorColumn(BoundingBox boundingBox, boolean bl) {
        super(boundingBox);
        this.isLeft = bl;
    }

    void setRowNumbers() {
        for (Codeword codeword : this.getCodewords()) {
            if (codeword == null) continue;
            codeword.setRowNumberAsRowIndicatorColumn();
        }
    }

    int adjustCompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        Codeword[] codewordArray = this.getCodewords();
        this.setRowNumbers();
        this.removeIncorrectCodewords(codewordArray, barcodeMetadata);
        BoundingBox boundingBox = this.getBoundingBox();
        ResultPoint resultPoint = this.isLeft ? boundingBox.getTopLeft() : boundingBox.getTopRight();
        ResultPoint resultPoint2 = this.isLeft ? boundingBox.getBottomLeft() : boundingBox.getBottomRight();
        int n = this.imageRowToCodewordIndex((int)resultPoint.getY());
        int n2 = this.imageRowToCodewordIndex((int)resultPoint2.getY());
        float f = (float)(n2 - n) / (float)barcodeMetadata.getRowCount();
        int n3 = -1;
        int n4 = 1;
        int n5 = 0;
        for (int i = n; i < n2; ++i) {
            if (codewordArray[i] == null) continue;
            Codeword codeword = codewordArray[i];
            int n6 = codeword.getRowNumber() - n3;
            if (n6 == 0) {
                ++n5;
                continue;
            }
            if (n6 == 1) {
                n4 = Math.max(n4, n5);
                n5 = 1;
                n3 = codeword.getRowNumber();
                continue;
            }
            if (n6 < 0 || codeword.getRowNumber() >= barcodeMetadata.getRowCount() || n6 > i) {
                codewordArray[i] = null;
                continue;
            }
            int n7 = n4 > 2 ? (n4 - 2) * n6 : n6;
            boolean bl = n7 >= i;
            for (int j = 1; j <= n7 && !bl; ++j) {
                bl = codewordArray[i - j] != null;
            }
            if (bl) {
                codewordArray[i] = null;
                continue;
            }
            n3 = codeword.getRowNumber();
            n5 = 1;
        }
        return (int)((double)f + 0.5);
    }

    int[] getRowHeights() {
        BarcodeMetadata barcodeMetadata = this.getBarcodeMetadata();
        if (barcodeMetadata == null) {
            return null;
        }
        this.adjustIncompleteIndicatorColumnRowNumbers(barcodeMetadata);
        int[] nArray = new int[barcodeMetadata.getRowCount()];
        for (Codeword codeword : this.getCodewords()) {
            if (codeword == null) continue;
            int n = codeword.getRowNumber();
            nArray[n] = nArray[n] + 1;
        }
        return nArray;
    }

    int adjustIncompleteIndicatorColumnRowNumbers(BarcodeMetadata barcodeMetadata) {
        BoundingBox boundingBox = this.getBoundingBox();
        ResultPoint resultPoint = this.isLeft ? boundingBox.getTopLeft() : boundingBox.getTopRight();
        ResultPoint resultPoint2 = this.isLeft ? boundingBox.getBottomLeft() : boundingBox.getBottomRight();
        int n = this.imageRowToCodewordIndex((int)resultPoint.getY());
        int n2 = this.imageRowToCodewordIndex((int)resultPoint2.getY());
        float f = (float)(n2 - n) / (float)barcodeMetadata.getRowCount();
        Codeword[] codewordArray = this.getCodewords();
        int n3 = -1;
        int n4 = 1;
        int n5 = 0;
        for (int i = n; i < n2; ++i) {
            if (codewordArray[i] == null) continue;
            Codeword codeword = codewordArray[i];
            codeword.setRowNumberAsRowIndicatorColumn();
            int n6 = codeword.getRowNumber() - n3;
            if (n6 == 0) {
                ++n5;
                continue;
            }
            if (n6 == 1) {
                n4 = Math.max(n4, n5);
                n5 = 1;
                n3 = codeword.getRowNumber();
                continue;
            }
            if (codeword.getRowNumber() >= barcodeMetadata.getRowCount()) {
                codewordArray[i] = null;
                continue;
            }
            n3 = codeword.getRowNumber();
            n5 = 1;
        }
        return (int)((double)f + 0.5);
    }

    BarcodeMetadata getBarcodeMetadata() {
        Codeword[] codewordArray = this.getCodewords();
        BarcodeValue barcodeValue = new BarcodeValue();
        BarcodeValue barcodeValue2 = new BarcodeValue();
        BarcodeValue barcodeValue3 = new BarcodeValue();
        BarcodeValue barcodeValue4 = new BarcodeValue();
        block5: for (Codeword codeword : codewordArray) {
            if (codeword == null) continue;
            codeword.setRowNumberAsRowIndicatorColumn();
            int n = codeword.getValue() % 30;
            int n2 = codeword.getRowNumber();
            if (!this.isLeft) {
                n2 += 2;
            }
            switch (n2 % 3) {
                case 0: {
                    barcodeValue2.setValue(n * 3 + 1);
                    continue block5;
                }
                case 1: {
                    barcodeValue4.setValue(n / 3);
                    barcodeValue3.setValue(n % 3);
                    continue block5;
                }
                case 2: {
                    barcodeValue.setValue(n + 1);
                }
            }
        }
        if (barcodeValue.getValue().length == 0 || barcodeValue2.getValue().length == 0 || barcodeValue3.getValue().length == 0 || barcodeValue4.getValue().length == 0 || barcodeValue.getValue()[0] < 1 || barcodeValue2.getValue()[0] + barcodeValue3.getValue()[0] < 3 || barcodeValue2.getValue()[0] + barcodeValue3.getValue()[0] > 90) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = new BarcodeMetadata(barcodeValue.getValue()[0], barcodeValue2.getValue()[0], barcodeValue3.getValue()[0], barcodeValue4.getValue()[0]);
        this.removeIncorrectCodewords(codewordArray, barcodeMetadata);
        return barcodeMetadata;
    }

    private void removeIncorrectCodewords(Codeword[] codewordArray, BarcodeMetadata barcodeMetadata) {
        block5: for (int i = 0; i < codewordArray.length; ++i) {
            Codeword codeword = codewordArray[i];
            if (codewordArray[i] == null) continue;
            int n = codeword.getValue() % 30;
            int n2 = codeword.getRowNumber();
            if (n2 > barcodeMetadata.getRowCount()) {
                codewordArray[i] = null;
                continue;
            }
            if (!this.isLeft) {
                n2 += 2;
            }
            switch (n2 % 3) {
                case 0: {
                    if (n * 3 + 1 == barcodeMetadata.getRowCountUpperPart()) continue block5;
                    codewordArray[i] = null;
                    continue block5;
                }
                case 1: {
                    if (n / 3 == barcodeMetadata.getErrorCorrectionLevel() && n % 3 == barcodeMetadata.getRowCountLowerPart()) continue block5;
                    codewordArray[i] = null;
                    continue block5;
                }
                case 2: {
                    if (n + 1 == barcodeMetadata.getColumnCount()) continue block5;
                    codewordArray[i] = null;
                }
            }
        }
    }

    boolean isLeft() {
        return this.isLeft;
    }

    @Override
    public String toString() {
        return "IsLeft: " + this.isLeft + "\n" + super.toString();
    }
}

