/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder;

import com.google.zxing.ChecksumException;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.pdf417.PDF417Common;
import com.google.zxing.pdf417.decoder.BarcodeMetadata;
import com.google.zxing.pdf417.decoder.BarcodeValue;
import com.google.zxing.pdf417.decoder.BoundingBox;
import com.google.zxing.pdf417.decoder.Codeword;
import com.google.zxing.pdf417.decoder.DecodedBitStreamParser;
import com.google.zxing.pdf417.decoder.DetectionResult;
import com.google.zxing.pdf417.decoder.DetectionResultColumn;
import com.google.zxing.pdf417.decoder.DetectionResultRowIndicatorColumn;
import com.google.zxing.pdf417.decoder.PDF417CodewordDecoder;
import com.google.zxing.pdf417.decoder.ec.ErrorCorrection;
import java.util.ArrayList;
import java.util.Formatter;

public final class PDF417ScanningDecoder {
    private static final int CODEWORD_SKEW_SIZE = 2;
    private static final int MAX_ERRORS = 3;
    private static final int MAX_EC_CODEWORDS = 512;
    private static final ErrorCorrection errorCorrection = new ErrorCorrection();

    private PDF417ScanningDecoder() {
    }

    public static DecoderResult decode(BitMatrix bitMatrix, ResultPoint resultPoint, ResultPoint resultPoint2, ResultPoint resultPoint3, ResultPoint resultPoint4, int n, int n2) throws NotFoundException, FormatException, ChecksumException {
        int n3;
        BoundingBox boundingBox = new BoundingBox(bitMatrix, resultPoint, resultPoint2, resultPoint3, resultPoint4);
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = null;
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2 = null;
        DetectionResult detectionResult = null;
        for (n3 = 0; n3 < 2; ++n3) {
            if (resultPoint != null) {
                detectionResultRowIndicatorColumn = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, boundingBox, resultPoint, true, n, n2);
            }
            if (resultPoint3 != null) {
                detectionResultRowIndicatorColumn2 = PDF417ScanningDecoder.getRowIndicatorColumn(bitMatrix, boundingBox, resultPoint3, false, n, n2);
            }
            if ((detectionResult = PDF417ScanningDecoder.merge(detectionResultRowIndicatorColumn, detectionResultRowIndicatorColumn2)) == null) {
                throw NotFoundException.getNotFoundInstance();
            }
            if (n3 != 0 || detectionResult.getBoundingBox() == null || detectionResult.getBoundingBox().getMinY() >= boundingBox.getMinY() && detectionResult.getBoundingBox().getMaxY() <= boundingBox.getMaxY()) {
                detectionResult.setBoundingBox(boundingBox);
                break;
            }
            boundingBox = detectionResult.getBoundingBox();
        }
        n3 = detectionResult.getBarcodeColumnCount() + 1;
        detectionResult.setDetectionResultColumn(0, detectionResultRowIndicatorColumn);
        detectionResult.setDetectionResultColumn(n3, detectionResultRowIndicatorColumn2);
        boolean bl = detectionResultRowIndicatorColumn != null;
        for (int i = 1; i <= n3; ++i) {
            int n4;
            int n5;
            int n6 = n5 = bl ? i : n3 - i;
            if (detectionResult.getDetectionResultColumn(n5) != null) continue;
            DetectionResultColumn detectionResultColumn = n5 == 0 || n5 == n3 ? new DetectionResultRowIndicatorColumn(boundingBox, n5 == 0) : new DetectionResultColumn(boundingBox);
            detectionResult.setDetectionResultColumn(n5, detectionResultColumn);
            int n7 = n4 = -1;
            for (int j = boundingBox.getMinY(); j <= boundingBox.getMaxY(); ++j) {
                Codeword codeword;
                n4 = PDF417ScanningDecoder.getStartColumn(detectionResult, n5, j, bl);
                if (n4 < 0 || n4 > boundingBox.getMaxX()) {
                    if (n7 == -1) continue;
                    n4 = n7;
                }
                if ((codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix, boundingBox.getMinX(), boundingBox.getMaxX(), bl, n4, j, n, n2)) == null) continue;
                detectionResultColumn.setCodeword(j, codeword);
                n7 = n4;
                n = Math.min(n, codeword.getWidth());
                n2 = Math.max(n2, codeword.getWidth());
            }
        }
        return PDF417ScanningDecoder.createDecoderResult(detectionResult);
    }

    private static DetectionResult merge(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn, DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2) throws NotFoundException {
        if (detectionResultRowIndicatorColumn == null && detectionResultRowIndicatorColumn2 == null) {
            return null;
        }
        BarcodeMetadata barcodeMetadata = PDF417ScanningDecoder.getBarcodeMetadata(detectionResultRowIndicatorColumn, detectionResultRowIndicatorColumn2);
        if (barcodeMetadata == null) {
            return null;
        }
        BoundingBox boundingBox = BoundingBox.merge(PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn), PDF417ScanningDecoder.adjustBoundingBox(detectionResultRowIndicatorColumn2));
        return new DetectionResult(barcodeMetadata, boundingBox);
    }

    private static BoundingBox adjustBoundingBox(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn) throws NotFoundException {
        int n;
        if (detectionResultRowIndicatorColumn == null) {
            return null;
        }
        int[] nArray = detectionResultRowIndicatorColumn.getRowHeights();
        if (nArray == null) {
            return null;
        }
        int n2 = PDF417ScanningDecoder.getMax(nArray);
        int n3 = 0;
        for (int n4 : nArray) {
            n3 += n2 - n4;
            if (n4 > 0) break;
        }
        Codeword[] codewordArray = detectionResultRowIndicatorColumn.getCodewords();
        int n5 = 0;
        while (n3 > 0 && codewordArray[n5] == null) {
            --n3;
            ++n5;
        }
        n5 = 0;
        for (n = nArray.length - 1; n >= 0; --n) {
            n5 += n2 - nArray[n];
            if (nArray[n] > 0) break;
        }
        n = codewordArray.length - 1;
        while (n5 > 0 && codewordArray[n] == null) {
            --n5;
            --n;
        }
        return detectionResultRowIndicatorColumn.getBoundingBox().addMissingRows(n3, n5, detectionResultRowIndicatorColumn.isLeft());
    }

    private static int getMax(int[] nArray) {
        int n = -1;
        for (int n2 : nArray) {
            n = Math.max(n, n2);
        }
        return n;
    }

    private static BarcodeMetadata getBarcodeMetadata(DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn, DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn2) {
        if (detectionResultRowIndicatorColumn == null || detectionResultRowIndicatorColumn.getBarcodeMetadata() == null) {
            return detectionResultRowIndicatorColumn2 == null ? null : detectionResultRowIndicatorColumn2.getBarcodeMetadata();
        }
        if (detectionResultRowIndicatorColumn2 == null || detectionResultRowIndicatorColumn2.getBarcodeMetadata() == null) {
            return detectionResultRowIndicatorColumn == null ? null : detectionResultRowIndicatorColumn.getBarcodeMetadata();
        }
        BarcodeMetadata barcodeMetadata = detectionResultRowIndicatorColumn.getBarcodeMetadata();
        BarcodeMetadata barcodeMetadata2 = detectionResultRowIndicatorColumn2.getBarcodeMetadata();
        if (barcodeMetadata.getColumnCount() != barcodeMetadata2.getColumnCount() && barcodeMetadata.getErrorCorrectionLevel() != barcodeMetadata2.getErrorCorrectionLevel() && barcodeMetadata.getRowCount() != barcodeMetadata2.getRowCount()) {
            return null;
        }
        return barcodeMetadata;
    }

    private static DetectionResultRowIndicatorColumn getRowIndicatorColumn(BitMatrix bitMatrix, BoundingBox boundingBox, ResultPoint resultPoint, boolean bl, int n, int n2) {
        DetectionResultRowIndicatorColumn detectionResultRowIndicatorColumn = new DetectionResultRowIndicatorColumn(boundingBox, bl);
        for (int i = 0; i < 2; ++i) {
            int n3 = i == 0 ? 1 : -1;
            int n4 = (int)resultPoint.getX();
            for (int j = (int)resultPoint.getY(); j <= boundingBox.getMaxY() && j >= boundingBox.getMinY(); j += n3) {
                Codeword codeword = PDF417ScanningDecoder.detectCodeword(bitMatrix, 0, bitMatrix.getWidth(), bl, n4, j, n, n2);
                if (codeword == null) continue;
                detectionResultRowIndicatorColumn.setCodeword(j, codeword);
                n4 = bl ? codeword.getStartX() : codeword.getEndX();
            }
        }
        return detectionResultRowIndicatorColumn;
    }

    private static void adjustCodewordCount(DetectionResult detectionResult, BarcodeValue[][] barcodeValueArray) throws NotFoundException {
        int[] nArray = barcodeValueArray[0][1].getValue();
        int n = detectionResult.getBarcodeColumnCount() * detectionResult.getBarcodeRowCount() - PDF417ScanningDecoder.getNumberOfECCodeWords(detectionResult.getBarcodeECLevel());
        if (nArray.length == 0) {
            if (n < 1 || n > 928) {
                throw NotFoundException.getNotFoundInstance();
            }
            barcodeValueArray[0][1].setValue(n);
        } else if (nArray[0] != n) {
            barcodeValueArray[0][1].setValue(n);
        }
    }

    private static DecoderResult createDecoderResult(DetectionResult detectionResult) throws FormatException, ChecksumException, NotFoundException {
        int n;
        BarcodeValue[][] barcodeValueArray = PDF417ScanningDecoder.createBarcodeMatrix(detectionResult);
        PDF417ScanningDecoder.adjustCodewordCount(detectionResult, barcodeValueArray);
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int[] nArray = new int[detectionResult.getBarcodeRowCount() * detectionResult.getBarcodeColumnCount()];
        ArrayList<int[]> arrayList2 = new ArrayList<int[]>();
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
        for (int i = 0; i < detectionResult.getBarcodeRowCount(); ++i) {
            for (n = 0; n < detectionResult.getBarcodeColumnCount(); ++n) {
                int[] nArray2 = barcodeValueArray[i][n + 1].getValue();
                int n2 = i * detectionResult.getBarcodeColumnCount() + n;
                if (nArray2.length == 0) {
                    arrayList.add(n2);
                    continue;
                }
                if (nArray2.length == 1) {
                    nArray[n2] = nArray2[0];
                    continue;
                }
                arrayList3.add(n2);
                arrayList2.add(nArray2);
            }
        }
        int[][] nArrayArray = new int[arrayList2.size()][];
        for (n = 0; n < nArrayArray.length; ++n) {
            nArrayArray[n] = (int[])arrayList2.get(n);
        }
        return PDF417ScanningDecoder.createDecoderResultFromAmbiguousValues(detectionResult.getBarcodeECLevel(), nArray, PDF417Common.toIntArray(arrayList), PDF417Common.toIntArray(arrayList3), nArrayArray);
    }

    private static DecoderResult createDecoderResultFromAmbiguousValues(int n, int[] nArray, int[] nArray2, int[] nArray3, int[][] nArray4) throws FormatException, ChecksumException {
        int[] nArray5 = new int[nArray3.length];
        int n2 = 100;
        block2: while (n2-- > 0) {
            int n3;
            for (n3 = 0; n3 < nArray5.length; ++n3) {
                nArray[nArray3[n3]] = nArray4[n3][nArray5[n3]];
            }
            try {
                return PDF417ScanningDecoder.decodeCodewords(nArray, n, nArray2);
            }
            catch (ChecksumException checksumException) {
                if (nArray5.length == 0) {
                    throw ChecksumException.getChecksumInstance();
                }
                for (n3 = 0; n3 < nArray5.length; ++n3) {
                    if (nArray5[n3] < nArray4[n3].length - 1) {
                        int n4 = n3;
                        nArray5[n4] = nArray5[n4] + 1;
                        continue block2;
                    }
                    nArray5[n3] = 0;
                    if (n3 != nArray5.length - 1) continue;
                    throw ChecksumException.getChecksumInstance();
                }
            }
        }
        throw ChecksumException.getChecksumInstance();
    }

    private static BarcodeValue[][] createBarcodeMatrix(DetectionResult detectionResult) {
        int n;
        BarcodeValue[][] barcodeValueArray = new BarcodeValue[detectionResult.getBarcodeRowCount()][detectionResult.getBarcodeColumnCount() + 2];
        for (n = 0; n < barcodeValueArray.length; ++n) {
            for (int i = 0; i < barcodeValueArray[n].length; ++i) {
                barcodeValueArray[n][i] = new BarcodeValue();
            }
        }
        n = -1;
        for (DetectionResultColumn detectionResultColumn : detectionResult.getDetectionResultColumns()) {
            ++n;
            if (detectionResultColumn == null) continue;
            for (Codeword codeword : detectionResultColumn.getCodewords()) {
                if (codeword == null || codeword.getRowNumber() == -1) continue;
                barcodeValueArray[codeword.getRowNumber()][n].setValue(codeword.getValue());
            }
        }
        return barcodeValueArray;
    }

    private static boolean isValidBarcodeColumn(DetectionResult detectionResult, int n) {
        return n >= 0 && n <= detectionResult.getBarcodeColumnCount() + 1;
    }

    private static int getStartColumn(DetectionResult detectionResult, int n, int n2, boolean bl) {
        int n3 = bl ? 1 : -1;
        Codeword codeword = null;
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n - n3)) {
            codeword = detectionResult.getDetectionResultColumn(n - n3).getCodeword(n2);
        }
        if (codeword != null) {
            return bl ? codeword.getEndX() : codeword.getStartX();
        }
        codeword = detectionResult.getDetectionResultColumn(n).getCodewordNearby(n2);
        if (codeword != null) {
            return bl ? codeword.getStartX() : codeword.getEndX();
        }
        if (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n - n3)) {
            codeword = detectionResult.getDetectionResultColumn(n - n3).getCodewordNearby(n2);
        }
        if (codeword != null) {
            return bl ? codeword.getEndX() : codeword.getStartX();
        }
        int n4 = 0;
        while (PDF417ScanningDecoder.isValidBarcodeColumn(detectionResult, n - n3)) {
            for (Codeword codeword2 : detectionResult.getDetectionResultColumn(n -= n3).getCodewords()) {
                if (codeword2 == null) continue;
                return (bl ? codeword2.getEndX() : codeword2.getStartX()) + n3 * n4 * (codeword2.getEndX() - codeword2.getStartX());
            }
            ++n4;
        }
        return bl ? detectionResult.getBoundingBox().getMinX() : detectionResult.getBoundingBox().getMaxX();
    }

    private static Codeword detectCodeword(BitMatrix bitMatrix, int n, int n2, boolean bl, int n3, int n4, int n5, int n6) {
        int n7;
        int n8;
        int n9;
        int[] nArray = PDF417ScanningDecoder.getModuleBitCount(bitMatrix, n, n2, bl, n3 = PDF417ScanningDecoder.adjustCodewordStartColumn(bitMatrix, n, n2, bl, n3, n4), n4);
        if (nArray == null) {
            return null;
        }
        int n10 = PDF417Common.getBitCountSum(nArray);
        if (bl) {
            n9 = n3 + n10;
        } else {
            for (n8 = 0; n8 < nArray.length >> 1; ++n8) {
                n7 = nArray[n8];
                nArray[n8] = nArray[nArray.length - 1 - n8];
                nArray[nArray.length - 1 - n8] = n7;
            }
            n9 = n3;
            n3 = n9 - n10;
        }
        if (!PDF417ScanningDecoder.checkCodewordSkew(n10, n5, n6)) {
            return null;
        }
        n8 = PDF417CodewordDecoder.getDecodedValue(nArray);
        n7 = PDF417Common.getCodeword(n8);
        if (n7 == -1) {
            return null;
        }
        return new Codeword(n3, n9, PDF417ScanningDecoder.getCodewordBucketNumber(n8), n7);
    }

    private static int[] getModuleBitCount(BitMatrix bitMatrix, int n, int n2, boolean bl, int n3, int n4) {
        int n5 = n3;
        int[] nArray = new int[8];
        int n6 = 0;
        int n7 = bl ? 1 : -1;
        boolean bl2 = bl;
        while ((bl && n5 < n2 || !bl && n5 >= n) && n6 < nArray.length) {
            if (bitMatrix.get(n5, n4) == bl2) {
                int n8 = n6;
                nArray[n8] = nArray[n8] + 1;
                n5 += n7;
                continue;
            }
            ++n6;
            bl2 = !bl2;
        }
        if (n6 == nArray.length || (bl && n5 == n2 || !bl && n5 == n) && n6 == nArray.length - 1) {
            return nArray;
        }
        return null;
    }

    private static int getNumberOfECCodeWords(int n) {
        return 2 << n;
    }

    private static int adjustCodewordStartColumn(BitMatrix bitMatrix, int n, int n2, boolean bl, int n3, int n4) {
        int n5 = n3;
        int n6 = bl ? -1 : 1;
        for (int i = 0; i < 2; ++i) {
            while ((bl && n5 >= n || !bl && n5 < n2) && bl == bitMatrix.get(n5, n4)) {
                if (Math.abs(n3 - n5) > 2) {
                    return n3;
                }
                n5 += n6;
            }
            n6 = -n6;
            bl = !bl;
        }
        return n5;
    }

    private static boolean checkCodewordSkew(int n, int n2, int n3) {
        return n2 - 2 <= n && n <= n3 + 2;
    }

    private static DecoderResult decodeCodewords(int[] nArray, int n, int[] nArray2) throws FormatException, ChecksumException {
        if (nArray.length == 0) {
            throw FormatException.getFormatInstance();
        }
        int n2 = 1 << n + 1;
        int n3 = PDF417ScanningDecoder.correctErrors(nArray, nArray2, n2);
        PDF417ScanningDecoder.verifyCodewordCount(nArray, n2);
        DecoderResult decoderResult = DecodedBitStreamParser.decode(nArray, String.valueOf(n));
        decoderResult.setErrorsCorrected(n3);
        decoderResult.setErasures(nArray2.length);
        return decoderResult;
    }

    private static int correctErrors(int[] nArray, int[] nArray2, int n) throws ChecksumException {
        if (nArray2 != null && nArray2.length > n / 2 + 3 || n < 0 || n > 512) {
            throw ChecksumException.getChecksumInstance();
        }
        return errorCorrection.decode(nArray, n, nArray2);
    }

    private static void verifyCodewordCount(int[] nArray, int n) throws FormatException {
        if (nArray.length < 4) {
            throw FormatException.getFormatInstance();
        }
        int n2 = nArray[0];
        if (n2 > nArray.length) {
            throw FormatException.getFormatInstance();
        }
        if (n2 == 0) {
            if (n < nArray.length) {
                nArray[0] = nArray.length - n;
            } else {
                throw FormatException.getFormatInstance();
            }
        }
    }

    private static int[] getBitCountForCodeword(int n) {
        int[] nArray = new int[8];
        int n2 = 0;
        int n3 = nArray.length - 1;
        while (true) {
            if ((n & 1) != n2) {
                n2 = n & 1;
                if (--n3 < 0) break;
            }
            int n4 = n3;
            nArray[n4] = nArray[n4] + 1;
            n >>= 1;
        }
        return nArray;
    }

    private static int getCodewordBucketNumber(int n) {
        return PDF417ScanningDecoder.getCodewordBucketNumber(PDF417ScanningDecoder.getBitCountForCodeword(n));
    }

    private static int getCodewordBucketNumber(int[] nArray) {
        return (nArray[0] - nArray[2] + nArray[4] - nArray[6] + 9) % 9;
    }

    public static String toString(BarcodeValue[][] barcodeValueArray) {
        Formatter formatter = new Formatter();
        for (int i = 0; i < barcodeValueArray.length; ++i) {
            formatter.format("Row %2d: ", i);
            for (int j = 0; j < barcodeValueArray[i].length; ++j) {
                BarcodeValue barcodeValue = barcodeValueArray[i][j];
                if (barcodeValue.getValue().length == 0) {
                    formatter.format("        ", (Object[])null);
                    continue;
                }
                formatter.format("%4d(%2d)", barcodeValue.getValue()[0], barcodeValue.getConfidence(barcodeValue.getValue()[0]));
            }
            formatter.format("\n", new Object[0]);
        }
        String string = formatter.toString();
        formatter.close();
        return string;
    }
}

