/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.pdf417.decoder.ec;

import com.google.zxing.pdf417.decoder.ec.ModulusGF;

final class ModulusPoly {
    private final ModulusGF field;
    private final int[] coefficients;

    ModulusPoly(ModulusGF modulusGF, int[] nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException();
        }
        this.field = modulusGF;
        int n = nArray.length;
        if (n > 1 && nArray[0] == 0) {
            int n2;
            for (n2 = 1; n2 < n && nArray[n2] == 0; ++n2) {
            }
            if (n2 == n) {
                this.coefficients = modulusGF.getZero().coefficients;
            } else {
                this.coefficients = new int[n - n2];
                System.arraycopy(nArray, n2, this.coefficients, 0, this.coefficients.length);
            }
        } else {
            this.coefficients = nArray;
        }
    }

    int[] getCoefficients() {
        return this.coefficients;
    }

    int getDegree() {
        return this.coefficients.length - 1;
    }

    boolean isZero() {
        return this.coefficients[0] == 0;
    }

    int getCoefficient(int n) {
        return this.coefficients[this.coefficients.length - 1 - n];
    }

    int evaluateAt(int n) {
        if (n == 0) {
            return this.getCoefficient(0);
        }
        int n2 = this.coefficients.length;
        if (n == 1) {
            int n3 = 0;
            for (int n4 : this.coefficients) {
                n3 = this.field.add(n3, n4);
            }
            return n3;
        }
        int n5 = this.coefficients[0];
        for (int i = 1; i < n2; ++i) {
            n5 = this.field.add(this.field.multiply(n, n5), this.coefficients[i]);
        }
        return n5;
    }

    ModulusPoly add(ModulusPoly modulusPoly) {
        int[] nArray;
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (this.isZero()) {
            return modulusPoly;
        }
        if (modulusPoly.isZero()) {
            return this;
        }
        int[] nArray2 = this.coefficients;
        int[] nArray3 = modulusPoly.coefficients;
        if (nArray2.length > nArray3.length) {
            nArray = nArray2;
            nArray2 = nArray3;
            nArray3 = nArray;
        }
        nArray = new int[nArray3.length];
        int n = nArray3.length - nArray2.length;
        System.arraycopy(nArray3, 0, nArray, 0, n);
        for (int i = n; i < nArray3.length; ++i) {
            nArray[i] = this.field.add(nArray2[i - n], nArray3[i]);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly subtract(ModulusPoly modulusPoly) {
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (modulusPoly.isZero()) {
            return this;
        }
        return this.add(modulusPoly.negative());
    }

    ModulusPoly multiply(ModulusPoly modulusPoly) {
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (this.isZero() || modulusPoly.isZero()) {
            return this.field.getZero();
        }
        int[] nArray = this.coefficients;
        int n = nArray.length;
        int[] nArray2 = modulusPoly.coefficients;
        int n2 = nArray2.length;
        int[] nArray3 = new int[n + n2 - 1];
        for (int i = 0; i < n; ++i) {
            int n3 = nArray[i];
            for (int j = 0; j < n2; ++j) {
                nArray3[i + j] = this.field.add(nArray3[i + j], this.field.multiply(n3, nArray2[j]));
            }
        }
        return new ModulusPoly(this.field, nArray3);
    }

    ModulusPoly negative() {
        int n = this.coefficients.length;
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray[i] = this.field.subtract(0, this.coefficients[i]);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiply(int n) {
        if (n == 0) {
            return this.field.getZero();
        }
        if (n == 1) {
            return this;
        }
        int n2 = this.coefficients.length;
        int[] nArray = new int[n2];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = this.field.multiply(this.coefficients[i], n);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly multiplyByMonomial(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n2 == 0) {
            return this.field.getZero();
        }
        int n3 = this.coefficients.length;
        int[] nArray = new int[n3 + n];
        for (int i = 0; i < n3; ++i) {
            nArray[i] = this.field.multiply(this.coefficients[i], n2);
        }
        return new ModulusPoly(this.field, nArray);
    }

    ModulusPoly[] divide(ModulusPoly modulusPoly) {
        if (!this.field.equals(modulusPoly.field)) {
            throw new IllegalArgumentException("ModulusPolys do not have same ModulusGF field");
        }
        if (modulusPoly.isZero()) {
            throw new IllegalArgumentException("Divide by 0");
        }
        ModulusPoly modulusPoly2 = this.field.getZero();
        ModulusPoly modulusPoly3 = this;
        int n = modulusPoly.getCoefficient(modulusPoly.getDegree());
        int n2 = this.field.inverse(n);
        while (modulusPoly3.getDegree() >= modulusPoly.getDegree() && !modulusPoly3.isZero()) {
            int n3 = modulusPoly3.getDegree() - modulusPoly.getDegree();
            int n4 = this.field.multiply(modulusPoly3.getCoefficient(modulusPoly3.getDegree()), n2);
            ModulusPoly modulusPoly4 = modulusPoly.multiplyByMonomial(n3, n4);
            ModulusPoly modulusPoly5 = this.field.buildMonomial(n3, n4);
            modulusPoly2 = modulusPoly2.add(modulusPoly5);
            modulusPoly3 = modulusPoly3.subtract(modulusPoly4);
        }
        return new ModulusPoly[]{modulusPoly2, modulusPoly3};
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(8 * this.getDegree());
        for (int i = this.getDegree(); i >= 0; --i) {
            int n = this.getCoefficient(i);
            if (n == 0) continue;
            if (n < 0) {
                stringBuilder.append(" - ");
                n = -n;
            } else if (stringBuilder.length() > 0) {
                stringBuilder.append(" + ");
            }
            if (i == 0 || n != 1) {
                stringBuilder.append(n);
            }
            if (i == 0) continue;
            if (i == 1) {
                stringBuilder.append('x');
                continue;
            }
            stringBuilder.append("x^");
            stringBuilder.append(i);
        }
        return stringBuilder.toString();
    }
}

