/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode;

import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.ChecksumException;
import com.google.zxing.DecodeHintType;
import com.google.zxing.FormatException;
import com.google.zxing.NotFoundException;
import com.google.zxing.Reader;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.common.DecoderResult;
import com.google.zxing.common.DetectorResult;
import com.google.zxing.qrcode.decoder.Decoder;
import com.google.zxing.qrcode.decoder.QRCodeDecoderMetaData;
import com.google.zxing.qrcode.detector.Detector;
import java.util.List;
import java.util.Map;

public class QRCodeReader
implements Reader {
    private static final ResultPoint[] NO_POINTS = new ResultPoint[0];
    private final Decoder decoder = new Decoder();

    protected final Decoder getDecoder() {
        return this.decoder;
    }

    @Override
    public Result decode(BinaryBitmap binaryBitmap) throws NotFoundException, ChecksumException, FormatException {
        return this.decode(binaryBitmap, null);
    }

    @Override
    public final Result decode(BinaryBitmap binaryBitmap, Map<DecodeHintType, ?> map) throws NotFoundException, ChecksumException, FormatException {
        String string;
        ResultPoint[] resultPointArray;
        DecoderResult decoderResult;
        Object object;
        if (map != null && map.containsKey((Object)DecodeHintType.PURE_BARCODE)) {
            object = QRCodeReader.extractPureBits(binaryBitmap.getBlackMatrix());
            decoderResult = this.decoder.decode((BitMatrix)object, map);
            resultPointArray = NO_POINTS;
        } else {
            object = new Detector(binaryBitmap.getBlackMatrix()).detect(map);
            decoderResult = this.decoder.decode(((DetectorResult)object).getBits(), map);
            resultPointArray = ((DetectorResult)object).getPoints();
        }
        if (decoderResult.getOther() instanceof QRCodeDecoderMetaData) {
            ((QRCodeDecoderMetaData)decoderResult.getOther()).applyMirroredCorrection(resultPointArray);
        }
        object = new Result(decoderResult.getText(), decoderResult.getRawBytes(), resultPointArray, BarcodeFormat.QR_CODE);
        List<byte[]> list = decoderResult.getByteSegments();
        if (list != null) {
            ((Result)object).putMetadata(ResultMetadataType.BYTE_SEGMENTS, list);
        }
        if ((string = decoderResult.getECLevel()) != null) {
            ((Result)object).putMetadata(ResultMetadataType.ERROR_CORRECTION_LEVEL, string);
        }
        return object;
    }

    @Override
    public void reset() {
    }

    private static BitMatrix extractPureBits(BitMatrix bitMatrix) throws NotFoundException {
        int n;
        int[] nArray = bitMatrix.getTopLeftOnBit();
        int[] nArray2 = bitMatrix.getBottomRightOnBit();
        if (nArray == null || nArray2 == null) {
            throw NotFoundException.getNotFoundInstance();
        }
        float f = QRCodeReader.moduleSize(nArray, bitMatrix);
        int n2 = nArray[1];
        int n3 = nArray2[1];
        int n4 = nArray[0];
        int n5 = nArray2[0];
        if (n4 >= n5 || n2 >= n3) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n3 - n2 != n5 - n4) {
            n5 = n4 + (n3 - n2);
        }
        int n6 = Math.round((float)(n5 - n4 + 1) / f);
        int n7 = Math.round((float)(n3 - n2 + 1) / f);
        if (n6 <= 0 || n7 <= 0) {
            throw NotFoundException.getNotFoundInstance();
        }
        if (n7 != n6) {
            throw NotFoundException.getNotFoundInstance();
        }
        int n8 = (int)(f / 2.0f);
        n2 += n8;
        int n9 = (n4 += n8) + (int)((float)(n6 - 1) * f) - (n5 - 1);
        if (n9 > 0) {
            if (n9 > n8) {
                throw NotFoundException.getNotFoundInstance();
            }
            n4 -= n9;
        }
        if ((n = n2 + (int)((float)(n7 - 1) * f) - (n3 - 1)) > 0) {
            if (n > n8) {
                throw NotFoundException.getNotFoundInstance();
            }
            n2 -= n;
        }
        BitMatrix bitMatrix2 = new BitMatrix(n6, n7);
        for (int i = 0; i < n7; ++i) {
            int n10 = n2 + (int)((float)i * f);
            for (int j = 0; j < n6; ++j) {
                if (!bitMatrix.get(n4 + (int)((float)j * f), n10)) continue;
                bitMatrix2.set(j, i);
            }
        }
        return bitMatrix2;
    }

    private static float moduleSize(int[] nArray, BitMatrix bitMatrix) throws NotFoundException {
        int n;
        int n2 = bitMatrix.getHeight();
        int n3 = bitMatrix.getWidth();
        int n4 = nArray[0];
        boolean bl = true;
        int n5 = 0;
        for (n = nArray[1]; n4 < n3 && n < n2; ++n4, ++n) {
            if (bl == bitMatrix.get(n4, n)) continue;
            if (++n5 == 5) break;
            bl = !bl;
        }
        if (n4 == n3 || n == n2) {
            throw NotFoundException.getNotFoundInstance();
        }
        return (float)(n4 - nArray[0]) / 7.0f;
    }
}

