/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.FormatException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.DataMask;
import com.google.zxing.qrcode.decoder.FormatInformation;
import com.google.zxing.qrcode.decoder.Version;

final class BitMatrixParser {
    private final BitMatrix bitMatrix;
    private Version parsedVersion;
    private FormatInformation parsedFormatInfo;
    private boolean mirror;

    BitMatrixParser(BitMatrix bitMatrix) throws FormatException {
        int n = bitMatrix.getHeight();
        if (n < 21 || (n & 3) != 1) {
            throw FormatException.getFormatInstance();
        }
        this.bitMatrix = bitMatrix;
    }

    FormatInformation readFormatInformation() throws FormatException {
        int n;
        int n2;
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        int n3 = 0;
        for (n2 = 0; n2 < 6; ++n2) {
            n3 = this.copyBit(n2, 8, n3);
        }
        n3 = this.copyBit(7, 8, n3);
        n3 = this.copyBit(8, 8, n3);
        n3 = this.copyBit(8, 7, n3);
        for (n2 = 5; n2 >= 0; --n2) {
            n3 = this.copyBit(8, n2, n3);
        }
        n2 = this.bitMatrix.getHeight();
        int n4 = 0;
        int n5 = n2 - 7;
        for (n = n2 - 1; n >= n5; --n) {
            n4 = this.copyBit(8, n, n4);
        }
        for (n = n2 - 8; n < n2; ++n) {
            n4 = this.copyBit(n, 8, n4);
        }
        this.parsedFormatInfo = FormatInformation.decodeFormatInformation(n3, n4);
        if (this.parsedFormatInfo != null) {
            return this.parsedFormatInfo;
        }
        throw FormatException.getFormatInstance();
    }

    Version readVersion() throws FormatException {
        int n;
        if (this.parsedVersion != null) {
            return this.parsedVersion;
        }
        int n2 = this.bitMatrix.getHeight();
        int n3 = n2 - 17 >> 2;
        if (n3 <= 6) {
            return Version.getVersionForNumber(n3);
        }
        int n4 = 0;
        int n5 = n2 - 11;
        for (int i = 5; i >= 0; --i) {
            for (n = n2 - 9; n >= n5; --n) {
                n4 = this.copyBit(n, i, n4);
            }
        }
        Version version = Version.decodeVersionInformation(n4);
        if (version != null && version.getDimensionForVersion() == n2) {
            this.parsedVersion = version;
            return version;
        }
        n4 = 0;
        for (n = 5; n >= 0; --n) {
            for (int i = n2 - 9; i >= n5; --i) {
                n4 = this.copyBit(n, i, n4);
            }
        }
        version = Version.decodeVersionInformation(n4);
        if (version != null && version.getDimensionForVersion() == n2) {
            this.parsedVersion = version;
            return version;
        }
        throw FormatException.getFormatInstance();
    }

    private int copyBit(int n, int n2, int n3) {
        boolean bl = this.mirror ? this.bitMatrix.get(n2, n) : this.bitMatrix.get(n, n2);
        return bl ? n3 << 1 | 1 : n3 << 1;
    }

    byte[] readCodewords() throws FormatException {
        FormatInformation formatInformation = this.readFormatInformation();
        Version version = this.readVersion();
        DataMask dataMask = DataMask.forReference(formatInformation.getDataMask());
        int n = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, n);
        BitMatrix bitMatrix = version.buildFunctionPattern();
        boolean bl = true;
        byte[] byArray = new byte[version.getTotalCodewords()];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = n - 1; i > 0; i -= 2) {
            if (i == 6) {
                --i;
            }
            for (int j = 0; j < n; ++j) {
                int n5 = bl ? n - 1 - j : j;
                for (int k = 0; k < 2; ++k) {
                    if (bitMatrix.get(i - k, n5)) continue;
                    ++n4;
                    n3 <<= 1;
                    if (this.bitMatrix.get(i - k, n5)) {
                        n3 |= 1;
                    }
                    if (n4 != 8) continue;
                    byArray[n2++] = (byte)n3;
                    n4 = 0;
                    n3 = 0;
                }
            }
            bl ^= true;
        }
        if (n2 != version.getTotalCodewords()) {
            throw FormatException.getFormatInstance();
        }
        return byArray;
    }

    void remask() {
        if (this.parsedFormatInfo == null) {
            return;
        }
        DataMask dataMask = DataMask.forReference(this.parsedFormatInfo.getDataMask());
        int n = this.bitMatrix.getHeight();
        dataMask.unmaskBitMatrix(this.bitMatrix, n);
    }

    void setMirror(boolean bl) {
        this.parsedVersion = null;
        this.parsedFormatInfo = null;
        this.mirror = bl;
    }

    void mirror() {
        for (int i = 0; i < this.bitMatrix.getWidth(); ++i) {
            for (int j = i + 1; j < this.bitMatrix.getHeight(); ++j) {
                if (this.bitMatrix.get(i, j) == this.bitMatrix.get(j, i)) continue;
                this.bitMatrix.flip(j, i);
                this.bitMatrix.flip(i, j);
            }
        }
    }
}

