/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.decoder;

import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Version;

final class DataBlock {
    private final int numDataCodewords;
    private final byte[] codewords;

    private DataBlock(int n, byte[] byArray) {
        this.numDataCodewords = n;
        this.codewords = byArray;
    }

    static DataBlock[] getDataBlocks(byte[] byArray, Version version, ErrorCorrectionLevel errorCorrectionLevel) {
        int n;
        int n2;
        int n3;
        int n4;
        if (byArray.length != version.getTotalCodewords()) {
            throw new IllegalArgumentException();
        }
        Version.ECBlocks eCBlocks = version.getECBlocksForLevel(errorCorrectionLevel);
        int n5 = 0;
        Version.ECB[] eCBArray = eCBlocks.getECBlocks();
        for (Version.ECB eCB : eCBArray) {
            n5 += eCB.getCount();
        }
        Object[] objectArray = new DataBlock[n5];
        int n6 = 0;
        Version.ECB[] eCBArray2 = eCBArray;
        int n7 = eCBArray2.length;
        for (n4 = 0; n4 < n7; ++n4) {
            Version.ECB eCB = eCBArray2[n4];
            for (n3 = 0; n3 < eCB.getCount(); ++n3) {
                n2 = eCB.getDataCodewords();
                n = eCBlocks.getECCodewordsPerBlock() + n2;
                objectArray[n6++] = new DataBlock(n2, new byte[n]);
            }
        }
        int n8 = ((DataBlock)objectArray[0]).codewords.length;
        for (n7 = objectArray.length - 1; n7 >= 0 && (n4 = ((DataBlock)objectArray[n7]).codewords.length) != n8; --n7) {
        }
        ++n7;
        n4 = n8 - eCBlocks.getECCodewordsPerBlock();
        int n9 = 0;
        for (n3 = 0; n3 < n4; ++n3) {
            for (n2 = 0; n2 < n6; ++n2) {
                ((DataBlock)objectArray[n2]).codewords[n3] = byArray[n9++];
            }
        }
        for (n3 = n7; n3 < n6; ++n3) {
            ((DataBlock)objectArray[n3]).codewords[n4] = byArray[n9++];
        }
        n3 = ((DataBlock)objectArray[0]).codewords.length;
        for (n2 = n4; n2 < n3; ++n2) {
            for (n = 0; n < n6; ++n) {
                int n10 = n < n7 ? n2 : n2 + 1;
                ((DataBlock)objectArray[n]).codewords[n10] = byArray[n9++];
            }
        }
        return objectArray;
    }

    int getNumDataCodewords() {
        return this.numDataCodewords;
    }

    byte[] getCodewords() {
        return this.codewords;
    }
}

