/*
 * Decompiled with CFR 0.152.
 */
package com.google.zxing.qrcode.encoder;

import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitArray;
import com.google.zxing.common.CharacterSetECI;
import com.google.zxing.common.reedsolomon.GenericGF;
import com.google.zxing.common.reedsolomon.ReedSolomonEncoder;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.decoder.Mode;
import com.google.zxing.qrcode.decoder.Version;
import com.google.zxing.qrcode.encoder.BlockPair;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.MaskUtil;
import com.google.zxing.qrcode.encoder.MatrixUtil;
import com.google.zxing.qrcode.encoder.QRCode;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Map;

public final class Encoder {
    private static final int[] ALPHANUMERIC_TABLE = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 36, -1, -1, -1, 37, 38, -1, -1, -1, -1, 39, 40, -1, 41, 42, 43, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 44, -1, -1, -1, -1, -1, -1, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, -1, -1, -1, -1, -1};
    static final String DEFAULT_BYTE_MODE_ENCODING = "ISO-8859-1";

    private Encoder() {
    }

    private static int calculateMaskPenalty(ByteMatrix byteMatrix) {
        return MaskUtil.applyMaskPenaltyRule1(byteMatrix) + MaskUtil.applyMaskPenaltyRule2(byteMatrix) + MaskUtil.applyMaskPenaltyRule3(byteMatrix) + MaskUtil.applyMaskPenaltyRule4(byteMatrix);
    }

    public static QRCode encode(String string, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        return Encoder.encode(string, errorCorrectionLevel, null);
    }

    public static QRCode encode(String string, ErrorCorrectionLevel errorCorrectionLevel, Map<EncodeHintType, ?> map) throws WriterException {
        Object object;
        String string2;
        String string3 = string2 = map == null ? null : (String)map.get((Object)EncodeHintType.CHARACTER_SET);
        if (string2 == null) {
            string2 = DEFAULT_BYTE_MODE_ENCODING;
        }
        Mode mode = Encoder.chooseMode(string, string2);
        BitArray bitArray = new BitArray();
        if (mode == Mode.BYTE && !DEFAULT_BYTE_MODE_ENCODING.equals(string2) && (object = CharacterSetECI.getCharacterSetECIByName(string2)) != null) {
            Encoder.appendECI((CharacterSetECI)((Object)object), bitArray);
        }
        Encoder.appendModeInfo(mode, bitArray);
        object = new BitArray();
        Encoder.appendBytes(string, mode, (BitArray)object, string2);
        int n = bitArray.getSize() + mode.getCharacterCountBits(Version.getVersionForNumber(1)) + ((BitArray)object).getSize();
        Version version = Encoder.chooseVersion(n, errorCorrectionLevel);
        int n2 = bitArray.getSize() + mode.getCharacterCountBits(version) + ((BitArray)object).getSize();
        Version version2 = Encoder.chooseVersion(n2, errorCorrectionLevel);
        BitArray bitArray2 = new BitArray();
        bitArray2.appendBitArray(bitArray);
        int n3 = mode == Mode.BYTE ? ((BitArray)object).getSizeInBytes() : string.length();
        Encoder.appendLengthInfo(n3, version2, mode, bitArray2);
        bitArray2.appendBitArray((BitArray)object);
        Version.ECBlocks eCBlocks = version2.getECBlocksForLevel(errorCorrectionLevel);
        int n4 = version2.getTotalCodewords() - eCBlocks.getTotalECCodewords();
        Encoder.terminateBits(n4, bitArray2);
        BitArray bitArray3 = Encoder.interleaveWithECBytes(bitArray2, version2.getTotalCodewords(), n4, eCBlocks.getNumBlocks());
        QRCode qRCode = new QRCode();
        qRCode.setECLevel(errorCorrectionLevel);
        qRCode.setMode(mode);
        qRCode.setVersion(version2);
        int n5 = version2.getDimensionForVersion();
        ByteMatrix byteMatrix = new ByteMatrix(n5, n5);
        int n6 = Encoder.chooseMaskPattern(bitArray3, errorCorrectionLevel, version2, byteMatrix);
        qRCode.setMaskPattern(n6);
        MatrixUtil.buildMatrix(bitArray3, errorCorrectionLevel, version2, n6, byteMatrix);
        qRCode.setMatrix(byteMatrix);
        return qRCode;
    }

    static int getAlphanumericCode(int n) {
        if (n < ALPHANUMERIC_TABLE.length) {
            return ALPHANUMERIC_TABLE[n];
        }
        return -1;
    }

    public static Mode chooseMode(String string) {
        return Encoder.chooseMode(string, null);
    }

    private static Mode chooseMode(String string, String string2) {
        if ("Shift_JIS".equals(string2)) {
            return Encoder.isOnlyDoubleByteKanji(string) ? Mode.KANJI : Mode.BYTE;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c >= '0' && c <= '9') {
                bl = true;
                continue;
            }
            if (Encoder.getAlphanumericCode(c) != -1) {
                bl2 = true;
                continue;
            }
            return Mode.BYTE;
        }
        if (bl2) {
            return Mode.ALPHANUMERIC;
        }
        if (bl) {
            return Mode.NUMERIC;
        }
        return Mode.BYTE;
    }

    private static boolean isOnlyDoubleByteKanji(String string) {
        byte[] byArray;
        try {
            byArray = string.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return false;
        }
        int n = byArray.length;
        if (n % 2 != 0) {
            return false;
        }
        for (int i = 0; i < n; i += 2) {
            int n2 = byArray[i] & 0xFF;
            if (n2 >= 129 && n2 <= 159 || n2 >= 224 && n2 <= 235) continue;
            return false;
        }
        return true;
    }

    private static int chooseMaskPattern(BitArray bitArray, ErrorCorrectionLevel errorCorrectionLevel, Version version, ByteMatrix byteMatrix) throws WriterException {
        int n = Integer.MAX_VALUE;
        int n2 = -1;
        for (int i = 0; i < 8; ++i) {
            MatrixUtil.buildMatrix(bitArray, errorCorrectionLevel, version, i, byteMatrix);
            int n3 = Encoder.calculateMaskPenalty(byteMatrix);
            if (n3 >= n) continue;
            n = n3;
            n2 = i;
        }
        return n2;
    }

    private static Version chooseVersion(int n, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        for (int i = 1; i <= 40; ++i) {
            int n2;
            Version.ECBlocks eCBlocks;
            int n3;
            Version version = Version.getVersionForNumber(i);
            int n4 = version.getTotalCodewords();
            int n5 = n4 - (n3 = (eCBlocks = version.getECBlocksForLevel(errorCorrectionLevel)).getTotalECCodewords());
            if (n5 < (n2 = (n + 7) / 8)) continue;
            return version;
        }
        throw new WriterException("Data too big");
    }

    static void terminateBits(int n, BitArray bitArray) throws WriterException {
        int n2;
        int n3;
        int n4 = n << 3;
        if (bitArray.getSize() > n4) {
            throw new WriterException("data bits cannot fit in the QR Code" + bitArray.getSize() + " > " + n4);
        }
        for (n3 = 0; n3 < 4 && bitArray.getSize() < n4; ++n3) {
            bitArray.appendBit(false);
        }
        n3 = bitArray.getSize() & 7;
        if (n3 > 0) {
            for (n2 = n3; n2 < 8; ++n2) {
                bitArray.appendBit(false);
            }
        }
        n2 = n - bitArray.getSizeInBytes();
        for (int i = 0; i < n2; ++i) {
            bitArray.appendBits((i & 1) == 0 ? 236 : 17, 8);
        }
        if (bitArray.getSize() != n4) {
            throw new WriterException("Bits size does not equal capacity");
        }
    }

    static void getNumDataBytesAndNumECBytesForBlockID(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) throws WriterException {
        if (n4 >= n3) {
            throw new WriterException("Block ID too large");
        }
        int n5 = n % n3;
        int n6 = n3 - n5;
        int n7 = n / n3;
        int n8 = n2 / n3;
        int n9 = n7 - n8;
        int n10 = n7 + 1;
        int n11 = n8 + 1;
        int n12 = n10 - n11;
        if (n9 != n12) {
            throw new WriterException("EC bytes mismatch");
        }
        if (n3 != n6 + n5) {
            throw new WriterException("RS blocks mismatch");
        }
        if (n != (n8 + n9) * n6 + (n11 + n12) * n5) {
            throw new WriterException("Total bytes mismatch");
        }
        if (n4 < n6) {
            nArray[0] = n8;
            nArray2[0] = n9;
        } else {
            nArray[0] = n11;
            nArray2[0] = n12;
        }
    }

    static BitArray interleaveWithECBytes(BitArray bitArray, int n, int n2, int n3) throws WriterException {
        int n4;
        byte[] byArray;
        Object object;
        if (bitArray.getSizeInBytes() != n2) {
            throw new WriterException("Number of bits and data bytes does not match");
        }
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        ArrayList<BlockPair> arrayList = new ArrayList<BlockPair>(n3);
        for (int i = 0; i < n3; ++i) {
            int[] nArray = new int[1];
            object = new int[1];
            Encoder.getNumDataBytesAndNumECBytesForBlockID(n, n2, n3, i, nArray, (int[])object);
            int n8 = nArray[0];
            byArray = new byte[n8];
            bitArray.toBytes(8 * n5, byArray, 0, n8);
            byte[] byArray2 = Encoder.generateECBytes(byArray, (int)object[0]);
            arrayList.add(new BlockPair(byArray, byArray2));
            n6 = Math.max(n6, n8);
            n7 = Math.max(n7, byArray2.length);
            n5 += nArray[0];
        }
        if (n2 != n5) {
            throw new WriterException("Data bytes does not match offset");
        }
        BitArray bitArray2 = new BitArray();
        for (n4 = 0; n4 < n6; ++n4) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                BlockPair blockPair = (BlockPair)object.next();
                byArray = blockPair.getDataBytes();
                if (n4 >= byArray.length) continue;
                bitArray2.appendBits(byArray[n4], 8);
            }
        }
        for (n4 = 0; n4 < n7; ++n4) {
            for (BlockPair blockPair : arrayList) {
                byArray = blockPair.getErrorCorrectionBytes();
                if (n4 >= byArray.length) continue;
                bitArray2.appendBits(byArray[n4], 8);
            }
        }
        if (n != bitArray2.getSizeInBytes()) {
            throw new WriterException("Interleaving error: " + n + " and " + bitArray2.getSizeInBytes() + " differ.");
        }
        return bitArray2;
    }

    static byte[] generateECBytes(byte[] byArray, int n) {
        int n2 = byArray.length;
        int[] nArray = new int[n2 + n];
        for (int i = 0; i < n2; ++i) {
            nArray[i] = byArray[i] & 0xFF;
        }
        new ReedSolomonEncoder(GenericGF.QR_CODE_FIELD_256).encode(nArray, n);
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < n; ++i) {
            byArray2[i] = (byte)nArray[n2 + i];
        }
        return byArray2;
    }

    static void appendModeInfo(Mode mode, BitArray bitArray) {
        bitArray.appendBits(mode.getBits(), 4);
    }

    static void appendLengthInfo(int n, Version version, Mode mode, BitArray bitArray) throws WriterException {
        int n2 = mode.getCharacterCountBits(version);
        if (n >= 1 << n2) {
            throw new WriterException(n + " is bigger than " + ((1 << n2) - 1));
        }
        bitArray.appendBits(n, n2);
    }

    static void appendBytes(String string, Mode mode, BitArray bitArray, String string2) throws WriterException {
        switch (mode) {
            case NUMERIC: {
                Encoder.appendNumericBytes(string, bitArray);
                break;
            }
            case ALPHANUMERIC: {
                Encoder.appendAlphanumericBytes(string, bitArray);
                break;
            }
            case BYTE: {
                Encoder.append8BitBytes(string, bitArray, string2);
                break;
            }
            case KANJI: {
                Encoder.appendKanjiBytes(string, bitArray);
                break;
            }
            default: {
                throw new WriterException("Invalid mode: " + mode);
            }
        }
    }

    static void appendNumericBytes(CharSequence charSequence, BitArray bitArray) {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            int n3;
            int n4 = charSequence.charAt(n2) - 48;
            if (n2 + 2 < n) {
                n3 = charSequence.charAt(n2 + 1) - 48;
                int n5 = charSequence.charAt(n2 + 2) - 48;
                bitArray.appendBits(n4 * 100 + n3 * 10 + n5, 10);
                n2 += 3;
                continue;
            }
            if (n2 + 1 < n) {
                n3 = charSequence.charAt(n2 + 1) - 48;
                bitArray.appendBits(n4 * 10 + n3, 7);
                n2 += 2;
                continue;
            }
            bitArray.appendBits(n4, 4);
            ++n2;
        }
    }

    static void appendAlphanumericBytes(CharSequence charSequence, BitArray bitArray) throws WriterException {
        int n = charSequence.length();
        int n2 = 0;
        while (n2 < n) {
            int n3 = Encoder.getAlphanumericCode(charSequence.charAt(n2));
            if (n3 == -1) {
                throw new WriterException();
            }
            if (n2 + 1 < n) {
                int n4 = Encoder.getAlphanumericCode(charSequence.charAt(n2 + 1));
                if (n4 == -1) {
                    throw new WriterException();
                }
                bitArray.appendBits(n3 * 45 + n4, 11);
                n2 += 2;
                continue;
            }
            bitArray.appendBits(n3, 6);
            ++n2;
        }
    }

    static void append8BitBytes(String string, BitArray bitArray, String string2) throws WriterException {
        byte[] byArray;
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        for (byte by : byArray) {
            bitArray.appendBits(by, 8);
        }
    }

    static void appendKanjiBytes(String string, BitArray bitArray) throws WriterException {
        byte[] byArray;
        try {
            byArray = string.getBytes("Shift_JIS");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new WriterException(unsupportedEncodingException);
        }
        int n = byArray.length;
        for (int i = 0; i < n; i += 2) {
            int n2 = byArray[i] & 0xFF;
            int n3 = byArray[i + 1] & 0xFF;
            int n4 = n2 << 8 | n3;
            int n5 = -1;
            if (n4 >= 33088 && n4 <= 40956) {
                n5 = n4 - 33088;
            } else if (n4 >= 57408 && n4 <= 60351) {
                n5 = n4 - 49472;
            }
            if (n5 == -1) {
                throw new WriterException("Invalid byte sequence");
            }
            int n6 = (n5 >> 8) * 192 + (n5 & 0xFF);
            bitArray.appendBits(n6, 13);
        }
    }

    private static void appendECI(CharacterSetECI characterSetECI, BitArray bitArray) {
        bitArray.appendBits(Mode.ECI.getBits(), 4);
        bitArray.appendBits(characterSetECI.getValue(), 8);
    }
}

