/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.eventmanager.Cfg;
import de.wilke.wizepanel.jms.resources.FinalResourcePathFactory;
import de.wilke.wizepanel.sessions.Communicator;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CleanupTask
extends TimerTask {
    static final int constDefaultDays = 7;
    private final Logger m_logger = LogManager.getLogger(CleanupTask.class);
    private final long daysIntervalDefault;
    private final long daysIntervalFinalImages;
    private final Map<File, FileFilter> dirs = new HashMap<File, FileFilter>();

    public CleanupTask(long l) {
        this(l, l);
    }

    public CleanupTask(long l, long l2) {
        this.daysIntervalDefault = l > 0L ? l : 7L;
        this.daysIntervalFinalImages = l2 > 0L ? l2 : 7L;
        this.dirs.put(new File(Cfg.getDoneDir()), new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".ics");
            }
        });
        this.dirs.put(new WpFile(WpFile.WpFileType.FINAL_IMG_RESOURCE_FILE).getJavaFile(), new FileFilter(){

            @Override
            public boolean accept(File file) {
                return FinalResourcePathFactory.isFinalResource((String)file.getName()) || (file.getName().startsWith("sendimg_") || file.getName().startsWith("studio_")) && file.getName().endsWith(".png");
            }
        });
        this.dirs.put(new WpFile("${env_var:WIZEPANEL_HOME}/logs").getJavaFile(), new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".log") && (file.getName().startsWith("commons-daemon") || file.getName().startsWith("wpserver-stderr") || file.getName().startsWith("wpserver-stdout"));
            }
        });
    }

    @Override
    public void run() {
        this.m_logger.info("Running");
        for (File file : this.dirs.keySet()) {
            this.delete_files(file, this.dirs.get(file));
        }
        Communicator.instance.wakeup();
    }

    private void delete_files(File file, FileFilter fileFilter) {
        File[] fileArray = file.listFiles(fileFilter);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        long l = System.currentTimeMillis() - 86400000L;
        l = file.equals(new WpFile(WpFile.WpFileType.FINAL_IMG_RESOURCE_FILE).getJavaFile()) ? (l *= this.daysIntervalFinalImages) : (l *= this.daysIntervalDefault);
        for (File file2 : fileArray) {
            if (file2.lastModified() >= l) continue;
            this.m_logger.debug("Removing file: " + file2.getName() + " " + (file2.delete() ? "OK" : "FAILED"));
        }
    }
}

