/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager;

import de.wilke.wizepanel.core.Schadchen;
import de.wilke.wizepanel.core.adapters.AdaptersChangeListener;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.EventProcessorTemplateManager;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.FileAdapterManager;
import de.wilke.wizepanel.eventmanager.ManyFacesLegacyConst;
import de.wilke.wizepanel.eventmanager.RulesLibrary;
import de.wilke.wizepanel.eventmanager.cache.CacheResult;
import de.wilke.wizepanel.eventmanager.content.CalendarContent;
import de.wilke.wizepanel.jms.session.WpSession;
import de.wilke.wizepanel.jms.session.WpSessionAttributes;
import de.wilke.wizepanel.jms.session.WpSessionEvent;
import de.wilke.wizepanel.jms.session.WpSessionResource;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.Warnings;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.templates.TemplateInfo;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Location;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

class EventProcessor {
    private static final Logger m_logger = LogManager.getLogger(EventProcessor.class);
    private final Map<String, Integer> history = new ConcurrentHashMap<String, Integer>();
    private final EventProcessorTemplateManager tpl_man = new EventProcessorTemplateManager();
    private boolean run_once = false;
    private final Schadchen schadchen = new Schadchen();

    public EventProcessor() {
        final String string = WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.SCHADCHEN_CFG_FILE);
        if (!this.schadchen.load(string, FileAdapterManager.getManager().getAllAdapters())) {
            this.schadchen.reconfigure(FileAdapterManager.getManager().getAllAdapters());
            this.schadchen.save(string);
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (WizePanelItemType wizePanelItemType : WpDataManager.getManager().getWizepanels()) {
            linkedList.add(wizePanelItemType.params().getName());
        }
        if (this.schadchen.cleanup(linkedList)) {
            this.schadchen.save(string);
        }
        FileAdapterManager.getManager().addChangeListener(new AdaptersChangeListener(){

            public void changed() {
                EventProcessor.this.schadchen.load(string, FileAdapterManager.getManager().getAllAdapters());
            }
        });
    }

    public void execute(EventScheduler eventScheduler, Map<String, CalendarContent> map, Map<String, List<CacheResult>> map2) {
        Object object;
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        DateTime dateTime = new DateTime();
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (String object2 : map2.keySet()) {
            UpiRouterItem upiRouterItem = map2.get(object2);
            if (upiRouterItem == null) continue;
            if (upiRouterItem.size() > 0) {
                object = upiRouterItem.iterator();
                while (object.hasNext()) {
                    CacheResult cacheResult = object.next();
                    if (!cacheResult.getDisplayTo().after((java.util.Date)dateTime)) continue;
                    if (cacheResult.getDisplayOn().before((java.util.Date)dateTime)) {
                        if (object.hasNext()) {
                            Object object3 = (CacheResult)object.next();
                            if (((CacheResult)object3).getDisplayOn().before((java.util.Date)dateTime) && ((CacheResult)object3).getDisplayOn().after((java.util.Date)cacheResult.getDisplayOn())) {
                                hashMap.put(object2, upiRouterItem.indexOf(object3));
                                break;
                            }
                            hashMap.put(object2, upiRouterItem.indexOf(cacheResult));
                            break;
                        }
                        hashMap.put(object2, upiRouterItem.indexOf(cacheResult));
                        break;
                    }
                    hashMap.put(object2, upiRouterItem.indexOf(cacheResult));
                    upiRouterItem.add(upiRouterItem.indexOf(cacheResult), null);
                    break;
                }
                if (hashMap.containsKey(object2)) continue;
                upiRouterItem.add(null);
                hashMap.put(object2, upiRouterItem.size() - 1);
                continue;
            }
            upiRouterItem.add(0, null);
            hashMap.put(object2, 0);
        }
        Set set = RulesLibrary.getSingleton().targetsWithRules();
        if (set.size() == 0) {
            return;
        }
        for (UpiRouterItem upiRouterItem : upiRoutingHandler.getRouters()) {
            object = upiRouterItem.getParams().getTimeZone();
            for (Object object3 : upiRouterItem.getTargets()) {
                String string = object3.getParams().getName();
                if (!set.contains(string)) continue;
                WpSession wpSession = null;
                List list = this.schadchen.getSources(string);
                if (list == null || list.size() == 0) {
                    wpSession = this.create_session_from_event((UpiTargetItem)object3, null, null, null, false, null, null);
                } else if (list.size() == 1) {
                    String string2 = (String)list.get(0);
                    wpSession = map.containsKey(string2) ? this.create_session_from_content((UpiTargetItem)object3, string2, map.get(string2)) : this.create_session_from_event((UpiTargetItem)object3, string2, map2.get(string2), null, false, (Integer)hashMap.get(string2), (String)object);
                } else {
                    this.create_and_send_composite_panel(string, list, eventScheduler, map, map2, hashMap, (String)object);
                }
                if (wpSession == null) continue;
                eventScheduler.send_session(wpSession);
            }
        }
        this.run_once = true;
    }

    private WpSession create_session_from_content(UpiTargetItem upiTargetItem, String string, CalendarContent calendarContent) {
        String string2;
        RulesLibrary rulesLibrary = RulesLibrary.getSingleton();
        String string3 = rulesLibrary.getManyTemplate(string2 = upiTargetItem.getParams().getName());
        if (string3 == null && (string3 = rulesLibrary.getSingleTemplate(string2)) == null) {
            string3 = rulesLibrary.getBlankTemplate(string2);
        }
        if (string3 == null) {
            Warnings.getInstance().addTargetWarning(string2, "No valid template found");
            return null;
        }
        TemplateInfo templateInfo = this.tpl_man.getTemplate(string3);
        if (templateInfo == null) {
            Warnings.getInstance().addTargetError(string2, "template not found: " + string3);
            return null;
        }
        this.add_source(string, calendarContent.data);
        int n = new HashCodeBuilder().append(calendarContent.data).append((Object)string3).append((Object)templateInfo).append(upiTargetItem.getParams().getRotation()).toHashCode();
        if (this.history.containsKey(string2) && this.history.get(string2) == n) {
            return null;
        }
        this.history.put(string2, n);
        m_logger.info("[{}] ({}) NEWCONTENT", (Object)string2, (Object)string3);
        return this.create_session(upiTargetItem, string3, calendarContent.data);
    }

    private WpSession create_session_from_event(UpiTargetItem upiTargetItem, String string, List<CacheResult> list, String string2, boolean bl, Integer n, String string3) {
        CacheResult cacheResult;
        Object object;
        Object object2;
        GroupData groupData2;
        RulesLibrary rulesLibrary;
        boolean bl2;
        String string4 = upiTargetItem.getParams().getName();
        CacheResult cacheResult2 = null;
        CacheResult cacheResult3 = null;
        if (list != null && n != null) {
            cacheResult2 = list.get(n);
            cacheResult3 = list.size() >= n + 2 ? list.get(n + 1) : null;
        }
        boolean bl3 = bl2 = list == null || list.size() == 1 && cacheResult2 == null;
        if (string2 == null && (string2 = (rulesLibrary = RulesLibrary.getSingleton()).getTemplate(string4, cacheResult2 != null, !bl2)) == null) {
            Warnings.getInstance().addTargetWarning(string4, "No valid template rule found");
            return null;
        }
        rulesLibrary = this.tpl_man.getTemplate(string2);
        if (rulesLibrary == null) {
            Warnings.getInstance().addTargetError(string4, "template not found: " + string2);
            return null;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        JSONObject jSONObject = new JSONObject();
        List<String> list2 = Arrays.asList(TimeZone.getAvailableIDs());
        Calendar calendar = Calendar.getInstance();
        if (list2.contains(string3)) {
            calendar = Calendar.getInstance(TimeZone.getTimeZone(string3));
        }
        String string5 = "0";
        for (GroupData groupData2 : GroupManager.getManager().getGroups()) {
            if (!groupData2.wizpanels.contains(string4)) continue;
            string5 = groupData2.timeTableStart;
            break;
        }
        if (string5.equals("0")) {
            string5 = WpSystemLocator.getLocator().getTimetableStartDay();
        }
        int n2 = Integer.valueOf(string5);
        groupData2 = new DateTime(calendar.getTime());
        groupData2.setUtc(true);
        calendar.set(11, 0);
        calendar.clear(12);
        calendar.clear(13);
        calendar.clear(14);
        DateTime dateTime = new DateTime(calendar.getTime());
        dateTime.setUtc(true);
        if (n2 != 0) {
            while (calendar.get(7) != n2) {
                calendar.add(5, -1);
            }
        }
        DateTime dateTime2 = new DateTime(calendar.getTime());
        dateTime2.setUtc(true);
        calendar.add(5, 1);
        DateTime dateTime3 = new DateTime(calendar.getTime());
        dateTime3.setUtc(true);
        LinkedList<CacheResult> linkedList = null;
        if (list != null) {
            int n3 = 0;
            int n4 = 0;
            linkedList = new LinkedList<CacheResult>(list);
            while (linkedList.size() > 0) {
                int n5 = 0;
                object2 = new JSONObject();
                object = this.distillRelevantEvents(dateTime2, dateTime3, linkedList);
                Iterator<CacheResult> iterator = object.iterator();
                while (iterator.hasNext()) {
                    cacheResult = iterator.next();
                    JSONObject jSONObject2 = new JSONObject();
                    try {
                        if (cacheResult.getEvent().getSummary() == null) {
                            jSONObject2.put("SUMMARY", (Object)"");
                        } else {
                            jSONObject2.put("SUMMARY", (Object)cacheResult.getEvent().getSummary());
                        }
                        if (cacheResult.getEvent().getDescription() == null) {
                            jSONObject2.put("DESCRIPTION", (Object)"");
                        } else {
                            jSONObject2.put("DESCRIPTION", (Object)cacheResult.getEvent().getDescription());
                        }
                        jSONObject2.put("DTSTART", (Object)cacheResult.getEventTime().getStart().toString());
                        jSONObject2.put("DTEND", (Object)cacheResult.getEventTime().getEnd().toString());
                        if ((cacheResult.getEventTime().getStart().before((java.util.Date)groupData2) || cacheResult.getEventTime().getStart().equals((Object)groupData2)) && (cacheResult.getEventTime().getEnd().after((java.util.Date)groupData2) || cacheResult.getEventTime().getEnd().equals((Object)groupData2))) {
                            jSONObject2.put("NOW", true);
                        } else {
                            jSONObject2.put("NOW", false);
                        }
                        object2.put("EVENT[" + n5 + "]", (Object)jSONObject2.toString());
                        ++n5;
                    }
                    catch (JSONException jSONException) {
                        jSONException.printStackTrace();
                    }
                }
                try {
                    jSONObject.put("CURRENT_DAY", (Object)dateTime2.toString());
                    jSONObject.put("EVENTLIST", object2);
                }
                catch (JSONException jSONException) {
                    jSONException.printStackTrace();
                }
                hashMap.put("TIMETABLE_WEEK[" + n4 + "]", jSONObject.toString());
                ++n4;
                if (dateTime.equals((Object)dateTime2) || dateTime.before((java.util.Date)dateTime2)) {
                    hashMap.put("TIMETABLE_DAY[" + n3 + "]", jSONObject.toString());
                    ++n3;
                }
                dateTime2 = (DateTime)dateTime3.clone();
                calendar.add(5, 1);
                dateTime3 = new DateTime(calendar.getTime());
                dateTime3.setUtc(true);
            }
            linkedList = new LinkedList<CacheResult>(list);
            this.removeAllBeforeIndex(linkedList, n);
        }
        this.add_placeholders(hashMap, linkedList, (TemplateInfo)rulesLibrary);
        this.add_source(string, hashMap);
        if (cacheResult2 == null && linkedList != null && cacheResult3 != null) {
            hashMap.put("FREE_UNTIL", cacheResult3.getEventTime().getStart().toString());
        }
        if (!bl) {
            ManyFacesLegacyConst.add_legacy_placeholders(hashMap, linkedList, cacheResult2, cacheResult3, (TemplateInfo)rulesLibrary);
        }
        if (bl) {
            return this.create_session(upiTargetItem, string2, hashMap);
        }
        HashSet hashSet = new HashSet(hashMap.keySet());
        for (String string6 : hashSet) {
            hashMap.put("0#" + string6, (String)hashMap.get(string6));
        }
        this.add_final_placeholders(hashMap, (TemplateInfo)rulesLibrary, upiTargetItem);
        this.remove_unused_placeholders(hashMap, (TemplateInfo)rulesLibrary, upiTargetItem);
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder().append(hashMap).append((Object)string2).append(upiTargetItem.getParams().getRotation()).append((Object)rulesLibrary);
        UpiRouterItem upiRouterItem = WpUpiServerStaticFactory.getRoutingHandler().getRouterByTargetId(upiTargetItem.getId());
        if (upiRouterItem != null && (object2 = upiRouterItem.getParams().getTimeZone()) != null) {
            hashCodeBuilder.append(object2);
        }
        int n6 = hashCodeBuilder.toHashCode();
        if (this.history.containsKey(string4) && this.history.get(string4) == n6) {
            return null;
        }
        this.history.put(string4, n6);
        object = "";
        if (linkedList != null) {
            for (int i = 0; i < linkedList.size() && i < rulesLibrary.numberOfEvents(); ++i) {
                cacheResult = (CacheResult)linkedList.get(i);
                object = (String)object + "." + (cacheResult == null ? "null" : cacheResult.getEvent().getSummary()) + ".";
            }
            object = "#events=" + linkedList.size() + "[" + (String)object + "]";
        }
        m_logger.info("[{}] ({}) NEWEVENT: [{}]", (Object)string4, (Object)string2, object);
        if (this.run_once) {
            return this.create_session(upiTargetItem, string2, hashMap);
        }
        return null;
    }

    private List<CacheResult> distillRelevantEvents(DateTime dateTime, DateTime dateTime2, List<CacheResult> list) {
        LinkedList<CacheResult> linkedList = new LinkedList<CacheResult>();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        calendar.setTime((java.util.Date)dateTime2);
        calendar.add(5, 1);
        DateTime dateTime3 = new DateTime(calendar.getTime());
        dateTime3.setUtc(true);
        Iterator<CacheResult> iterator = list.iterator();
        while (iterator.hasNext()) {
            CacheResult cacheResult = iterator.next();
            if (cacheResult != null) {
                if (cacheResult.getEventTime().getStart().equals((Object)dateTime) || cacheResult.getEventTime().getEnd().equals((Object)dateTime2) || cacheResult.getEventTime().getStart().after((java.util.Date)dateTime) && cacheResult.getEventTime().getStart().before((java.util.Date)dateTime2) || cacheResult.getEventTime().getEnd().after((java.util.Date)dateTime) && cacheResult.getEventTime().getEnd().before((java.util.Date)dateTime2) || cacheResult.getEventTime().getStart().before((java.util.Date)dateTime) && cacheResult.getEventTime().getEnd().after((java.util.Date)dateTime2)) {
                    linkedList.add(cacheResult);
                    if (cacheResult.getEventTime().getStart().equals((Object)dateTime2) || cacheResult.getEventTime().getEnd().equals((Object)dateTime3) || cacheResult.getEventTime().getStart().after((java.util.Date)dateTime2) && cacheResult.getEventTime().getStart().before((java.util.Date)dateTime3) || cacheResult.getEventTime().getEnd().after((java.util.Date)dateTime2) && cacheResult.getEventTime().getEnd().before((java.util.Date)dateTime3) || cacheResult.getEventTime().getStart().before((java.util.Date)dateTime2) && cacheResult.getEventTime().getEnd().after((java.util.Date)dateTime3)) continue;
                    iterator.remove();
                    continue;
                }
                if (!cacheResult.getEventTime().getEnd().before((java.util.Date)dateTime) && !cacheResult.getEventTime().getEnd().equals((Object)dateTime)) continue;
                iterator.remove();
                continue;
            }
            iterator.remove();
        }
        return linkedList;
    }

    private void removeAllBeforeIndex(List<CacheResult> list, int n) {
        --n;
        while (n >= 0) {
            list.remove(n);
            --n;
        }
    }

    private WpSession create_session(UpiTargetItem upiTargetItem, String string, Map<String, String> map) {
        WpSessionAttributes wpSessionAttributes = new WpSessionAttributes();
        wpSessionAttributes.setCommand(WpSessionAttributes.SESSION_COMMAND.CREATE);
        wpSessionAttributes.setID(UUID.randomUUID().toString());
        wpSessionAttributes.setOriginator(WpSessionAttributes.SESSION_ORIGINATOR.SERVER.name());
        wpSessionAttributes.setTag(WpSessionAttributes.SESSION_TAG.EXTERN);
        WpSessionEvent wpSessionEvent = new WpSessionEvent();
        wpSessionEvent.setTargetStationName(upiTargetItem.getParams().getName());
        WpSessionResource wpSessionResource = new WpSessionResource();
        wpSessionResource.setTemplate(string);
        wpSessionResource.setTemplateParams(map);
        WpSession wpSession = new WpSession();
        wpSession.setAttributes(wpSessionAttributes);
        wpSession.setEvent(wpSessionEvent);
        wpSession.setResource(wpSessionResource);
        return wpSession;
    }

    private void merge_placeholders(Map<String, String> map, Map<String, String> map2, String string) {
        if (map == null) {
            return;
        }
        if (string == null) {
            string = "";
        }
        for (String string2 : map.keySet()) {
            if (map2.containsKey(string2 + string)) continue;
            map2.put(string2 + string, map.get(string2));
        }
    }

    private void add_placeholders(Map<String, String> map, List<CacheResult> list, TemplateInfo templateInfo) {
        if (list == null || list.size() == 0) {
            return;
        }
        for (int i = 0; i < list.size() && i < templateInfo.numberOfEvents(); ++i) {
            String string;
            CacheResult cacheResult = list.get(i);
            if (cacheResult == null) continue;
            map.put("SUMMARY[" + i + "]", cacheResult.getEvent().getSummary());
            map.put("DTSTART[" + i + "]", cacheResult.getEventTime().getStart().toString());
            map.put("DTEND[" + i + "]", cacheResult.getEventTime().getEnd().toString());
            String string2 = cacheResult.getEvent().getLocation();
            if (string2 != null) {
                map.put("LOCATION[" + i + "]", string2);
            }
            if ((string = cacheResult.getEvent().getDescription()) != null) {
                map.put("DESCRIPTION[" + i + "]", string);
            }
            map.put("DATETIME[" + i + "]", cacheResult.getEventTime().getStart().toString() + " " + cacheResult.getEventTime().getEnd().toString());
            map.put("CREATOR[" + i + "]", cacheResult.getEvent().getOrganizerName());
            String string3 = this.create_ics_event_qr(cacheResult);
            if (string3 != null) {
                map.put("EVENT_QR[" + i + "]", string3);
            }
            if (i == 0) {
                this.merge_placeholders(cacheResult.getEvent().getPlaceholders(), map, "");
            }
            this.merge_placeholders(cacheResult.getEvent().getPlaceholders(), map, "[" + i + "]");
        }
    }

    private void add_final_placeholders(Map<String, String> map, TemplateInfo templateInfo, UpiTargetItem upiTargetItem) {
        map.put("TODAY", this.get_today());
        if (templateInfo.getPlaceholders().containsValue("NOW")) {
            map.put("NOW", this.get_now());
        }
        map.put("TARGET_NAME", upiTargetItem.getParams().getName());
        map.put("TARGET_COMMENT", upiTargetItem.getParams().getComment());
        map.put("TARGET_ID", upiTargetItem.getId());
        for (Map.Entry entry : templateInfo.getPlaceholders().entrySet()) {
            String string = (String)entry.getValue();
            if (map.containsKey(string.toUpperCase())) continue;
            map.put(string, null);
        }
    }

    private void remove_unused_placeholders(Map<String, String> map, TemplateInfo templateInfo, UpiTargetItem upiTargetItem) {
        HashMap<String, String> hashMap = new HashMap<String, String>(map);
        for (Map.Entry entry : hashMap.entrySet()) {
            boolean bl = false;
            String string = (String)entry.getKey();
            for (Map.Entry entry2 : templateInfo.getPlaceholders().entrySet()) {
                String string2 = (String)entry2.getValue();
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            map.remove(string);
        }
    }

    private String create_ics_event_qr(CacheResult cacheResult) {
        VEvent vEvent = new VEvent((Date)cacheResult.getEventTime().getStart(), (Date)cacheResult.getEventTime().getEnd(), cacheResult.getEvent().getSummary());
        vEvent.getProperties().add((Property)new Location(cacheResult.getEvent().getLocation()));
        vEvent.getDateStamp().setDate((Date)cacheResult.getEventTime().getStart());
        return vEvent.toString();
    }

    private String get_today() {
        return this.get_now();
    }

    private String get_now() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd'T'HHmmss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT+0"));
        DateTime dateTime = new DateTime();
        dateTime.setUtc(true);
        return simpleDateFormat.format((java.util.Date)dateTime);
    }

    public void clearHistory(UpiTargetItem upiTargetItem) {
        if (upiTargetItem == null) {
            this.history.clear();
        } else {
            this.history.remove(upiTargetItem.getParams().getName());
        }
    }

    private void create_and_send_composite_panel(String string, List<String> list, EventScheduler eventScheduler, Map<String, CalendarContent> map, Map<String, List<CacheResult>> map2, Map<String, Integer> map3, String string2) {
        String string3;
        int n;
        List<CacheResult> list2;
        String string4;
        RulesLibrary rulesLibrary = RulesLibrary.getSingleton();
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        UpiTargetItem upiTargetItem = upiRoutingHandler.getTargetByName(string);
        if (upiTargetItem == null) {
            Warnings.getInstance().addTargetError(string, "Unknown target");
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            string4 = list.get(i);
            if (map.containsKey(string4)) {
                bl = true;
                continue;
            }
            list2 = map2.get(string4);
            if (list2 == null || list2.size() == 0) continue;
            if (list2.get(map3.get(string4)) != null) {
                bl = true;
            }
            if (list2.size() <= map3.get(string4) + 1) continue;
            bl2 = true;
        }
        String string5 = rulesLibrary.getTemplate(string, bl, bl2);
        if (string5 == null) {
            Warnings.getInstance().addTargetError(string, "Could not determine template (" + bl + "|" + bl2 + ")");
            return;
        }
        string4 = this.tpl_man.getTemplate(string5);
        if (string4 == null) {
            Warnings.getInstance().addTargetError(string, "template not found: " + string5);
            return;
        }
        list2 = new HashMap();
        for (n = 0; n < list.size(); ++n) {
            string3 = list.get(n);
            boolean bl3 = map.containsKey(string3);
            Map map4 = null;
            if (bl3) {
                map4 = map.get((Object)string3).data;
            } else {
                WpSession wpSession = this.create_session_from_event(upiTargetItem, string3, map2.get(string3), string5, true, map3.get(string3), string2);
                if (wpSession != null) {
                    map4 = wpSession.getResource().getTemplateParams();
                }
            }
            if (map4 == null) continue;
            for (String string6 : map4.keySet()) {
                list2.put(n + "#" + string6, (String)map4.get(string6));
            }
        }
        this.add_final_placeholders((Map<String, String>)((Object)list2), (TemplateInfo)string4, upiTargetItem);
        this.remove_unused_placeholders((Map<String, String>)((Object)list2), (TemplateInfo)string4, upiTargetItem);
        n = new HashCodeBuilder().append((Object)list2).append((Object)string5).append(upiTargetItem.getParams().getRotation()).append((Object)string4).toHashCode();
        if (this.history.containsKey(string) && this.history.get(string) == n) {
            return;
        }
        this.history.put(string, n);
        if (this.run_once) {
            m_logger.info("[{}] ({}) NEWCOMPOSITE", (Object)string, (Object)string5);
            string3 = this.create_session(upiTargetItem, string5, (Map<String, String>)((Object)list2));
            if (string3 != null) {
                eventScheduler.send_session((WpSession)string3);
            }
        }
    }

    public Schadchen getSchadchen() {
        return this.schadchen;
    }

    private void add_source(String string, Map<String, String> map) {
        if (string == null) {
            return;
        }
        String[] stringArray = string.split("#", 2);
        if (stringArray.length != 2) {
            return;
        }
        map.put("SOURCE", stringArray[1]);
    }
}

