/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.AdapterManager;
import de.wilke.wizepanel.core.adapters.RawAdapter;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import java.io.File;
import java.io.FileInputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.json.JSONException;
import org.json.JSONObject;

public class FileAdapterManager
extends AdapterManager {
    private static final FileAdapterManager _instance = new FileAdapterManager();

    private FileAdapterManager() {
    }

    public static FileAdapterManager getManager() {
        return _instance;
    }

    private void read_props_conf_file() {
        this.m_adapters = new LinkedList();
        try (FileInputStream fileInputStream = new FileInputStream(WpSystemLocator.getLocator().getAdaptersCfg());){
            String string;
            Object object;
            PropertyResourceBundle propertyResourceBundle = new PropertyResourceBundle(fileInputStream);
            HashMap hashMap = new HashMap();
            Enumeration<String> enumeration = ((ResourceBundle)propertyResourceBundle).getKeys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                object = propertyResourceBundle.getString(string2);
                string = WpFileUtils.getExtension((String)string2);
                if (string == null) {
                    this.debug("invalid field specifier: " + string2);
                    continue;
                }
                String string3 = string2.substring(0, string2.length() - string.length() - 1);
                if (!hashMap.containsKey(string3)) {
                    hashMap.put(string3, new HashMap());
                }
                ((Map)hashMap.get(string3)).put(string, object);
            }
            for (String string2 : hashMap.keySet()) {
                object = (Map)hashMap.get(string2);
                string = new RawAdapter(string2);
                string.importRawData((Map)object);
                string = this.createNewAdapter(string.getType(), (AbstractAdapterConfiguration)string);
                if (string != null) {
                    this.m_adapters.add(string);
                    continue;
                }
                this.debug("validation failed for adapter: " + string2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void read_config() {
        String string = WpFileUtils.readTextFile((File)new File(WpSystemLocator.getLocator().getAdaptersCfg()));
        if (!this.read_json_conf(string)) {
            this.read_props_conf_file();
        }
        boolean bl = false;
        for (AbstractAdapterConfiguration abstractAdapterConfiguration : this.getAllAdapters()) {
            String string2 = abstractAdapterConfiguration.password();
            abstractAdapterConfiguration.setPassword(string2);
            if (string2.equals(abstractAdapterConfiguration.password())) continue;
            bl = true;
        }
        if (bl) {
            this.save();
        }
    }

    public void fromString(String string) {
        try {
            JSONObject jSONObject = new JSONObject(string);
            WpFileUtils.writeTextToFile((File)new File(WpSystemLocator.getLocator().getAdaptersCfg()), (String)jSONObject.toString(4));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        this.invalidate();
    }

    protected void save() {
        try {
            JSONObject jSONObject = this.toJSON();
            WpFileUtils.writeTextToFile((String)WpSystemLocator.getLocator().getAdaptersCfg(), (String)jSONObject.toString(4));
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }

    public void renameAdapter(String string, String string2) throws Exception {
        AbstractAdapterConfiguration abstractAdapterConfiguration = FileAdapterManager.getManager().getAdapterByName(LicenseManager.getManager(), string);
        if (abstractAdapterConfiguration == null) {
            throw new Exception("Adapter not found");
        }
        abstractAdapterConfiguration.setName(string2);
        this.save();
        this.inform_all_change_listeners();
    }
}

