/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters;

import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.content.CalendarContent;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.server.Warnings;
import java.util.List;
import java.util.TimerTask;
import org.apache.logging.log4j.Logger;

public abstract class AdapterJob
extends TimerTask {
    protected final Logger logger;
    private final AbstractAdapterConfiguration adapter;
    private final EventScheduler scheduler;
    private volatile boolean do_run = true;
    private boolean is_running = false;

    public AdapterJob(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        this.logger = logger;
        this.adapter = abstractAdapterConfiguration;
        this.scheduler = eventScheduler;
    }

    @Override
    public final void run() {
        this.is_running = true;
        if (this.do_run) {
            this.logger.info("Running adapter: {}", (Object)this.adapter.getName());
            try {
                this.singleRun();
            }
            catch (Throwable throwable) {
                this.logger.fatal("RAGNAROK_Adapter_Job", throwable);
            }
        }
        this.is_running = false;
    }

    public final void stop() {
        this.do_run = false;
        this.cleanup();
    }

    public final void stop(long l) {
        this.do_run = false;
        this.cleanup();
        if (l == -1L) {
            return;
        }
        long l2 = System.currentTimeMillis() + l;
        while (System.currentTimeMillis() < l2 && this.is_running) {
            try {
                Thread.sleep(l / 10L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.cancel();
    }

    public abstract void singleRun() throws Throwable;

    public final AbstractAdapterConfiguration getAdapter() {
        return this.adapter;
    }

    protected void cleanup() {
    }

    protected final void setAdapterEvents(List<CalendarEvent> list) {
        this.scheduler.setAdapterEvents(this.adapter.getName(), list);
    }

    protected final void setAdapterContent(CalendarContent calendarContent) {
        this.scheduler.setAdapterContent(this.adapter.getName(), calendarContent);
    }

    protected final void addAdapterWarning(String string) {
        Warnings.getInstance().addAdapterWarning(this.adapter, string);
    }

    protected final void addAdapterError(String string) {
        Warnings.getInstance().addAdapterError(this.adapter, string);
    }
}

