/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.asc_timetables;

import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.AscTimeTablesAdapter;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.adapters.asc_timetables.AscLesson;
import de.wilke.wizepanel.eventmanager.adapters.asc_timetables.AscServerReply;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.ProdId;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Version;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.logging.log4j.Logger;

public class AscTimeTablesTask
extends AdapterJob {
    private final AscTimeTablesAdapter m_cfg;
    private final List<String> m_rooms;
    private String historyDuration;
    private final Map<String, Integer> m_room_hashs = new HashMap<String, Integer>();
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

    public AscTimeTablesTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.m_cfg = (AscTimeTablesAdapter)abstractAdapterConfiguration;
        this.historyDuration = "0";
        for (GroupData groupData : GroupManager.getManager().getGroups()) {
            if (!groupData.adapters.contains(abstractAdapterConfiguration.getName()) || Long.valueOf(groupData.historyDuration) <= Long.valueOf(this.historyDuration)) continue;
            this.historyDuration = groupData.historyDuration;
        }
        if (this.historyDuration.equals("0")) {
            this.historyDuration = WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        this.m_rooms = this.m_cfg.targets();
        if (this.m_rooms == null || this.m_rooms.size() == 0) {
            return;
        }
        logger.info("Installing new AscTimeTables adapter: " + this.m_cfg.server() + " for rooms: " + this.m_rooms);
        if (this.m_rooms == null && this.m_rooms.size() == 0) {
            this.stop();
        }
    }

    @Override
    public synchronized void singleRun() {
        java.util.Calendar calendar = java.util.Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTimeInMillis() - Long.valueOf(this.historyDuration));
        LinkedList<CalendarEvent> linkedList = new LinkedList<CalendarEvent>();
        int n = this.m_cfg.range().getDays() + (int)(Long.valueOf(this.historyDuration) / 1000L / 60L / 60L / 24L);
        for (int i = 0; i < n; ++i) {
            AscServerReply ascServerReply = new AscServerReply();
            String string = this.sdf.format(calendar.getTime());
            try {
                int n2 = this.m_room_hashs.containsKey(string) ? this.m_room_hashs.get(string) : 0;
                int n3 = ascServerReply.get(this.m_cfg.server(), calendar.getTime(), n2);
                if (n2 != n3) {
                    this.m_room_hashs.put(string, n3);
                    for (String string2 : this.m_rooms) {
                        List<AscLesson> list = ascServerReply.lessons(string2);
                        this.logger.debug("Room[" + string2 + "]:  received: " + list);
                        if (list == null) continue;
                        for (AscLesson ascLesson : list) {
                            try {
                                linkedList.add(this.generate_ics(ascLesson, ascLesson.location()));
                            }
                            catch (Exception exception) {
                                this.addAdapterWarning(exception.getMessage());
                            }
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.logger.error(exception.getLocalizedMessage());
                return;
            }
            calendar.add(5, 1);
        }
        this.setAdapterEvents(linkedList);
        if (this.m_room_hashs.size() >= 2 * this.m_cfg.range().getDays()) {
            this.m_room_hashs.clear();
        }
    }

    private CalendarEvent generate_ics(AscLesson ascLesson, String string) throws Exception {
        DateTime dateTime = new DateTime(ascLesson.getStart());
        dateTime.setUtc(true);
        DateTime dateTime2 = new DateTime(ascLesson.getEnd());
        dateTime2.setUtc(true);
        this.logger.info("Generating new ICS file. Event starts at: " + WpTimeUtils.date2str((java.util.Date)ascLesson.getStart()));
        XWizePanel xWizePanel = new XWizePanel();
        xWizePanel.add(XWizePanel.WPDataItem.TargetStationPath, string);
        xWizePanel.add(XWizePanel.WPDataItem.AdapterCfg, this.m_cfg.getName());
        xWizePanel.add(XWizePanel.WPDataItem.Placeholders, ascLesson.extraData());
        VAlarm vAlarm = null;
        if (!this.m_cfg.ignoreAlarm() && ascLesson.getReminderMinutesBeforeStart() > 0) {
            vAlarm = new VAlarm();
            vAlarm.getProperties().add((Property)Action.DISPLAY);
            vAlarm.getProperties().add((Property)new Trigger(new Dur("-PT" + ascLesson.getReminderMinutesBeforeStart() + "M")));
            vAlarm.getProperties().add((Property)new Description("Alarma!"));
        }
        Organizer organizer = null;
        if (!ascLesson.contact().isEmpty()) {
            organizer = new Organizer();
            organizer.getParameters().add((Parameter)new Cn(ascLesson.contact()));
        }
        VEvent vEvent = new VEvent((Date)dateTime, (Date)dateTime2, ascLesson.subject());
        vEvent.getProperties().add((Property)new Uid(ascLesson.id()));
        vEvent.getProperties().add((Property)new Location(ascLesson.location()));
        vEvent.getProperties().add((Property)new XProperty(xWizePanel.getICSName(), xWizePanel.getICSValue()));
        if (vAlarm != null) {
            vEvent.getAlarms().add((Component)vAlarm);
        }
        if (organizer != null) {
            vEvent.getProperties().add((Property)organizer);
        }
        Calendar calendar = new Calendar();
        calendar.getProperties().add((Property)new ProdId("-//Wilke//Exchange to iCal4j 1.0//EN"));
        calendar.getProperties().add((Property)Version.VERSION_2_0);
        calendar.getComponents().add((Component)vEvent);
        return new CalendarEvent(vEvent, true);
    }
}

