/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.csv;

import au.com.bytecode.opencsv.CSVReader;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.CsvAdapter;
import de.wilke.wizepanel.core.adapters.types.CsvAdapterFormat;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.adapters.csv.CsvEvent;
import de.wilke.wizepanel.eventmanager.adapters.csv.CsvUtils;
import de.wilke.wizepanel.eventmanager.adapters.csv.Hash;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarEventException;
import de.wilke.wizepanel.server.Warnings;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class HashedCsvFile {
    private final Logger m_logger = LogManager.getLogger(HashedCsvFile.class);
    private final Map<String, CsvEvent> m_rows = new HashMap<String, CsvEvent>();
    private final CsvAdapterFormat m_fmt;
    private final CsvAdapter adapter;
    private boolean fatal_error = false;
    private final List<Error> errors = new LinkedList<Error>();
    private static final int STOP_AFTER_ROWS = 10000;

    public HashedCsvFile(CsvAdapter csvAdapter, String string, CsvAdapterFormat csvAdapterFormat, String string2, java.util.Date date) throws IOException {
        GroupData groupData22;
        this.adapter = csvAdapter;
        this.m_fmt = csvAdapterFormat;
        String string3 = "0";
        for (GroupData groupData22 : GroupManager.getManager().getGroups()) {
            if (!groupData22.adapters.contains(csvAdapter.getName()) || Long.valueOf(groupData22.historyDuration) <= Long.valueOf(string3)) continue;
            string3 = groupData22.historyDuration;
        }
        if (string3.equals("0")) {
            string3 = WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        List list = csvAdapter.targets();
        groupData22 = new CSVReader((Reader)new StringReader(string), this.m_fmt.getCsvSeparator().charAt(0), this.m_fmt.getCsvEnclosure().charAt(0), '\\', this.m_fmt.getSkipLines());
        try {
            int n = this.m_fmt.getSkipLines();
            String[] stringArray = null;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(calendar.getTimeInMillis() - Long.valueOf(string3));
            this.fatal_error = false;
            while ((stringArray = groupData22.readNext()) != null && !this.fatal_error) {
                Object object3;
                ++n;
                if (stringArray.length < this.m_fmt.numMinCols()) {
                    this.add_error("IGNORING(not-enough-fields): [" + stringArray[0] + "]" + stringArray.length, n);
                    continue;
                }
                String string4 = stringArray[this.m_fmt.getTargetCol() - 1].trim();
                String object2 = stringArray[this.m_fmt.getStartTimeDateCol() - 1].trim();
                String string5 = stringArray[this.m_fmt.getEndTimeDateCol() - 1].trim();
                if (string5.isEmpty() || object2.isEmpty()) {
                    this.add_error("IGNORING(empty-fields): [target:" + (String)string4 + "|start:" + object2 + "|end:" + string5 + "]", n);
                    continue;
                }
                DateTime dateTime = null;
                if (this.m_fmt.getDateCol() != 0) {
                    dateTime = CsvUtils.parse_date_time(stringArray[this.m_fmt.getDateCol() - 1].trim(), null);
                }
                DateTime dateTime2 = CsvUtils.parse_date_time(object2, dateTime);
                DateTime dateTime3 = CsvUtils.parse_date_time(string5, dateTime2);
                if (dateTime2 == null || dateTime3 == null) {
                    this.add_error("IGNORING(invalid-dates): is null: " + dateTime2 + " | " + dateTime3, n);
                    continue;
                }
                if (dateTime3.before((java.util.Date)dateTime2)) {
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime((java.util.Date)dateTime3);
                    calendar2.add(5, 1);
                    dateTime3 = new DateTime(calendar2.getTime());
                    dateTime3.setUtc(true);
                }
                if (list == null || !list.contains(string4)) {
                    this.add_error("IGNORING(not-allowed-target): " + (String)string4, n);
                    continue;
                }
                if (dateTime3.before(calendar.getTime())) {
                    this.add_error("IGNORING(expired): " + string5 + " => " + WpTimeUtils.date2str((java.util.Date)dateTime3), n);
                    continue;
                }
                if (date != null && dateTime2.after(date)) {
                    this.add_error("IGNORING(too-far-away): " + object2 + " => " + WpTimeUtils.date2str((java.util.Date)dateTime2), n);
                    continue;
                }
                int n2 = 0;
                if (this.m_fmt.getAlarmCol() != 0) {
                    n2 = this.filter_alarm(stringArray[this.m_fmt.getAlarmCol() - 1]);
                }
                String string6 = "";
                if (this.m_fmt.getTemplateCol() > 0) {
                    string6 = stringArray[this.m_fmt.getTemplateCol() - 1].trim();
                }
                HashMap<String, String> hashMap = null;
                Map map = this.m_fmt.getPlaceholders();
                if (map != null && map.size() > 0) {
                    hashMap = new HashMap<String, String>();
                    for (Object object3 : map.keySet()) {
                        hashMap.put((String)object3, stringArray[(Integer)map.get(object3) - 1]);
                    }
                }
                StringBuilder stringBuilder = new StringBuilder();
                for (String string7 : stringArray) {
                    stringBuilder.append(string7);
                }
                stringBuilder.append(string2);
                object3 = new Hash(stringBuilder.toString());
                this.m_rows.put(((Hash)object3).getValue(), new CsvEvent(dateTime2, dateTime3, string4, n2, string6, hashMap));
            }
            for (Error error : this.errors) {
                this.m_logger.warn((error.first_line == error.last_line ? "Line " + error.first_line : "Lines " + error.first_line + " to " + error.last_line) + ": " + error.msg);
            }
            if (this.fatal_error) {
                this.m_logger.error("Too many errors: Leaving at line " + n);
            }
        }
        finally {
            groupData22.close();
        }
    }

    public int getRowsCount() {
        return this.m_rows.size();
    }

    public Set<String> getHashes() {
        return this.m_rows.keySet();
    }

    public void removeHash(String string) {
        this.m_rows.remove(string);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.m_rows.isEmpty()) {
            stringBuilder.append("[empty]");
        } else {
            for (String string : this.m_rows.keySet()) {
                stringBuilder.append("  # " + string);
                stringBuilder.append("\n");
            }
        }
        return stringBuilder.toString();
    }

    public List<CalendarEvent> generateAddAll() {
        LinkedList<CalendarEvent> linkedList = new LinkedList<CalendarEvent>();
        for (String string : this.m_rows.keySet()) {
            CalendarEvent calendarEvent = this.generate_event(string, this.m_rows.get(string));
            if (calendarEvent == null) continue;
            linkedList.add(calendarEvent);
        }
        return linkedList;
    }

    private CalendarEvent generate_event(String string, CsvEvent csvEvent) {
        WpFile wpFile;
        XWizePanel xWizePanel = new XWizePanel();
        xWizePanel.add(XWizePanel.WPDataItem.TargetStationPath, csvEvent.target);
        xWizePanel.add(XWizePanel.WPDataItem.AdapterCfg, this.adapter.getName());
        if (!csvEvent.template.isEmpty() && (wpFile = new WpFile(csvEvent.template, WpFile.WpFileType.TEMPLATE_FILE)).exists() && !wpFile.isDirectory()) {
            xWizePanel.add(XWizePanel.WPDataItem.Template, wpFile.getOriginalFileName());
        }
        if (csvEvent.placeholders != null) {
            xWizePanel.add(XWizePanel.WPDataItem.Placeholders, csvEvent.placeholders);
        }
        wpFile = null;
        if (csvEvent.alarm != 0) {
            wpFile = new VAlarm();
            wpFile.getProperties().add((Property)Action.DISPLAY);
            wpFile.getProperties().add((Property)new Trigger(new Dur("-PT" + csvEvent.alarm + "M")));
            wpFile.getProperties().add((Property)new Description("Alarma!"));
        }
        VEvent vEvent = new VEvent();
        vEvent.getProperties().add((Property)new DtStart((Date)csvEvent.start));
        vEvent.getProperties().add((Property)new DtEnd((Date)csvEvent.end));
        vEvent.getProperties().add((Property)new Uid(string));
        vEvent.getProperties().add((Property)new XProperty(xWizePanel.getICSName(), xWizePanel.getICSValue()));
        if (wpFile != null) {
            vEvent.getAlarms().add((Component)wpFile);
        }
        try {
            return new CalendarEvent(vEvent, true);
        }
        catch (Exception exception) {
            CalendarEventException calendarEventException;
            if (exception instanceof CalendarEventException && (calendarEventException = (CalendarEventException)exception).getError() == WizePanelExceptions.ErrorCodes.WP_EM_TARGET_UNRESOLVED) {
                Warnings.getInstance().addAdapterWarning((AbstractAdapterConfiguration)this.adapter, "could not resolve target: " + csvEvent.target);
                return null;
            }
            this.m_logger.error("Bad", (Throwable)exception);
            return null;
        }
    }

    private int filter_alarm(String string) {
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private void add_error(String string, int n) {
        if (this.errors.size() != 0) {
            Error error = this.errors.get(this.errors.size() - 1);
            if (error.msg.equals(string)) {
                error.last_line = n;
                if (error.last_line - error.first_line > 10000) {
                    this.fatal_error = true;
                }
                return;
            }
        }
        this.errors.add(new Error(string, n));
        if (this.errors.size() > 10000) {
            this.fatal_error = true;
        }
    }

    private class Error {
        public final String msg;
        public int first_line = 0;
        public int last_line = 0;

        public Error(String string, int n) {
            this.msg = string;
            this.first_line = this.last_line = n;
        }
    }
}

