/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.dea_ems;

import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.DEAEMSAdapter;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.DeaEmsSOAP12Request;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.DeaEmsSOAPRequest;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.types.Booking;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.types.EMSResponse;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.types.GetAllRoomBookingsResponse;
import de.wilke.wizepanel.eventmanager.adapters.dea_ems.types.GetAllRoomsResult;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.logging.log4j.Logger;

public class DeaEmsTask
extends AdapterJob {
    private final DEAEMSAdapter m_cfg;
    private Map<String, String> room_ids = null;
    private final List<String> qualifiers;
    private String historyDuration;
    private int last_run_hashcode = 0;

    public DeaEmsTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.m_cfg = (DEAEMSAdapter)abstractAdapterConfiguration;
        this.qualifiers = this.m_cfg.privateEventQualifiers();
        if (abstractAdapterConfiguration.targets() == null || abstractAdapterConfiguration.targets().size() == 0) {
            this.stop();
            return;
        }
        this.historyDuration = "0";
        for (GroupData groupData : GroupManager.getManager().getGroups()) {
            if (!groupData.adapters.contains(abstractAdapterConfiguration.getName()) || Long.valueOf(groupData.historyDuration) <= Long.valueOf(this.historyDuration)) continue;
            this.historyDuration = groupData.historyDuration;
        }
        if (this.historyDuration.equals("0")) {
            this.historyDuration = WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        logger.info("Installing new DEA EMS adapter: " + this.m_cfg.server() + " for rooms: " + abstractAdapterConfiguration.targets());
    }

    @Override
    public synchronized void singleRun() {
        Booking booking;
        Iterator<Object> iterator;
        Object object;
        Object object2;
        Object object322;
        if (this.room_ids == null) {
            this.room_ids = new HashMap<String, String>();
            for (Object object322 : this.m_cfg.targets()) {
                this.room_ids.put(DEAEMSAdapter.extractID((String)object322), (String)object322);
            }
            object2 = new GetAllRoomsResult();
            if (this.m_cfg.soap1_2()) {
                object322 = new DeaEmsSOAP12Request(this.m_cfg.server(), this.m_cfg.user(), this.m_cfg.password());
                if (!((DeaEmsSOAP12Request)object322).exec((EMSResponse)object2)) {
                    this.logger.error("Failed to read rooms: " + ((EMSResponse)object2).error());
                    this.stop();
                }
            } else {
                object322 = new DeaEmsSOAPRequest(this.m_cfg.server(), this.m_cfg.user(), this.m_cfg.password());
                if (!((DeaEmsSOAPRequest)object322).exec((EMSResponse)object2)) {
                    this.logger.error("Failed to read rooms: " + ((EMSResponse)object2).error());
                    this.stop();
                }
            }
        }
        object2 = Calendar.getInstance();
        ((Calendar)object2).setTimeInMillis(((Calendar)object2).getTimeInMillis() - Long.valueOf(this.historyDuration));
        object322 = ((Calendar)object2).getTime();
        java.util.Date date = this.m_cfg.range().getRangeDate();
        this.logger.info("GetEvents: " + ((java.util.Date)object322).toString() + " - " + date.toString());
        HashMap<String, List<Booking>> hashMap = new HashMap<String, List<Booking>>();
        int n = 0;
        for (String object4 : this.room_ids.keySet()) {
            Object object3 = new GetAllRoomBookingsResponse(object4, (java.util.Date)object322, date);
            if (this.m_cfg.soap1_2()) {
                object = new DeaEmsSOAP12Request(this.m_cfg.server(), this.m_cfg.user(), this.m_cfg.password());
                if (!((DeaEmsSOAP12Request)object).exec((EMSResponse)object3)) {
                    this.logger.error("Failed to read room: " + object4 + ". Error: " + ((EMSResponse)object3).error());
                    continue;
                }
            } else {
                object = new DeaEmsSOAPRequest(this.m_cfg.server(), this.m_cfg.user(), this.m_cfg.password());
                if (!((DeaEmsSOAPRequest)object).exec((EMSResponse)object3)) {
                    this.logger.error("Failed to read room: " + object4 + ". Error: " + ((EMSResponse)object3).error());
                    continue;
                }
            }
            if ((object = ((GetAllRoomBookingsResponse)object3).bookings()) == null || object.size() == 0) continue;
            iterator = object.iterator();
            while (iterator.hasNext()) {
                booking = (Booking)iterator.next();
                n += booking.id().hashCode() + booking.getChangeKey().hashCode();
            }
            hashMap.put(object4, (List<Booking>)object);
        }
        if (this.last_run_hashcode != n) {
            LinkedList linkedList = new LinkedList();
            for (Object object3 : hashMap.keySet()) {
                object = (List)hashMap.get(object3);
                this.logger.info("Room[{}]: received bookings: #{}", object3, (Object)object.size());
                iterator = object.iterator();
                while (iterator.hasNext()) {
                    booking = (Booking)iterator.next();
                    CalendarEvent calendarEvent = this.create_event(booking, this.room_ids.get(object3));
                    if (calendarEvent == null) continue;
                    linkedList.add(calendarEvent);
                }
            }
            this.setAdapterEvents(linkedList);
            this.last_run_hashcode = n;
        }
    }

    private CalendarEvent create_event(Booking booking, String string) {
        DateTime dateTime = new DateTime(booking.getStart());
        dateTime.setUtc(true);
        DateTime dateTime2 = new DateTime(booking.getEnd());
        dateTime2.setUtc(true);
        this.logger.info("Creating new event at: " + WpTimeUtils.date2str((java.util.Date)booking.getStart()));
        boolean bl = this.qualifiers != null && this.qualifiers.contains(booking.eventType());
        XWizePanel xWizePanel = new XWizePanel();
        xWizePanel.add(XWizePanel.WPDataItem.TargetStationPath, string);
        xWizePanel.add(XWizePanel.WPDataItem.AdapterCfg, this.m_cfg.getName());
        xWizePanel.add(XWizePanel.WPDataItem.Placeholders, booking.customPlaceholders());
        if (bl) {
            xWizePanel.add(XWizePanel.WPDataItem.PrivateEventSummary, this.m_cfg.privateEventSummary());
        }
        VAlarm vAlarm = null;
        if (!this.m_cfg.ignoreAlarm() && booking.getReminderMinutesBeforeStart() > 0) {
            vAlarm = new VAlarm();
            vAlarm.getProperties().add((Property)Action.DISPLAY);
            vAlarm.getProperties().add((Property)new Trigger(new Dur("-PT" + booking.getReminderMinutesBeforeStart() + "M")));
            vAlarm.getProperties().add((Property)new Description("Alarma!"));
        }
        Organizer organizer = null;
        if (!booking.contact().isEmpty()) {
            organizer = new Organizer();
            organizer.getParameters().add((Parameter)new Cn(booking.contact()));
        }
        VEvent vEvent = new VEvent((Date)dateTime, (Date)dateTime2, booking.subject());
        vEvent.getProperties().add((Property)new Uid(booking.id()));
        vEvent.getProperties().add((Property)new Location(booking.location()));
        vEvent.getProperties().add((Property)new XProperty(xWizePanel.getICSName(), xWizePanel.getICSValue()));
        if (vAlarm != null) {
            vEvent.getAlarms().add((Component)vAlarm);
        }
        if (organizer != null) {
            vEvent.getProperties().add((Property)organizer);
        }
        if (bl) {
            vEvent.getProperties().add((Property)Clazz.PRIVATE);
        }
        try {
            return new CalendarEvent(vEvent, true);
        }
        catch (Exception exception) {
            this.logger.error((Object)exception);
            return null;
        }
    }
}

