/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.dea_ems.types;

import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public abstract class EMSResponse {
    private final String tag;
    private String error = null;

    public EMSResponse(String string) {
        this.tag = string;
    }

    public boolean parseResponse(String string) {
        if (string == null) {
            this.error = "Response is null";
            return false;
        }
        String string2 = this.extract_response(string);
        if (string2 == null) {
            this.error = "Could not parse: " + string;
            return false;
        }
        boolean bl = this.parse(string2);
        if (!bl) {
            this.check_for_error(string2);
        }
        return bl;
    }

    public String getSOAP12(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap12:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap12=\"http://www.w3.org/2003/05/soap-envelope\">");
        stringBuilder.append("  <soap12:Body>");
        stringBuilder.append(this.createRequest(string, string2));
        stringBuilder.append("  </soap12:Body>");
        stringBuilder.append("</soap12:Envelope>");
        return stringBuilder.toString();
    }

    public String getSOAP(String string, String string2) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        stringBuilder.append("<soap:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:soap=\"http://schemas.xmlsoap.org/soap/envelope/\">");
        stringBuilder.append("  <soap:Body>");
        stringBuilder.append(this.createRequest(string, string2));
        stringBuilder.append("  </soap:Body>");
        stringBuilder.append("</soap:Envelope>");
        return stringBuilder.toString();
    }

    protected abstract String createRequest(String var1, String var2);

    protected abstract boolean parse(String var1);

    private String extract_response(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            NodeList nodeList = document.getElementsByTagName(this.tag);
            if (nodeList.getLength() != 1) {
                return null;
            }
            Node node = nodeList.item(0);
            return node.getTextContent();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private void check_for_error(String string) {
        try {
            NodeList nodeList;
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new InputSource(new StringReader(string)));
            if (document.getElementsByTagName("Errors").getLength() == 1 && document.getElementsByTagName("Error").getLength() == 1 && (nodeList = document.getElementsByTagName("Message")).getLength() == 1) {
                this.error = nodeList.item(0).getTextContent();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected String date2str(Date date) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
        return simpleDateFormat.format(date);
    }

    public boolean hasError() {
        return this.error != null;
    }

    public String error() {
        return this.error;
    }
}

