/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.googlecal;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.GoogleCalendarAdapter;
import de.wilke.wizepanel.core.adapters.types.GoogleCalendarAdapterFormat;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarFile;
import edu.emory.mathcs.backport.java.util.Collections;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.nio.charset.Charset;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.logging.log4j.Logger;

public class GoogleCalendarTask
extends AdapterJob {
    private final GoogleCalendarAdapter adapter;
    private final GoogleCalendarAdapterFormat m_fmt;
    private final Set<String> rooms = new HashSet<String>();
    private int last_dir_checksum = 0;

    public GoogleCalendarTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.adapter = (GoogleCalendarAdapter)abstractAdapterConfiguration;
        this.rooms.addAll(this.adapter.targets());
        this.m_fmt = this.adapter.getFormat();
    }

    @Override
    public void singleRun() throws Throwable {
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (this.getRequestorType() == Authenticator.RequestorType.PROXY) {
                    String string = this.getRequestingProtocol().toLowerCase();
                    String string2 = System.getProperty(string + ".proxyHost", System.getProperty("http.proxyHost"));
                    String string3 = System.getProperty(string + ".proxyPort", System.getProperty("http.proxyPort"));
                    String string4 = System.getProperty(string + ".proxyUser");
                    String string5 = System.getProperty(string + ".proxyPassword");
                    if (this.getRequestingHost().equalsIgnoreCase(string2) && Integer.parseInt(string3) == this.getRequestingPort()) {
                        return new PasswordAuthentication(string4, string5.toCharArray());
                    }
                }
                return null;
            }
        });
        try {
            String string = WpFileUtils.downloadFile((String)this.adapter.server(), (Charset)Charset.forName(this.adapter.getEncoding()));
            CalendarFile calendarFile = new CalendarFile(string, false);
            Date date = this.adapter.range().getRangeDate();
            LinkedList<CalendarEvent> linkedList = new LinkedList<CalendarEvent>();
            Collections.sort(calendarFile.getEvents(), (Comparator)new Comparator<CalendarEvent>(){

                @Override
                public int compare(CalendarEvent calendarEvent, CalendarEvent calendarEvent2) {
                    return calendarEvent.getUID().compareTo(calendarEvent2.getUID());
                }
            });
            HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
            boolean bl = false;
            for (CalendarEvent calendarEvent : calendarFile.getEvents()) {
                String[] stringArray;
                if (calendarEvent.status_cancel() || calendarEvent.req_attendee_cancelled()) continue;
                if (date == null) {
                    bl = true;
                } else if (calendarEvent.startsBefore(date)) {
                    bl = true;
                }
                if (!bl) continue;
                if (this.rooms.contains("EVENTS")) {
                    calendarEvent.setAdapterName(this.adapter.getName());
                    calendarEvent.setTargetName("EVENTS");
                    calendarEvent.setUID(this.adapter.getName() + calendarEvent.getUID());
                    if (this.adapter.defaultAlarm() != 0) {
                        calendarEvent.setReminderTime(this.adapter.defaultAlarm() * 60);
                    }
                    linkedList.add(calendarEvent);
                    hashCodeBuilder.append((Object)calendarEvent.getUID()).append(calendarEvent.getLastModified().getTime());
                }
                if (this.rooms.contains(calendarEvent.getLocation())) {
                    stringArray = new CalendarEvent(calendarEvent);
                    stringArray.setUID(this.adapter.getName() + calendarEvent.getUID());
                    stringArray.setAdapterName(this.adapter.getName());
                    stringArray.setTargetName(calendarEvent.getLocation());
                    if (this.adapter.defaultAlarm() != 0) {
                        calendarEvent.setReminderTime(this.adapter.defaultAlarm() * 60);
                    }
                    linkedList.add((CalendarEvent)stringArray);
                    hashCodeBuilder.append((Object)stringArray.getUID()).append(stringArray.getLastModified().getTime());
                }
                if (this.m_fmt.getLocationSeparatorEscaped() == "" || this.m_fmt.getLocationSeparatorEscaped() == null || calendarEvent.getLocation() == null || (stringArray = calendarEvent.getLocation().split(this.m_fmt.getLocationSeparatorEscaped())).length <= 0) continue;
                for (String string2 : stringArray) {
                    if (string2 == "" || string2 == "EVENTS" || !this.rooms.contains(string2)) continue;
                    CalendarEvent calendarEvent2 = new CalendarEvent(calendarEvent);
                    calendarEvent2.setLocation(string2);
                    calendarEvent2.setUID(this.adapter.getName() + string2 + calendarEvent2.getUID());
                    calendarEvent2.setAdapterName(this.adapter.getName());
                    calendarEvent2.setTargetName(string2);
                    if (this.adapter.defaultAlarm() != 0) {
                        calendarEvent.setReminderTime(this.adapter.defaultAlarm() * 60);
                    }
                    linkedList.add(calendarEvent2);
                    hashCodeBuilder.append((Object)calendarEvent2.getUID()).append(calendarEvent2.getLastModified().getTime());
                }
            }
            Collections.sort(linkedList, (Comparator)new Comparator<CalendarEvent>(){

                @Override
                public int compare(CalendarEvent calendarEvent, CalendarEvent calendarEvent2) {
                    return calendarEvent.getUID().compareTo(calendarEvent2.getUID());
                }
            });
            if (hashCodeBuilder.toHashCode() == this.last_dir_checksum) {
                return;
            }
            this.last_dir_checksum = hashCodeBuilder.toHashCode();
            this.setAdapterEvents(linkedList);
        }
        catch (Exception exception) {
            this.addAdapterError(exception.getMessage());
        }
    }
}

