/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_ews.types;

import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSItemBase;
import de.wilke.wizepanel.eventmanager.adapters.ms_ews.types.EWSUTCTime;
import java.util.Date;
import org.w3c.dom.Element;

public class EWSCalendarEvent
extends EWSItemBase {
    private static final String XML_PARENT_NODE = ":Items";
    private static final String XML_CALENDAR_ITEM = "t:CalendarItem";
    private static final String XML_ITEM_ID = "t:ItemId";
    private static final String XML_PARENT_FOLDER_ID = "t:ParentFolderId";
    private static final String XML_SUBJECT = "t:Subject";
    private static final String XML_LOCATION = "t:Location";
    private static final String XML_BODY = "t:Body";
    private static final String XML_START = "t:Start";
    private static final String XML_END = "t:End";
    private static final String XML_REMINDER_MINUTES_BEFORE_START = "t:ReminderMinutesBeforeStart";
    private static final String XML_SENSITIVITY = "t:Sensitivity";
    private static final String XML_FREE_BUSY_STATUS = "t:LegacyFreeBusyStatus";
    private static final String XML_ORGANIZER_NAME = "t:Name";
    private static final String XML_ORGANIZER_MAIL = "t:EmailAddress";
    private static final String XML_ATTR_ID = "Id";
    private static final String XML_ATTR_CHANGEKEY = "ChangeKey";
    private String id;
    private String change_key;
    private String parent_folder_id;
    private String subject;
    private String location;
    private String body;
    private EWSUTCTime start;
    private EWSUTCTime end;
    private int reminder_minutes_before_start;
    private boolean is_private = false;
    private boolean is_preliminary = false;
    private String organizer_name = "";
    private String organizer_mail = "";

    public EWSCalendarEvent() {
        super(XML_PARENT_NODE, XML_CALENDAR_ITEM, new String[]{XML_ITEM_ID, XML_PARENT_FOLDER_ID, XML_SUBJECT, XML_LOCATION, XML_BODY, XML_START, XML_END, XML_REMINDER_MINUTES_BEFORE_START, XML_ORGANIZER_NAME, XML_ORGANIZER_MAIL, XML_SENSITIVITY});
    }

    public EWSCalendarEvent(String string, String string2, String string3, String string4, String string5, String string6, EWSUTCTime eWSUTCTime, EWSUTCTime eWSUTCTime2, int n, String string7, String string8, boolean bl, boolean bl2) {
        this();
        this.id = string;
        this.change_key = string2;
        this.parent_folder_id = string3;
        this.subject = string4;
        this.location = string5;
        this.body = string6;
        this.start = eWSUTCTime;
        this.end = eWSUTCTime2;
        this.reminder_minutes_before_start = n;
        this.organizer_name = string7;
        this.organizer_mail = string8;
        this.is_private = bl;
        this.is_preliminary = bl2;
    }

    public String getId() {
        return this.id;
    }

    public String getChangeKey() {
        return this.change_key;
    }

    public String getParentFolderId() {
        return this.parent_folder_id;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getLocation() {
        return this.location;
    }

    public String getBody() {
        return this.body;
    }

    public Date getStart() {
        return this.start.toJavaTime();
    }

    public Date getEnd() {
        return this.end.toJavaTime();
    }

    public int getReminderMinutesBeforeStart() {
        return this.reminder_minutes_before_start;
    }

    public String getOrganizerName() {
        return this.organizer_name;
    }

    public String getOrganizerMail() {
        return this.organizer_mail;
    }

    public boolean isPrivate() {
        return this.is_private;
    }

    public boolean isPreliminary() {
        return this.is_preliminary;
    }

    @Override
    public boolean isValid() {
        return this.id != null && this.subject != null;
    }

    @Override
    public boolean doSwallow(Element element) {
        if (!element.getParentNode().getNodeName().equals(XML_PARENT_NODE)) {
            // empty if block
        }
        if (element.getNodeName().equals(XML_ITEM_ID)) {
            if (element.hasAttribute(XML_ATTR_ID)) {
                this.id = element.getAttribute(XML_ATTR_ID);
            }
            if (element.hasAttribute(XML_ATTR_CHANGEKEY)) {
                this.change_key = element.getAttribute(XML_ATTR_CHANGEKEY);
            }
            return true;
        }
        if (element.getNodeName().equals(XML_PARENT_FOLDER_ID) && element.hasAttribute(XML_ATTR_ID)) {
            this.parent_folder_id = element.getAttribute(XML_ATTR_ID);
            return true;
        }
        if (element.getNodeName().equals(XML_SUBJECT)) {
            this.subject = element.getTextContent();
            return true;
        }
        if (element.getNodeName().equals(XML_SENSITIVITY)) {
            this.is_private = !element.getTextContent().equals("Normal");
            return true;
        }
        if (element.getNodeName().equals(XML_FREE_BUSY_STATUS)) {
            this.is_preliminary = element.getTextContent().equals("Tentative");
            return true;
        }
        if (element.getNodeName().equals(XML_LOCATION)) {
            this.location = element.getTextContent();
            return true;
        }
        if (element.getNodeName().equals(XML_BODY)) {
            this.body = element.getTextContent();
            return true;
        }
        if (element.getNodeName().equals(XML_START)) {
            this.start = new EWSUTCTime(element.getTextContent());
            return true;
        }
        if (element.getNodeName().equals(XML_END)) {
            this.end = new EWSUTCTime(element.getTextContent());
            return true;
        }
        if (element.getNodeName().equals(XML_REMINDER_MINUTES_BEFORE_START)) {
            this.reminder_minutes_before_start = Integer.parseInt(element.getTextContent());
            return true;
        }
        if (element.getNodeName().equals(XML_ORGANIZER_NAME)) {
            this.organizer_name = element.getTextContent();
            return true;
        }
        if (element.getNodeName().equals(XML_ORGANIZER_MAIL)) {
            this.organizer_mail = element.getTextContent();
            return true;
        }
        return false;
    }

    @Override
    public EWSItemBase shallowCopy() {
        return new EWSCalendarEvent(this.id, this.change_key, this.parent_folder_id, this.subject, this.location, this.body, this.start, this.end, this.reminder_minutes_before_start, this.organizer_name, this.organizer_mail, this.is_private, this.is_preliminary);
    }

    public String toICS() {
        return "";
    }

    public boolean equals(Object object) {
        if (object instanceof EWSCalendarEvent) {
            EWSCalendarEvent eWSCalendarEvent = (EWSCalendarEvent)object;
            return eWSCalendarEvent.getId().equals(this.id) && eWSCalendarEvent.getChangeKey().equals(this.change_key);
        }
        return false;
    }
}

