/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_ews.types;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class EWSUTCTime {
    private int year;
    private int month;
    private int day;
    private int hours;
    private int minutes;
    private int seconds;

    public EWSUTCTime(int n, int n2, int n3, int n4, int n5, int n6) {
        this.year = n;
        this.month = n2;
        this.day = n3;
        this.hours = n4;
        this.minutes = n5;
        this.seconds = n6;
    }

    public EWSUTCTime(String string) {
        this.year = Integer.parseInt(string.substring(0, 4));
        this.month = Integer.parseInt(string.substring(5, 7));
        this.day = Integer.parseInt(string.substring(8, 10));
        this.hours = Integer.parseInt(string.substring(11, 13));
        this.minutes = Integer.parseInt(string.substring(14, 16));
        this.seconds = Integer.parseInt(string.substring(17, 19));
    }

    public EWSUTCTime(Calendar calendar) {
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        this.year = calendar.get(1);
        this.month = calendar.get(2) + 1;
        this.day = calendar.get(5);
        this.hours = calendar.get(11);
        this.minutes = calendar.get(12);
        this.seconds = calendar.get(13);
    }

    public String toString() {
        return String.format("%04d-%02d-%02dT%02d:%02d:%02dZ", this.year, this.month, this.day, this.hours, this.minutes, this.seconds);
    }

    public Date toJavaTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        try {
            return simpleDateFormat.parse(this.toString());
        }
        catch (ParseException parseException) {
            parseException.printStackTrace();
            return null;
        }
    }

    public EWSUTCTime addMillis(long l) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        calendar.setTimeInMillis(this.toJavaTime().getTime() + l);
        return new EWSUTCTime(calendar);
    }
}

