/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_ews_online;

import de.wilke.wizepanel.core.PrettyPrinter;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.ExchangeEWSOnlineAdapter;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import microsoft.exchange.webservices.data.core.ExchangeService;
import microsoft.exchange.webservices.data.core.PropertySet;
import microsoft.exchange.webservices.data.core.enumeration.misc.ExchangeVersion;
import microsoft.exchange.webservices.data.core.enumeration.property.BasePropertySet;
import microsoft.exchange.webservices.data.core.enumeration.property.Sensitivity;
import microsoft.exchange.webservices.data.core.enumeration.property.WellKnownFolderName;
import microsoft.exchange.webservices.data.core.enumeration.search.FolderTraversal;
import microsoft.exchange.webservices.data.core.exception.service.local.ServiceLocalException;
import microsoft.exchange.webservices.data.core.service.folder.CalendarFolder;
import microsoft.exchange.webservices.data.core.service.folder.Folder;
import microsoft.exchange.webservices.data.core.service.item.Appointment;
import microsoft.exchange.webservices.data.core.service.item.Item;
import microsoft.exchange.webservices.data.core.service.schema.FolderSchema;
import microsoft.exchange.webservices.data.credential.ExchangeCredentials;
import microsoft.exchange.webservices.data.credential.WebCredentials;
import microsoft.exchange.webservices.data.property.complex.FolderId;
import microsoft.exchange.webservices.data.property.complex.ItemId;
import microsoft.exchange.webservices.data.property.complex.Mailbox;
import microsoft.exchange.webservices.data.property.definition.PropertyDefinitionBase;
import microsoft.exchange.webservices.data.search.CalendarView;
import microsoft.exchange.webservices.data.search.FindFoldersResults;
import microsoft.exchange.webservices.data.search.FolderView;
import microsoft.exchange.webservices.data.search.filter.SearchFilter;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.logging.log4j.Logger;

public class MSEWSOnlineTask
extends AdapterJob {
    private final ExchangeEWSOnlineAdapter m_cfg;
    private final ExchangeService m_ews;
    private final List<String> m_folders;
    private String historyDuration;
    private Calendar from;
    private Calendar to;
    private int last_run_hashcode = 0;

    public MSEWSOnlineTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) throws URISyntaxException {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.m_cfg = (ExchangeEWSOnlineAdapter)abstractAdapterConfiguration;
        this.historyDuration = "0";
        for (GroupData groupData : GroupManager.getManager().getGroups()) {
            if (!groupData.adapters.contains(abstractAdapterConfiguration.getName()) || Long.valueOf(groupData.historyDuration) <= Long.valueOf(this.historyDuration)) continue;
            this.historyDuration = groupData.historyDuration;
        }
        if (this.historyDuration.equals("0")) {
            this.historyDuration = WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        this.m_folders = abstractAdapterConfiguration.targets();
        if (this.m_folders == null || this.m_folders.size() == 0) {
            this.m_ews = null;
        } else {
            this.m_ews = new ExchangeService(ExchangeVersion.Exchange2010_SP2);
            WebCredentials webCredentials = new WebCredentials(this.m_cfg.user(), this.m_cfg.password());
            this.m_ews.setCredentials((ExchangeCredentials)webCredentials);
            this.m_ews.setUrl(new URI(this.m_cfg.server()));
            logger.info("Installing new Exchange Web Services interface: " + this.m_ews.getUrl().getHost().toString() + " for folders: " + this.m_folders + " [private: " + this.m_cfg.privateEventSummary() + "]");
        }
        if (this.m_ews == null) {
            this.stop();
        }
    }

    @Override
    public synchronized void singleRun() throws ServiceLocalException {
        Object object;
        Object object2;
        Object object3;
        Object exception;
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTimeInMillis() - Long.valueOf(this.historyDuration));
        this.from = calendar;
        this.to = Calendar.getInstance();
        this.to.setTime(this.m_cfg.range().getRangeDate());
        this.logger.info("GetEvents: " + this.from.toString() + " - " + this.to.toString());
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        int n = 0;
        for (String object5 : this.m_folders) {
            Object object4;
            block18: {
                object4 = new LinkedList();
                try {
                    SearchFilter.IsEqualTo isEqualTo;
                    PropertySet exception2;
                    exception = null;
                    object3 = "";
                    if (object5.contains("\\") || object5.contains("/")) {
                        object2 = object5.split("\\\\|\\/");
                        if (((String[])object2).length > 0) {
                            object3 = object2[((String[])object2).length - 1];
                        }
                        object = new FolderView(100);
                        exception2 = new PropertySet(BasePropertySet.IdOnly);
                        exception2.add((PropertyDefinitionBase)FolderSchema.DisplayName);
                        object.setPropertySet(exception2);
                        object.setTraversal(FolderTraversal.Deep);
                        isEqualTo = new SearchFilter.IsEqualTo((PropertyDefinitionBase)FolderSchema.FolderClass, (Object)"IPF.Appointment");
                        FindFoldersResults findFoldersResults = this.m_ews.findFolders(WellKnownFolderName.Root, (SearchFilter)isEqualTo, object);
                        for (Folder folder : findFoldersResults.getFolders()) {
                            if (!folder.getDisplayName().equals(object3)) continue;
                            exception = folder.getId();
                            break;
                        }
                    } else {
                        exception = new FolderId(WellKnownFolderName.Calendar, Mailbox.getMailboxFromString((String)object5));
                    }
                    if (exception == null) break block18;
                    object2 = this.from.getTime();
                    object = this.to.getTime();
                    exception2 = CalendarFolder.bind((ExchangeService)this.m_ews, (FolderId)exception);
                    isEqualTo = exception2.findAppointments(new CalendarView((java.util.Date)object2, (java.util.Date)object));
                    for (Appointment appointment : isEqualTo.getItems()) {
                        object4.add(appointment);
                    }
                    this.logger.info("Folder[" + object5 + "]: received events: #" + object4.size());
                }
                catch (Exception exception2) {
                    this.logger.error("Folder[" + object5 + "]:", (Throwable)exception2);
                    this.addAdapterError(MessageFormat.format("Mailbox[" + object5 + "]: {0}", exception2.getMessage()));
                    continue;
                }
            }
            if (object4.size() == 0) continue;
            try {
                this.m_ews.loadPropertiesForItems((Iterable)object4, PropertySet.FirstClassProperties);
                exception = object4.iterator();
                while (exception.hasNext()) {
                    object3 = (Item)exception.next();
                    n += object3.getId().hashCode() + object3.getLastModifiedTime().hashCode();
                }
                hashMap.put(object5, object4);
            }
            catch (Exception exception3) {
                exception3.printStackTrace();
            }
        }
        if (this.last_run_hashcode == 0 || this.last_run_hashcode != n) {
            LinkedList linkedList = new LinkedList();
            for (Object object4 : hashMap.keySet()) {
                exception = (List)hashMap.get(object4);
                object3 = exception.iterator();
                while (object3.hasNext()) {
                    object2 = (Item)object3.next();
                    try {
                        object = this.create_event((Item)object2, (String)object4);
                        if (object == null) {
                            n = 0;
                            continue;
                        }
                        linkedList.add(object);
                    }
                    catch (Exception exception4) {
                        this.logger.info("Installing new Exchange Web Services interface: " + this.m_ews.getUrl().getHost().toString() + " for folders: " + this.m_folders + " [private: " + this.m_cfg.privateEventSummary() + "]");
                        exception4.printStackTrace();
                    }
                }
            }
            this.setAdapterEvents(linkedList);
            this.last_run_hashcode = n;
        }
    }

    private CalendarEvent create_event(Item item, String string) throws Exception {
        Appointment appointment = (Appointment)item;
        DateTime dateTime = new DateTime(appointment.getStart());
        dateTime.setUtc(true);
        DateTime dateTime2 = new DateTime(appointment.getEnd());
        dateTime2.setUtc(true);
        boolean bl = this.m_cfg.privateEventSummary() != null && !this.m_cfg.privateEventSummary().isEmpty() && appointment.getSensitivity().equals((Object)Sensitivity.Private);
        this.logger.info("Creating new event at: " + WpTimeUtils.date2str((java.util.Date)appointment.getStart()) + " | private: " + bl + "|" + appointment.getSensitivity().equals((Object)Sensitivity.Private));
        XWizePanel xWizePanel = new XWizePanel();
        xWizePanel.add(XWizePanel.WPDataItem.TargetStationPath, string);
        xWizePanel.add(XWizePanel.WPDataItem.AdapterCfg, this.m_cfg.getName());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        PropertySet propertySet = new PropertySet(BasePropertySet.FirstClassProperties);
        Appointment appointment2 = Appointment.bind((ExchangeService)this.m_ews, (ItemId)appointment.getId(), (PropertySet)propertySet);
        hashMap.put("DESCRIPTION", PrettyPrinter.stripHTML((String)appointment2.getBody().toString()));
        xWizePanel.add(XWizePanel.WPDataItem.Placeholders, hashMap);
        if (bl) {
            xWizePanel.add(XWizePanel.WPDataItem.PrivateEventSummary, this.m_cfg.privateEventSummary());
        }
        VAlarm vAlarm = null;
        if (!this.m_cfg.ignoreAlarm() && appointment.getReminderMinutesBeforeStart() > 0) {
            vAlarm = new VAlarm();
            vAlarm.getProperties().add((Property)Action.DISPLAY);
            vAlarm.getProperties().add((Property)new Trigger(new Dur("-PT" + appointment.getReminderMinutesBeforeStart() + "M")));
            vAlarm.getProperties().add((Property)new Description("Alarma!"));
        }
        Organizer organizer = null;
        if (appointment.getOrganizer() != null) {
            try {
                organizer = new Organizer("MAILTO:" + appointment.getOrganizer().getAddress());
                if (appointment.getOrganizer().getName() != null) {
                    organizer.getParameters().add((Parameter)new Cn(appointment.getOrganizer().getName()));
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        VEvent vEvent = new VEvent((Date)dateTime, (Date)dateTime2, appointment.getSubject());
        vEvent.getProperties().add((Property)new Uid(appointment.getId().toString()));
        vEvent.getProperties().add((Property)new Location(appointment.getLocation()));
        vEvent.getProperties().add((Property)new XProperty(xWizePanel.getICSName(), xWizePanel.getICSValue()));
        if (vAlarm != null) {
            vEvent.getAlarms().add((Component)vAlarm);
        }
        if (organizer != null) {
            vEvent.getProperties().add((Property)organizer);
        }
        if (bl) {
            vEvent.getProperties().add((Property)Clazz.PRIVATE);
        }
        try {
            return new CalendarEvent(vEvent, true);
        }
        catch (Exception exception) {
            this.addAdapterError(exception.getMessage());
            return null;
        }
    }
}

