/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa;

import java.util.Properties;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MailTaskConnection {
    private static final String REQUEST_FOLDER = "Gel\u00c3\u00b6schte Objekte";
    private static final String STORE = "imap";
    private final String popServer;
    private final String popUser;
    private final String popPassword;
    private Store store = null;
    private Folder folder = null;
    private final Logger m_logger = LogManager.getLogger(MailTaskConnection.class);

    public MailTaskConnection(String string, String string2, String string3) {
        this.popServer = string;
        this.popUser = string2;
        this.popPassword = string3;
    }

    public void open_mailbox() throws Exception {
        this.m_logger.debug("Connecting to Gel\u00c3\u00b6schte Objekte on " + this.popUser + "@" + this.popServer);
        try {
            Properties properties = System.getProperties();
            Session session = Session.getDefaultInstance((Properties)properties, null);
            this.store = session.getStore(STORE);
            this.store.connect(this.popServer, this.popUser, this.popPassword);
            this.folder = this.store.getDefaultFolder();
            if (this.folder == null) {
                throw new Exception("No default folder");
            }
            this.folder = this.folder.getFolder(REQUEST_FOLDER);
            if (this.folder == null) {
                throw new Exception("No POP3 INBOX");
            }
            this.folder.open(2);
        }
        catch (AuthenticationFailedException authenticationFailedException) {
            throw new Exception("Login failed: " + authenticationFailedException.getMessage());
        }
        catch (Exception exception) {
            this.close_mailbox(false);
            throw new Exception("Open failed: " + exception.getMessage());
        }
    }

    public void close_mailbox(boolean bl) {
        this.m_logger.debug("Closing connection to " + this.popUser + "@" + this.popServer);
        try {
            if (this.folder != null) {
                this.folder.close(bl);
            }
            if (this.store != null) {
                this.store.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Message[] getMessages() {
        try {
            return this.folder.getMessages();
        }
        catch (MessagingException messagingException) {
            return null;
        }
    }
}

