/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa;

import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.eventmanager.Cfg;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa.FileComparator;
import de.wilke.wizepanel.eventmanager.adapters.ms_exchange_aaa.ICS;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SpoolTask
extends TimerTask {
    private final Logger m_logger = LogManager.getLogger(SpoolTask.class);
    private final File spool_dir = new File(Cfg.getSpoolDir());
    private final ICS ics;

    public SpoolTask(EventScheduler eventScheduler) {
        this.ics = new ICS(eventScheduler, this.m_logger);
    }

    @Override
    public void run() {
        try {
            this.check_spool_for_new_files();
            this.ics.cleanup();
        }
        catch (Throwable throwable) {
            this.m_logger.fatal(throwable.getMessage() + "[" + throwable.getClass().getCanonicalName() + "]", throwable);
        }
    }

    private void check_spool_for_new_files() {
        File[] fileArray = this.spool_dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".ics");
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        this.m_logger.info("New files: #" + fileArray.length);
        Arrays.sort(fileArray, new FileComparator());
        for (File file : fileArray) {
            File file2 = WpFileUtils.getUniqueFile((String)(Cfg.getEventDir() + "/" + file.getName()));
            try {
                WpFileUtils.moveFile((File)file, (File)file2);
                this.ics.addFile(file2.getName());
                this.m_logger.info("Added new file: " + file.getName() + " -> " + file2.getName());
            }
            catch (IOException iOException) {
                this.m_logger.warn("Could not MOVE file: " + file.getName());
            }
        }
    }
}

