/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.ms_graph;

import com.microsoft.aad.msal4j.ClientCredentialFactory;
import com.microsoft.aad.msal4j.ClientCredentialParameters;
import com.microsoft.aad.msal4j.ConfidentialClientApplication;
import com.microsoft.aad.msal4j.IAuthenticationResult;
import com.microsoft.aad.msal4j.IClientCredential;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.ExchangeGraphAdapter;
import de.wilke.wizepanel.core.groups.GroupData;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.cache.DeleteEventException;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarEventException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.TimeZone;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.parameter.Cn;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.logging.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class MSGraphTask
extends AdapterJob {
    static final String ExchangeDateFormat = "yyyy'-'MM'-'dd'T'HH':'mm':'ss";
    private String tenantId;
    private String clientId;
    private String clientSecret;
    private String scope = "https://graph.microsoft.com/.default";
    private String accessToken;
    private boolean overwriteEvents;
    private List<String> m_calendars;
    private String historyDuration;
    HashMap<String, String[]> userCalendarIdMap;
    ExchangeGraphAdapter m_cfg;
    private int last_run_hashcode = 0;
    private int new_hash_code = 0;

    public MSGraphTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.m_cfg = (ExchangeGraphAdapter)abstractAdapterConfiguration;
        this.tenantId = this.m_cfg.tenantId();
        this.clientId = this.m_cfg.clientId();
        this.clientSecret = this.m_cfg.password();
        this.m_calendars = this.m_cfg.targets();
        this.userCalendarIdMap = new HashMap();
        this.historyDuration = "0";
        for (GroupData groupData : GroupManager.getManager().getGroups()) {
            if (!groupData.adapters.contains(abstractAdapterConfiguration.getName()) || Long.valueOf(groupData.historyDuration) <= Long.valueOf(this.historyDuration)) continue;
            this.historyDuration = groupData.historyDuration;
        }
        if (this.historyDuration.equals("0")) {
            this.historyDuration = WpSystemLocator.getLocator().getEventHistoryDuration();
        }
        if (this.m_calendars != null && this.m_calendars.size() != 0) {
            logger.info("Installing new " + this.m_cfg.getDescription() + "[" + this.m_cfg.getName() + "] : Tennant=" + this.tenantId + " for calendars: " + this.m_calendars + " [private: " + this.m_cfg.privateEventSummary() + "]");
            if (this.getAccessTokenByClientCredentialGrant()) {
                this.fillUserCalendarIdMap();
                logger.info("Install done for " + this.m_cfg.getDescription() + "[" + this.m_cfg.getName() + "] : calendars set up: " + this.userCalendarIdMap.size());
            } else {
                logger.info("Install not done for " + this.m_cfg.getDescription() + "[" + this.m_cfg.getName() + "] : calendars set up failed. Will Try again on next run.");
            }
        } else {
            this.m_cfg = null;
            this.stop();
        }
    }

    private void fillUserCalendarIdMap() {
        for (String string : this.m_calendars) {
            Object object;
            String string2 = "";
            String string3 = "";
            if (string.contains("\\") || string.contains("/")) {
                object = string.split("\\\\|\\/");
                string2 = object[0];
                string3 = object[((String[])object).length - 1];
            } else {
                string2 = string;
                string3 = "";
            }
            if (!this.accountExists(string2)) {
                this.addAdapterError("Could not find account: \"" + string2 + "\"");
                continue;
            }
            object = this.getCalendarIDFromGraph(string2, string3);
            if (object == "") {
                this.addAdapterError("Could not get CalendarID for \"" + string + "\"");
                continue;
            }
            this.userCalendarIdMap.put(string, new String[]{string2, object});
        }
    }

    private boolean getAccessTokenByClientCredentialGrant() {
        String string = null;
        try {
            ConfidentialClientApplication confidentialClientApplication = ((ConfidentialClientApplication.Builder)ConfidentialClientApplication.builder((String)this.clientId, (IClientCredential)ClientCredentialFactory.createFromSecret((String)this.clientSecret)).authority("https://login.microsoftonline.com/" + this.tenantId + "/")).build();
            ClientCredentialParameters clientCredentialParameters = ClientCredentialParameters.builder(Collections.singleton(this.scope)).build();
            CompletableFuture completableFuture = confidentialClientApplication.acquireToken(clientCredentialParameters);
            confidentialClientApplication.validateAuthority();
            this.accessToken = ((IAuthenticationResult)completableFuture.get()).accessToken();
            return true;
        }
        catch (InterruptedException | MalformedURLException | ExecutionException exception) {
            string = MessageFormat.format("Error while getting access token: {0}", exception.getMessage());
            this.overwriteEvents = false;
            if (string != null) {
                this.addAdapterError(string);
            }
            return false;
        }
    }

    private boolean accountExists(String string) {
        String string2 = null;
        try {
            String string3 = URLEncoder.encode("displayName,userPrincipalName", "UTF-8");
            URL uRL = new URL("https://graph.microsoft.com/v1.0/users/" + string + "?$select=" + string3);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
            httpURLConnection.setRequestProperty("Accept", "application/json");
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                return true;
            }
            string2 = n == 404 ? String.format("Could not find account: \"%s\"", string) : String.format("Connection returned HTTP code: %s with message: %s", n, httpURLConnection.getResponseMessage());
        }
        catch (IOException iOException) {
            string2 = MessageFormat.format("Error while checking account (" + string + "): {0}", iOException.getMessage());
        }
        if (string2 != null) {
            this.addAdapterError(string2);
        }
        return false;
    }

    private String getCalendarIDFromGraph(String string, String string2) {
        return this.getCalendarIDFromGraph(string, string2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getCalendarIDFromGraph(String string, String string2, boolean bl) {
        Object object = null;
        try {
            String string3 = URLEncoder.encode("name,id", "UTF-8");
            URL uRL = null;
            uRL = string2 == "" ? new URL("https://graph.microsoft.com/v1.0/users/" + string + "/calendar?$select=" + string3) : new URL("https://graph.microsoft.com/v1.0/users/" + string + "/calendars?$select=" + string3);
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.setRequestMethod("GET");
            httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
            httpURLConnection.setRequestProperty("Accept", "application/json");
            int n = httpURLConnection.getResponseCode();
            if (n == 200) {
                String string4;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                StringBuilder stringBuilder = new StringBuilder();
                while ((string4 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string4);
                }
                JSONObject jSONObject = new JSONObject(stringBuilder.toString());
                if (!jSONObject.has("value")) return jSONObject.getString("id");
                JSONArray jSONArray = jSONObject.getJSONArray("value");
                int n2 = jSONArray.length();
                for (int i = 0; i < n2; ++i) {
                    JSONObject jSONObject2 = jSONArray.getJSONObject(i);
                    if (!string2.equals(jSONObject2.getString("name"))) continue;
                    return jSONObject2.getString("id");
                }
            } else if (n == 404) {
                object = "Could not find calendar \"" + string2 + "\" for account \"" + string + "\"";
            } else if (n == 401 && bl) {
                this.logger.info("Access token invalid. Trying to get new token.");
                if (this.getAccessTokenByClientCredentialGrant()) {
                    return this.getCalendarIDFromGraph(string, string2, false);
                }
            } else {
                object = String.format("Connection returned HTTP code: %s with message: %s", n, httpURLConnection.getResponseMessage());
            }
        }
        catch (IOException | JSONException throwable) {
            object = MessageFormat.format("Error while getting calendarID: {0}", throwable.getMessage());
        }
        if (object == null) return "";
        this.addAdapterError((String)object);
        return "";
    }

    private JSONArray getCalendarEventsFromGraph(String string, String string2, String string3, String string4) {
        return this.getCalendarEventsFromGraph(string, string2, string3, string4, true);
    }

    private JSONArray getCalendarEventsFromGraph(String string, String string2, String string3, String string4, boolean bl) {
        String string5 = null;
        JSONArray jSONArray = new JSONArray();
        try {
            String string6 = URLEncoder.encode(string3, "UTF-8");
            String string7 = URLEncoder.encode(string4, "UTF-8");
            String string8 = URLEncoder.encode("subject,body,start,end,organizer,reminderMinutesBeforeStart,sensitivity,location,lastModifiedDateTime", "UTF-8");
            String string9 = URLEncoder.encode("start/datetime", "UTF-8");
            JSONObject jSONObject = new JSONObject().put("@odata.nextLink", (Object)("https://graph.microsoft.com/v1.0/users/" + string + "/calendars/" + string2 + "/calendarView?startDateTime=" + string6 + "&endDateTime=" + string7 + "&$select=" + string8 + "&$orderby=" + string9));
            while (jSONObject.has("@odata.nextLink")) {
                URL uRL = new URL(jSONObject.getString("@odata.nextLink"));
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
                httpURLConnection.setRequestMethod("GET");
                httpURLConnection.setRequestProperty("Authorization", "Bearer " + this.accessToken);
                httpURLConnection.setRequestProperty("Accept", "application/json");
                httpURLConnection.setRequestProperty("Prefer", "outlook.body-content-type='text'");
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    String string10;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(httpURLConnection.getInputStream()));
                    StringBuilder stringBuilder = new StringBuilder();
                    while ((string10 = bufferedReader.readLine()) != null) {
                        stringBuilder.append(string10);
                    }
                    jSONObject = new JSONObject(stringBuilder.toString());
                    JSONArray jSONArray2 = jSONObject.getJSONArray("value");
                    for (int i = 0; i < jSONArray2.length(); ++i) {
                        jSONArray.put((Object)jSONArray2.getJSONObject(i));
                    }
                    continue;
                }
                if (n == 401 && bl) {
                    this.logger.info("Access token invalid. Trying to get new token.");
                    if (!this.getAccessTokenByClientCredentialGrant()) continue;
                    return this.getCalendarEventsFromGraph(string, string2, string3, string4, false);
                }
                string5 = String.format("Connection returned HTTP code: %s with message: %s", n, httpURLConnection.getResponseMessage());
                if (n != 404) {
                    this.overwriteEvents = false;
                }
                break;
            }
        }
        catch (IOException | JSONException throwable) {
            string5 = MessageFormat.format("Error while getting calendar events: {0}", throwable.getMessage());
            this.overwriteEvents = false;
        }
        if (string5 != null) {
            this.addAdapterError(string5);
        }
        return jSONArray;
    }

    @Override
    public synchronized void singleRun() {
        this.new_hash_code = 0;
        this.overwriteEvents = true;
        if (this.accessToken == "" && !this.getAccessTokenByClientCredentialGrant()) {
            return;
        }
        if (this.userCalendarIdMap.isEmpty()) {
            this.fillUserCalendarIdMap();
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(calendar.getTimeInMillis() - Long.valueOf(this.historyDuration));
        calendar.setTimeZone(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        Calendar calendar2 = Calendar.getInstance();
        calendar2.setTime(this.m_cfg.range().getRangeDate());
        calendar2.setTimeZone(TimeZone.getTimeZone("UTC"));
        String string = simpleDateFormat.format(calendar.getTime());
        String string2 = simpleDateFormat.format(calendar2.getTime());
        this.logger.info("GetEvents: " + string + " - " + string2);
        LinkedList<CalendarEvent> linkedList = new LinkedList<CalendarEvent>();
        this.userCalendarIdMap.forEach((string3, stringArray) -> {
            JSONArray jSONArray = this.getCalendarEventsFromGraph(stringArray[0], stringArray[1], string, string2);
            this.logger.info("Source[" + string3 + "]: received events: #" + jSONArray.length());
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    CalendarEvent calendarEvent = this.create_event(jSONArray.getJSONObject(i), (String)string3);
                    if (calendarEvent == null) continue;
                    this.new_hash_code += calendarEvent.getUID().hashCode() + calendarEvent.getLastModified().hashCode();
                    linkedList.add(calendarEvent);
                    continue;
                }
                catch (JSONException jSONException) {
                    this.logger.error(jSONException.getMessage());
                }
            }
        });
        if (this.last_run_hashcode != this.new_hash_code && this.overwriteEvents) {
            this.setAdapterEvents(linkedList);
            this.last_run_hashcode = this.new_hash_code;
        }
    }

    private CalendarEvent create_event(JSONObject jSONObject, String string) {
        String string2 = null;
        try {
            String string3 = jSONObject.getString("id");
            String string4 = StringEscapeUtils.unescapeHtml4((String)jSONObject.getString("subject"));
            JSONObject jSONObject2 = jSONObject.getJSONObject("body");
            String string5 = "";
            string5 = jSONObject2.getString("contentType") == "html" ? StringEscapeUtils.unescapeHtml4((String)jSONObject2.getString("content")) : StringEscapeUtils.unescapeJava((String)jSONObject2.getString("content"));
            JSONObject jSONObject3 = jSONObject.getJSONObject("start");
            JSONObject jSONObject4 = jSONObject.getJSONObject("end");
            DateTime dateTime = new DateTime(jSONObject3.getString("dateTime").substring(0, 19), ExchangeDateFormat, true);
            DateTime dateTime2 = new DateTime(jSONObject4.getString("dateTime").substring(0, 19), ExchangeDateFormat, true);
            DateTime dateTime3 = new DateTime(jSONObject.getString("lastModifiedDateTime").substring(0, 19), ExchangeDateFormat, true);
            JSONObject jSONObject5 = jSONObject.getJSONObject("organizer");
            JSONObject jSONObject6 = jSONObject5.getJSONObject("emailAddress");
            int n = jSONObject.getInt("reminderMinutesBeforeStart");
            String string6 = jSONObject.getString("sensitivity");
            JSONObject jSONObject7 = jSONObject.getJSONObject("location");
            boolean bl = this.m_cfg.privateEventSummary() != null && !this.m_cfg.privateEventSummary().isEmpty() && string6.equals("private");
            this.logger.info("Creating new event at: " + WpTimeUtils.date2str((java.util.Date)dateTime) + " | private: " + bl + "|" + string6.equals("private"));
            XWizePanel xWizePanel = new XWizePanel();
            xWizePanel.add(XWizePanel.WPDataItem.TargetStationPath, string);
            xWizePanel.add(XWizePanel.WPDataItem.AdapterCfg, this.m_cfg.getName());
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("DESCRIPTION", string5);
            xWizePanel.add(XWizePanel.WPDataItem.Placeholders, hashMap);
            if (bl) {
                xWizePanel.add(XWizePanel.WPDataItem.PrivateEventSummary, this.m_cfg.privateEventSummary());
            }
            VAlarm vAlarm = null;
            if (!this.m_cfg.ignoreAlarm() && n > 0) {
                vAlarm = new VAlarm();
                vAlarm.getProperties().add((Property)Action.DISPLAY);
                vAlarm.getProperties().add((Property)new Trigger(new Dur("-PT" + n + "M")));
                vAlarm.getProperties().add((Property)new Description("Alarma!"));
            }
            Organizer organizer = new Organizer("MAILTO:" + jSONObject6.getString("address"));
            if (jSONObject6.getString("name") != null) {
                organizer.getParameters().add((Parameter)new Cn(jSONObject6.getString("name")));
            }
            VEvent vEvent = new VEvent((Date)dateTime, (Date)dateTime2, string4);
            vEvent.getProperties().add((Property)new Uid(string3));
            vEvent.getProperties().add((Property)new Location(jSONObject7.getString("displayName")));
            vEvent.getProperties().add((Property)new XProperty(xWizePanel.getICSName(), xWizePanel.getICSValue()));
            vEvent.getProperties().add((Property)new LastModified(dateTime3));
            if (vAlarm != null) {
                vEvent.getAlarms().add((Component)vAlarm);
            }
            if (organizer != null) {
                vEvent.getProperties().add((Property)organizer);
            }
            if (bl) {
                vEvent.getProperties().add((Property)Clazz.PRIVATE);
            }
            return new CalendarEvent(vEvent, true);
        }
        catch (DeleteEventException | CalendarEventException | URISyntaxException | ParseException | JSONException throwable) {
            string2 = MessageFormat.format("Error while getting creating calendar event: {0}", throwable.getMessage());
            if (!string2.isEmpty()) {
                this.addAdapterError(string2);
            }
            return null;
        }
    }
}

