/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.systemmonitor;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.SystemMonitorAdapter;
import de.wilke.wizepanel.core.warnings.WarningListEntry;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.adapters.systemmonitor.SystemMonitorUtils;
import de.wilke.wizepanel.server.Warnings;
import java.util.Calendar;
import java.util.Collection;
import org.apache.logging.log4j.Logger;

public class SystemMonitorTask
extends AdapterJob {
    private final SystemMonitorAdapter cfg;
    private final Calendar next_daily_update = Calendar.getInstance();
    private int last_sent_errors = 0;

    public SystemMonitorTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.cfg = (SystemMonitorAdapter)abstractAdapterConfiguration;
        logger.debug(this.cfg.server() + "/" + this.cfg.user() + "/" + WpUtils.implode((String)",", (Collection)this.cfg.to()));
        if (this.cfg.summaryTime() != -1) {
            this.next_daily_update.set(11, this.cfg.summaryTime());
            this.next_daily_update.set(12, 0);
            this.next_daily_update.set(13, 0);
        }
    }

    @Override
    public void singleRun() {
        if (this.cfg.reportErrorsImmediately()) {
            this.send_errors();
        }
        if (this.cfg.summaryTime() != -1 && System.currentTimeMillis() > this.next_daily_update.getTimeInMillis()) {
            this.send_warnings();
            this.logger.info("Daily report");
            this.next_daily_update.add(5, 1);
        }
    }

    private void send_errors() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("WizePanel Error report: ");
        int n = 0;
        for (WarningListEntry warningListEntry : Warnings.getInstance().toList(false)) {
            if (warningListEntry.type != WarningListEntry.Type.Error) continue;
            ++n;
            stringBuilder.append("+ " + warningListEntry.source.name() + " " + warningListEntry.source_details + " " + warningListEntry.message + "\n");
        }
        int n2 = stringBuilder.toString().hashCode();
        if (stringBuilder.length() == 0 || n2 == this.last_sent_errors) {
            return;
        }
        stringBuilder2.append(n + (n == 1 ? " error" : "errors"));
        this.last_sent_errors = n2;
        this.send_mail(stringBuilder2.toString(), stringBuilder.toString());
    }

    private void send_warnings() {
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        stringBuilder2.append("WizePanel Daily report: ");
        int n = 0;
        for (WarningListEntry warningListEntry : Warnings.getInstance().toList(false)) {
            if (warningListEntry.type == WarningListEntry.Type.Warning && !this.cfg.includeWarnings() || warningListEntry.type == WarningListEntry.Type.Information) continue;
            ++n;
            stringBuilder.append("+ " + warningListEntry.toString() + "\n");
        }
        if (stringBuilder.length() == 0) {
            stringBuilder.append("No issues");
            stringBuilder2.append("No issues");
        } else {
            stringBuilder2.append(n + (n == 1 ? " issue" : " issues"));
        }
        this.send_mail(stringBuilder2.toString(), stringBuilder.toString());
    }

    private void send_mail(String string, String object) {
        object = string + "\n\n" + (String)object + "\n\nGenerated by the WizePanel-Server on " + SystemMonitorUtils.computerName();
        try {
            SystemMonitorUtils.send_mail(this.cfg.server(), this.cfg.user(), this.cfg.password(), this.cfg.to(), string, (String)object, this.cfg.useSSL());
            this.logger.info("Sent email: {} {}", (Object)string, object);
        }
        catch (Exception exception) {
            this.addAdapterError("Could not send email: " + exception.getMessage());
        }
    }
}

