/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.adapters.xml;

import de.wilke.wizepanel.adapter.xml.jaxb.WpEvent;
import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.adapters.AbstractAdapterConfiguration;
import de.wilke.wizepanel.core.adapters.XMLAdapter;
import de.wilke.wizepanel.core.ics.XWizePanel;
import de.wilke.wizepanel.eventmanager.EventScheduler;
import de.wilke.wizepanel.eventmanager.adapters.AdapterJob;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import java.io.File;
import java.io.FileFilter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Property;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.Action;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Trigger;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.XProperty;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.logging.log4j.Logger;

public class XMLTask
extends AdapterJob {
    private static final String FILE_EXT = ".xml";
    private final XMLAdapter m_adapter;
    private final List<String> rooms;
    private final File watch_dir;
    private int last_dir_checksum = 0;
    private static final JAXBContext jaxb_context = XMLTask.initContext();
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String last_day_check = "";

    public XMLTask(Logger logger, AbstractAdapterConfiguration abstractAdapterConfiguration, EventScheduler eventScheduler) {
        super(logger, abstractAdapterConfiguration, eventScheduler);
        this.m_adapter = (XMLAdapter)abstractAdapterConfiguration;
        this.rooms = this.m_adapter.targets();
        this.watch_dir = new File(this.m_adapter.getWatchDir());
    }

    @Override
    public void singleRun() {
        if (jaxb_context == null) {
            this.addAdapterError("JAXB not initialized.");
            return;
        }
        if (!this.watch_dir.exists() || !this.watch_dir.isDirectory()) {
            this.addAdapterWarning("Directory does not exist: " + this.watch_dir.getAbsolutePath());
            return;
        }
        if (this.rooms == null) {
            this.addAdapterWarning("No rooms defined.");
            return;
        }
        File[] fileArray = this.watch_dir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().toLowerCase().endsWith(XMLTask.FILE_EXT);
            }
        });
        HashCodeBuilder hashCodeBuilder = new HashCodeBuilder();
        if (fileArray != null && fileArray.length != 0) {
            for (File comparable2 : fileArray) {
                hashCodeBuilder.append((Object)comparable2.getName()).append(comparable2.length()).append(comparable2.lastModified());
            }
        }
        String string = this.sdf.format(new java.util.Date());
        if (hashCodeBuilder.toHashCode() == this.last_dir_checksum && string.equals(this.last_day_check)) {
            return;
        }
        this.last_dir_checksum = hashCodeBuilder.toHashCode();
        this.last_day_check = string;
        LinkedList<CalendarEvent> linkedList = new LinkedList<CalendarEvent>();
        java.util.Date date = null;
        if (this.m_adapter.deleteAfterDays() != -1) {
            if (this.m_adapter.deleteAfterDays() == 0) {
                date = new java.util.Date();
            } else {
                Calendar calendar = Calendar.getInstance();
                calendar.add(5, -this.m_adapter.deleteAfterDays());
                date = calendar.getTime();
            }
        }
        java.util.Date date2 = this.m_adapter.range().getRangeDate();
        for (File file : fileArray) {
            try {
                CalendarEvent calendarEvent = this.convert_file(file.getAbsolutePath(), date2);
                if (date != null && calendarEvent.isExpired(date)) {
                    this.logger.debug(MessageFormat.format("Deleting file: {0}", file.getName()));
                    file.delete();
                    continue;
                }
                linkedList.add(calendarEvent);
            }
            catch (JAXBException jAXBException) {
                this.addAdapterError(MessageFormat.format("{0}: XML format error: {1}", file.getName(), jAXBException.getCause().getMessage()));
            }
            catch (Exception exception) {
                this.addAdapterWarning(MessageFormat.format("{0}: {1}", file.getName(), exception.getMessage()));
            }
        }
        this.setAdapterEvents(linkedList);
    }

    private CalendarEvent convert_file(String string, java.util.Date date) throws Exception {
        String string2;
        Unmarshaller unmarshaller = jaxb_context.createUnmarshaller();
        WpEvent wpEvent = (WpEvent)unmarshaller.unmarshal(new File(string));
        String string3 = string2 = wpEvent.SourceName == null ? wpEvent.TargetStation : wpEvent.SourceName;
        if (string2 == null) {
            throw new Exception("No source name found");
        }
        if (!this.rooms.contains(string2)) {
            throw new Exception("Ignoring source: " + string2);
        }
        if (wpEvent.Command == null || !wpEvent.Command.equalsIgnoreCase("DELETE")) {
            return this.generate_add(wpEvent, string2, date);
        }
        throw new Exception("Ignoring DELETE command");
    }

    private CalendarEvent generate_add(WpEvent wpEvent, String string, java.util.Date date) throws Exception {
        VEvent vEvent2;
        WpFile wpFile;
        DateTime dateTime = this.parse_date_time(wpEvent.Start);
        DateTime dateTime2 = this.parse_date_time(wpEvent.End);
        if (dateTime == null || dateTime2 == null) {
            throw new Exception("Start/End are invalid");
        }
        if (date != null && dateTime.after(date)) {
            throw new Exception("Too far away");
        }
        XWizePanel xWizePanel = new XWizePanel();
        xWizePanel.add(XWizePanel.WPDataItem.TargetStationPath, string);
        xWizePanel.add(XWizePanel.WPDataItem.AdapterCfg, this.m_adapter.getName());
        if (wpEvent.Template != null && (wpFile = new WpFile(wpEvent.Template, WpFile.WpFileType.TEMPLATE_FILE)).exists() && !wpFile.isDirectory()) {
            xWizePanel.add(XWizePanel.WPDataItem.Template, wpFile.getOriginalFileName());
        }
        wpFile = new HashMap();
        if (wpEvent.Placeholder != null && wpEvent.Placeholder.size() != 0) {
            for (VEvent vEvent2 : wpEvent.Placeholder) {
                wpFile.put(vEvent2.Name, vEvent2.Value);
            }
        }
        if (wpFile.size() != 0) {
            xWizePanel.add(XWizePanel.WPDataItem.Placeholders, (Map)wpFile);
        }
        VAlarm vAlarm = null;
        if (wpEvent.Alarm != null) {
            try {
                vAlarm = new VAlarm();
                vAlarm.getProperties().add((Property)Action.DISPLAY);
                vAlarm.getProperties().add((Property)new Trigger(new Dur("-PT" + Integer.parseInt(wpEvent.Alarm) + "M")));
                vAlarm.getProperties().add((Property)new Description("Alarma!"));
            }
            catch (NumberFormatException numberFormatException) {
                vAlarm = null;
            }
        }
        vEvent2 = new VEvent();
        vEvent2.getProperties().add((Property)new DtStart((Date)dateTime));
        vEvent2.getProperties().add((Property)new DtEnd((Date)dateTime2));
        vEvent2.getProperties().add((Property)new Uid(UUID.randomUUID().toString()));
        vEvent2.getProperties().add((Property)new XProperty(xWizePanel.getICSName(), xWizePanel.getICSValue()));
        if (vAlarm != null) {
            vEvent2.getAlarms().add((Component)vAlarm);
        }
        return new CalendarEvent(vEvent2, true);
    }

    private DateTime parse_date_time(String string) {
        java.util.Date date = WpTimeUtils.str2date((String)string);
        return date == null ? null : new DateTime(date);
    }

    private static JAXBContext initContext() {
        try {
            return JAXBContext.newInstance((Class[])new Class[]{WpEvent.class});
        }
        catch (JAXBException jAXBException) {
            jAXBException.printStackTrace();
            return null;
        }
    }
}

