/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.cache;

import de.wilke.wizepanel.eventmanager.Cfg;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Period;

public final class CacheEvent {
    private final CalendarEvent _event;

    public CacheEvent(CalendarEvent calendarEvent) {
        this._event = calendarEvent;
    }

    public List<Period> getRecurrences(DateTime dateTime, DateTime dateTime2) {
        return this._event.get(dateTime, dateTime2);
    }

    public CalendarEvent getCalendarEvent() {
        return this._event;
    }

    public Period getDisplayPeriod(Period period) {
        return new Period(this.minusSeconds(period.getStart(), this.getEventShift()), period.getDuration().add(new Dur(0, 0, 0, this.getEventShift())));
    }

    private DateTime minusSeconds(DateTime dateTime, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)dateTime);
        calendar.add(13, -n);
        return new DateTime(calendar.getTime());
    }

    private int getEventShift() {
        return this._event.getWakeUpTime() + this._event.getReminderTime() + Cfg.getSystemLatency();
    }
}

