/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.cache;

import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import java.util.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;

public class CacheResult
implements Comparable<CacheResult> {
    private final Period display_time;
    private final Period event_time;
    private final CalendarEvent event;

    public CacheResult(CalendarEvent calendarEvent, Period period, Period period2) {
        this.event = calendarEvent;
        this.event_time = period2;
        this.display_time = period;
    }

    public Period getEventTime() {
        return this.event_time;
    }

    public CalendarEvent getEvent() {
        return this.event;
    }

    public DateTime getDisplayOn() {
        return this.display_time.getStart();
    }

    public DateTime getDisplayTo() {
        return this.display_time.getEnd();
    }

    @Override
    public int compareTo(CacheResult cacheResult) {
        if (this.display_time.getStart().after((Date)cacheResult.display_time.getStart())) {
            return 1;
        }
        if (this.display_time.getStart().before((Date)cacheResult.display_time.getStart())) {
            return -1;
        }
        return 0;
    }

    public String toString() {
        return WpTimeUtils.date2str((Date)this.display_time.getStart()) + " - " + WpTimeUtils.date2str((Date)this.display_time.getEnd()) + " | " + WpTimeUtils.date2str((Date)this.event_time.getStart()) + " - " + WpTimeUtils.date2str((Date)this.event_time.getEnd()) + " | " + this.event.getSummary() + " [" + this.event.getAdapterName() + "#" + this.event.getTargetName() + "]";
    }
}

