/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.eventmanager.ical;

import de.wilke.wizepanel.core.UnicodeInputStream;
import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.eventmanager.cache.DeleteEventException;
import de.wilke.wizepanel.eventmanager.ical.CalendarEvent;
import de.wilke.wizepanel.eventmanager.ical.CalendarEventException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import net.fortuna.ical4j.data.CalendarBuilder;
import net.fortuna.ical4j.data.ParserException;
import net.fortuna.ical4j.model.Calendar;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.component.VEvent;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.util.CompatibilityHints;

public class CalendarFile {
    private final Calendar _cal;
    private final List<CalendarEvent> _events = new LinkedList<CalendarEvent>();
    private boolean isRealFile = false;
    private long lastModified = 0L;

    public CalendarFile(File file, Charset charset, boolean bl) throws WizePanelExceptions, DeleteEventException, CalendarEventException {
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        try {
            try (FileInputStream fileInputStream = new FileInputStream(file);){
                InputStreamReader inputStreamReader;
                switch (charset.toString()) {
                    case "UTF-16BE": 
                    case "UTF-16LE": 
                    case "UTF-8": 
                    case "UTF-32BE": 
                    case "UTF-32LE": {
                        UnicodeInputStream unicodeInputStream = new UnicodeInputStream((InputStream)fileInputStream, charset.toString());
                        String string = unicodeInputStream.getEncoding();
                        inputStreamReader = new InputStreamReader((InputStream)unicodeInputStream, string);
                        break;
                    }
                    default: {
                        inputStreamReader = new InputStreamReader((InputStream)fileInputStream, charset);
                    }
                }
                CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
                this._cal = calendarBuilder.build((Reader)inputStreamReader);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_EM_FILENOTFOUND);
            }
            catch (SecurityException securityException) {
                throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_EM_SECURITYEXCEPTION);
            }
        }
        catch (IOException | ParserException throwable) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_EM_INVALID_ICS, throwable.getMessage());
        }
        this.parse_cal(bl);
        this.isRealFile = true;
        this.lastModified = file.lastModified();
    }

    public CalendarFile(String string, boolean bl) throws WizePanelExceptions, CalendarEventException, DeleteEventException {
        CalendarBuilder calendarBuilder = new CalendarBuilder();
        try (StringReader stringReader = new StringReader(string);){
            CompatibilityHints.setHintEnabled((String)"ical4j.parsing.relaxed", (boolean)true);
            this._cal = calendarBuilder.build((Reader)stringReader);
        }
        catch (Exception exception) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_EM_INVALID_ICS, exception.getMessage());
        }
        this.parse_cal(bl);
    }

    private void parse_cal(boolean bl) throws WizePanelExceptions, CalendarEventException, DeleteEventException {
        int n = this._cal.getComponents("VEVENT").size();
        if (n == 0) {
            throw new WizePanelExceptions(WizePanelExceptions.ErrorCodes.WP_EM_NO_VEVENT);
        }
        for (Object e : this._cal.getComponents("VEVENT")) {
            this._events.add(new CalendarEvent((VEvent)e, bl));
        }
    }

    public List<CalendarEvent> getEvents() {
        return this._events;
    }

    public int getEventCount() {
        return this._events.size();
    }

    public CalendarEvent getEvent(int n) {
        try {
            return this._events.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public void print_debug() {
        if (this._cal == null) {
            System.out.println("No calendar created.");
            return;
        }
        System.out.println("Calendar components:");
        for (Object e : this._cal.getComponents()) {
            Component component = (Component)e;
            System.out.println("  + " + component.getName());
            if (component.getName().equals("VTIMEZONE") || !component.getName().equals("VEVENT")) continue;
            DtStart dtStart = (DtStart)component.getProperty("DTSTART");
            System.out.println("    + DTSTART: " + dtStart.getDate() + ", " + dtStart.getTimeZone().getDisplayName());
        }
    }

    public String getRawICSData() {
        return this._cal.toString();
    }

    public long getLastModified() {
        return this.isRealFile ? this.lastModified : 0L;
    }

    public void set_events(List<CalendarEvent> list) {
        this._events.clear();
        this._events.addAll(list);
    }
}

