/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server;

import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.Logger;

public abstract class AWpRequest {
    private Timer scheduler;
    private final String name;
    private final int interval;
    private final int start_delay;

    public AWpRequest(String string, int n) {
        this.name = string;
        this.interval = n;
        this.start_delay = 1;
    }

    public AWpRequest(String string, int n, int n2) {
        this.name = string;
        this.interval = n;
        this.start_delay = n2;
    }

    public abstract void requestBody();

    public final void start(boolean bl, final Logger logger, final boolean bl2) {
        if (this.interval <= 0 && !bl) {
            return;
        }
        if (bl) {
            logger.debug("Executing service [singleshort]: " + this.name);
            new Thread(new Runnable(){

                @Override
                public void run() {
                    if (bl2) {
                        logger.debug("Running");
                    }
                    AWpRequest.this.requestBody();
                }
            }).start();
        } else {
            logger.debug("Starting service [" + this.start_delay + "," + this.interval + "]: " + this.name);
            this.scheduler = new Timer(this.name);
            this.scheduler.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (bl2) {
                        logger.debug("Running");
                    }
                    AWpRequest.this.requestBody();
                }
            }, this.start_delay * 1000, (long)(this.interval * 1000));
        }
    }

    public void exit() {
        if (this.scheduler != null) {
            this.scheduler.cancel();
        }
    }

    public int getRequestInterval() {
        return this.interval;
    }
}

