/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.app.WP;
import de.wilke.wizepanel.core.app.WPApp;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.core.warnings.WarningList;
import de.wilke.wizepanel.core.warnings.WarningListEntry;
import de.wilke.wizepanel.server.ServerConnection;
import de.wilke.wizepanel.server.WPServer;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class GUI
extends WPApp
implements ActionListener {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = LogManager.getLogger(WPApp.class);
    public static final String APP_NAME = "launcher";
    public static final String APP_FULL_NAME = "WizePanel-Server";
    private static final String FILE_QUIT = "file.quit";
    private static final String COMMAND_TRAY = "command.tray";
    private final JButton m_quit;
    private TrayIcon _tray = null;
    private static final String PREF_APP_X = "app.x";
    private static final String PREF_APP_Y = "app.y";
    private static final String PREF_APP_WIDTH = "app.width";
    private static final String PREF_APP_HEIGHT = "app.height";
    private static final String PREF_STARTICONIFIED = "app.starticonified";
    private static final String PREF_START_LOCAL = "app.start_local";
    private final Preferences m_app_prefs = Preferences.userNodeForPackage(this.getClass());
    private final JCheckBox m_starticonified;
    private final JCheckBox m_start_local;
    private final JLabel server_status;
    private boolean kill_local = false;
    private boolean tried_to_start = false;
    private final ImageIcon icon_good;
    private final ImageIcon icon_bad;

    public GUI(JFrame jFrame, boolean bl) {
        super((Frame)jFrame, APP_NAME, WpSystemLocator.getLocator().getDefaultLanguage(), false);
        int n = WpSystemLocator.getLocator().getErrors().size() + WpUpiServerStaticFactory.getServerLocator().getErrors().size();
        WP.loadPreferences((WPApp)this);
        this.frame().setTitle(APP_FULL_NAME);
        this.frame().setIconImage(WPApp.getFactoryImage((String)"wplauncher.png"));
        boolean bl2 = true;
        this.icon_good = GUI.getFactoryIcon((String)"small/flag-blue.gif");
        this.icon_bad = GUI.getFactoryIcon((String)"small/flag-red.gif");
        this.m_quit = new JButton(GUI.tr((String)FILE_QUIT));
        this.m_quit.setActionCommand(FILE_QUIT);
        this.m_quit.addActionListener(this);
        this.m_starticonified = new JCheckBox(GUI.tr((String)PREF_STARTICONIFIED), this.m_app_prefs.getBoolean(PREF_STARTICONIFIED, true));
        this.m_start_local = new JCheckBox(GUI.tr((String)PREF_START_LOCAL), this.m_app_prefs.getBoolean(PREF_START_LOCAL, true));
        this.m_start_local.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!GUI.this.serverIsRunning()) {
                    GUI.this.m_start_local.setEnabled(false);
                    GUI.this.server_status.setText(GUI.tr((String)"ask.start_server"));
                    GUI.this.startLocalServer();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ServerConnection serverConnection;
                            boolean bl;
                            for (int i = 0; i < 10 && !(bl = (serverConnection = new ServerConnection(logger)).isRunning()); ++i) {
                                try {
                                    Thread.sleep(1000L);
                                    continue;
                                }
                                catch (InterruptedException interruptedException) {
                                    // empty catch block
                                }
                            }
                            GUI.this.tried_to_start = true;
                            GUI.this.update_connection_status();
                            GUI.this.m_start_local.setEnabled(true);
                        }
                    });
                }
            }
        });
        if (!bl && !this.m_start_local.isSelected()) {
            ++n;
        }
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        jPanel.add((Component)new JLabel(WpFileUtils.readTextFile((File)new WpFile("${env_var:WIZEPANEL_HOME}/VERSION.txt").getJavaFile())), "South");
        jPanel.add(this.m_quit);
        jPanel.add(this.m_starticonified);
        jPanel.add(this.m_start_local);
        this.server_status = new JLabel();
        this.setServerIsRunning(bl);
        LicenseManager licenseManager = LicenseManager.getManager();
        Object object = "";
        ImageIcon imageIcon = null;
        if (licenseManager.exists()) {
            ImageIcon imageIcon2 = imageIcon = licenseManager.hasValidLicense() ? this.icon_good : this.icon_bad;
            if (licenseManager.hasValidLicense()) {
                object = GUI.tr((String)"Valid");
            } else {
                Object object2 = object = licenseManager.license().isExpired() ? GUI.tr((String)"Expired") + ": " + licenseManager.license().expires() : GUI.tr((String)"Invalid.");
            }
            if (licenseManager.hasValidLicense()) {
                object = (String)object + "<br/>" + licenseManager.license().customer() + " | " + licenseManager.license().date();
                if (!licenseManager.license().expires().isEmpty()) {
                    object = (String)object + " - " + licenseManager.license().expires();
                }
                object = (String)object + "<br/>";
            } else {
                bl2 = false;
            }
        } else {
            object = (String)object + GUI.tr((String)"License file not found.");
            imageIcon = this.icon_bad;
            bl2 = false;
        }
        if (n != 0) {
            bl2 = false;
        }
        JTabbedPane jTabbedPane = this.create_tabs(n, (String)object, imageIcon, licenseManager);
        Container container = jFrame.getContentPane();
        if (container instanceof JComponent) {
            ((JComponent)container).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        }
        JPanel jPanel2 = new JPanel(new BorderLayout(5, 5));
        jPanel2.add((Component)this.server_status, "Center");
        jPanel2.add((Component)jPanel, "East");
        container.setLayout(new BorderLayout(5, 5));
        container.add((Component)jPanel2, "North");
        container.add((Component)jTabbedPane, "Center");
        if (SystemTray.isSupported()) {
            SystemTray systemTray = SystemTray.getSystemTray();
            PopupMenu popupMenu = new PopupMenu();
            MenuItem menuItem = new MenuItem(GUI.tr((String)COMMAND_TRAY));
            menuItem.setActionCommand(COMMAND_TRAY);
            menuItem.addActionListener(this);
            popupMenu.add(menuItem);
            popupMenu.addSeparator();
            menuItem = new MenuItem(GUI.tr((String)FILE_QUIT));
            menuItem.setActionCommand(FILE_QUIT);
            menuItem.addActionListener(this);
            popupMenu.add(menuItem);
            this._tray = new TrayIcon(GUI.getFactoryIcon((String)"small/wplauncher.png").getImage(), GUI.tr((String)APP_NAME), popupMenu);
            this._tray.setActionCommand(COMMAND_TRAY);
            this._tray.addActionListener(this);
            try {
                systemTray.add(this._tray);
            }
            catch (AWTException aWTException) {
                this._tray = null;
            }
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 480;
        int n5 = 320;
        int n6 = Math.max(n2, this.m_app_prefs.getInt(PREF_APP_X, n2));
        int n7 = Math.max(n3, this.m_app_prefs.getInt(PREF_APP_Y, n3));
        int n8 = Math.max(n4, this.m_app_prefs.getInt(PREF_APP_WIDTH, n4));
        int n9 = Math.max(n5, this.m_app_prefs.getInt(PREF_APP_HEIGHT, n5));
        jFrame.setLocation(n6, n7);
        jFrame.setSize(new Dimension(n8, n9));
        jFrame.setMinimumSize(new Dimension(n4, n5));
        jFrame.setDefaultCloseOperation(0);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                GUI.this.frame().setState(1);
                if (GUI.this._tray != null) {
                    GUI.this._tray.displayMessage(null, WPApp.tr((String)"minimized"), TrayIcon.MessageType.INFO);
                }
                super.windowClosing(windowEvent);
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                if (GUI.this._tray != null) {
                    GUI.this.frame().setVisible(false);
                }
                super.windowIconified(windowEvent);
            }
        });
        if (this.m_starticonified.isSelected() && bl2) {
            this.frame().setState(1);
        }
        long l = 1000L;
        if (!bl && this.m_start_local.isSelected()) {
            this.startLocalServer();
            l = 10000L;
        }
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                GUI.this.update_connection_status();
            }
        }, l, 10000L);
    }

    private JTabbedPane create_tabs(int n, String string, Icon icon, LicenseManager licenseManager) {
        Object object3;
        JTextPane jTextPane = new JTextPane();
        jTextPane.setContentType("text/html");
        jTextPane.setEditable(false);
        jTextPane.setText("<html>" + string + "<hr/><ul><li>" + licenseManager.toString().replace(" ", "</li><li>") + "</li></ul></html>");
        Component component = this.create_warnings(n != 0);
        Object object2 = "";
        for (Object object3 : WpSystemLocator.getLocator().getErrors()) {
            object2 = (String)object2 + (String)object3 + "\n";
        }
        for (Object object3 : WpUpiServerStaticFactory.getServerLocator().getErrors()) {
            object2 = (String)object2 + (String)object3 + "\n";
        }
        JTextPane jTextPane2 = new JTextPane();
        jTextPane2.setEditable(false);
        jTextPane2.setText((String)object2);
        object3 = new JTabbedPane();
        ((JTabbedPane)object3).setTabPlacement(2);
        ((JTabbedPane)object3).addTab(GUI.tr((String)"Errors"), new JScrollPane(jTextPane2));
        ((JTabbedPane)object3).addTab(GUI.tr((String)"License"), icon, new JScrollPane(jTextPane));
        ((JTabbedPane)object3).addTab(GUI.tr((String)"Server Warnings"), component);
        return object3;
    }

    private Component create_warnings(boolean bl) {
        final DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        JList jList = new JList(defaultListModel);
        JButton jButton = new JButton(GUI.tr((String)"Update"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GUI.this.read_warnings(defaultListModel);
            }
        });
        if (bl) {
            this.read_warnings(defaultListModel);
        }
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add((Component)new JScrollPane(jList), "Center");
        jPanel.add((Component)jButton, "South");
        return jPanel;
    }

    private void file_quit() {
        if (this.kill_local && 0 != JOptionPane.showConfirmDialog((Component)((Object)this), GUI.tr((String)"ask.close.msg"), GUI.tr((String)"ask.close.title"), 0)) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.m_quit.setEnabled(false);
        this.m_app_prefs.putBoolean(PREF_STARTICONIFIED, this.m_starticonified.isSelected());
        this.m_app_prefs.putBoolean(PREF_START_LOCAL, this.m_start_local.isSelected());
        this.m_app_prefs.putInt(PREF_APP_X, this.frame().getX());
        this.m_app_prefs.putInt(PREF_APP_Y, this.frame().getY());
        this.m_app_prefs.putInt(PREF_APP_WIDTH, this.frame().getWidth());
        this.m_app_prefs.putInt(PREF_APP_HEIGHT, this.frame().getHeight());
        if (this._tray != null) {
            SystemTray.getSystemTray().remove(this._tray);
        }
        WP.savePreferences((WPApp)this, (Preferences)this.m_app_prefs);
        System.exit(0);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals(FILE_QUIT)) {
            this.file_quit();
        } else if (string.equals(COMMAND_TRAY)) {
            if (this.frame().getState() == 1) {
                this.frame().setVisible(true);
                this.frame().setState(0);
            } else {
                this.frame().setState(1);
            }
        }
    }

    private void read_warnings(DefaultListModel<String> defaultListModel) {
        if (!this.serverIsRunning()) {
            return;
        }
        WarningList warningList = new ServerConnection(logger).getWarnings();
        if (warningList == null) {
            return;
        }
        defaultListModel.clear();
        for (WarningListEntry warningListEntry : warningList.entries()) {
            defaultListModel.addElement(warningListEntry.toString());
        }
    }

    private void setServerIsRunning(boolean bl) {
        if (this.tried_to_start) {
            if (this._tray != null) {
                ServerConnection serverConnection = new ServerConnection(logger);
                if (serverConnection.isRunning()) {
                    this._tray.displayMessage(null, GUI.tr((String)"status.running"), TrayIcon.MessageType.INFO);
                } else {
                    this._tray.displayMessage(null, GUI.tr((String)"status.failed"), TrayIcon.MessageType.ERROR);
                }
            }
            this.tried_to_start = false;
        }
        if (this.server_status.getIcon() != null) {
            boolean bl2;
            boolean bl3 = bl2 = this.server_status.getIcon() == this.icon_good;
            if (bl2 == bl) {
                return;
            }
        }
        this.server_status.setText(bl ? GUI.tr((String)"status.connected") : GUI.tr((String)"status.no_connection"));
        this.server_status.setIcon(bl ? this.icon_good : this.icon_bad);
    }

    private boolean serverIsRunning() {
        if (this.server_status.getIcon() != null) {
            return this.server_status.getIcon() == this.icon_good;
        }
        return false;
    }

    private void update_connection_status() {
        ServerConnection serverConnection = new ServerConnection(logger);
        final boolean bl = serverConnection.isRunning();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GUI.this.setServerIsRunning(bl);
            }
        });
    }

    public void startLocalServer() {
        this.kill_local = true;
        WPServer.startLocalServer();
        if (this.m_start_local.isSelected()) {
            this.tried_to_start = true;
        }
    }
}

