/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server;

import de.wilke.wizepanel.core.WpDisplayUtils;
import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.core.groups.GroupManager;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.core.locator.WpSystemLocator;
import de.wilke.wizepanel.core.users.UserData;
import de.wilke.wizepanel.core.users.UserManager;
import de.wilke.wizepanel.eventmanager.WPEventManager;
import de.wilke.wizepanel.server.AdapterLauncher;
import de.wilke.wizepanel.server.AppWrapper;
import de.wilke.wizepanel.server.GUI;
import de.wilke.wizepanel.server.ILauncherLog;
import de.wilke.wizepanel.server.Warnings;
import de.wilke.wizepanel.server.WpFileMonitor;
import de.wilke.wizepanel.server.http.HTTPServer;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.services.WpServiceLauncher;
import de.wilke.wizepanel.sessions.Communicator;
import de.wilke.wizepanel.sessions.ResourceBuilder;
import de.wilke.wizepanel.templates.TemplateInfo;
import de.wilke.wizepanel.templates.TemplateManager;
import de.wilke.wizepanel.upi.engine.transactions.TransactionManager;
import java.io.File;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Services {
    private static final Logger logger = LogManager.getLogger(Services.class);
    private final List<AppWrapper> _apps = new LinkedList<AppWrapper>();
    private final WpFile tpl_dir = new WpFile(WpFile.WpFileType.TEMPLATE_FILE);
    private final TemplateManager tpl_manager = new TemplateManager(true);
    private final ILauncherLog log;
    public static Services app;
    private final WPEventManager _em = new WPEventManager();
    private boolean has_valid_license = false;
    public String started_at = "";

    public Services(ILauncherLog iLauncherLog) {
        this.log = iLauncherLog;
        app = this;
        String string = WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.USER_MANAGEMENT_FILE);
        if (!UserManager.getManager().fromFile(string)) {
            UserManager.getManager().add("user", "", UserData.UserRole.ADMIN, "superGroup", "superGroup", "0");
            UserManager.getManager().saveToFile(string);
        }
        String string2 = WpUpiServerStaticFactory.getServerLocator().getString(WpUpiServerLocator.WpUpiServerLocatorPropType.GROUP_MANAGEMENT_FILE);
        GroupManager.getManager().fromFile(string2);
        WpDisplayUtils.read_config_file_stream((String)WpFileUtils.readTextFile((File)new File(WpSystemLocator.getLocator().getDisplaysFile())));
        if (TransactionManager.getErrorMessage() != null) {
            logger.fatal(TransactionManager.getErrorMessage());
            System.exit(9);
        }
        this.check_license();
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                Services.this.check_license();
            }
        }, 60000L, 3600000L);
        Warnings.getInstance().reset(false);
        this.tpl_manager.setTemplates(this.tpl_dir.list("zip"));
        WpFileMonitor.getInstance().addChangeListener(new WpFileMonitor.WpFileChangeListener(){

            @Override
            public void fileChanged(String string) {
                Services.this.tpl_manager.setTemplates(Services.this.tpl_dir.list("zip"));
            }
        }, this.tpl_dir.getResolvedFileName(), 1000L);
        for (TemplateInfo templateInfo : this.tpl_manager.getTemplateInfoList()) {
            logger.info("Template[{}] {} [s:{},e:{}] ", (Object)templateInfo.getName(), (Object)templateInfo.display().getTypeDescription(), (Object)templateInfo.numberOfSources(), (Object)templateInfo.numberOfEvents());
        }
        this.create_apps();
    }

    public TemplateManager templateManager() {
        return this.tpl_manager;
    }

    public WPEventManager eventManager() {
        return this._em;
    }

    public List<AppWrapper> getApps() {
        return this._apps;
    }

    public void create_apps() {
        AppWrapper appWrapper = new AppWrapper(this, "HTTP", true, true){
            private final HTTPServer server;
            private boolean is_running;
            {
                this.server = new HTTPServer();
                this.is_running = false;
            }

            @Override
            public void stop() {
                this.server.stopEverything();
                this.is_running = false;
            }

            @Override
            public boolean run() {
                this.is_running = this.server.start();
                return this.is_running;
            }

            @Override
            public boolean isRunning() {
                return this.is_running;
            }
        };
        AppWrapper appWrapper2 = new AppWrapper(this, "EventManager", false){
            private boolean running;
            {
                this.running = false;
            }

            @Override
            public void stop() {
                if (this.isRunning()) {
                    Services.this._em.stop();
                    this.running = false;
                }
            }

            @Override
            public boolean run() {
                if (!this.isRunning()) {
                    this.running = true;
                }
                return true;
            }

            @Override
            public boolean isRunning() {
                return this.running;
            }
        };
        AppWrapper appWrapper3 = new AppWrapper(this, "ResourceBuilder", false){
            private ResourceBuilder _rb;

            @Override
            public void stop() {
                if (this.isRunning()) {
                    this._rb.stopEverything();
                    this._rb = null;
                }
            }

            @Override
            public boolean run() {
                if (!this.isRunning()) {
                    this._rb = ResourceBuilder.instance;
                }
                return true;
            }

            @Override
            public boolean isRunning() {
                return this._rb != null;
            }
        };
        AppWrapper appWrapper4 = new AppWrapper(this, "Communicator", false){
            private Communicator _c;

            @Override
            public void stop() {
                if (this.isRunning()) {
                    this._c.stopEverything();
                    this._c = null;
                }
            }

            @Override
            public boolean run() {
                if (!this.isRunning()) {
                    this._c = Communicator.instance;
                }
                return true;
            }

            @Override
            public boolean isRunning() {
                return this._c != null;
            }
        };
        AppWrapper appWrapper5 = null;
        appWrapper5 = new AppWrapper(this, "ServiceLauncher", false){
            private WpServiceLauncher _fs;

            @Override
            public void stop() {
                if (this.isRunning()) {
                    this._fs.stopEverything();
                    this._fs = null;
                }
            }

            @Override
            public boolean run() {
                if (!this.isRunning()) {
                    this._fs = new WpServiceLauncher();
                }
                return true;
            }

            @Override
            public boolean isRunning() {
                return this._fs != null;
            }
        };
        AdapterLauncher adapterLauncher = new AdapterLauncher(this, this._em);
        this._apps.add(appWrapper);
        this._apps.add(appWrapper2);
        this._apps.add(appWrapper3);
        this._apps.add(appWrapper4);
        if (appWrapper5 != null) {
            this._apps.add(appWrapper5);
        }
        this._apps.add(adapterLauncher);
    }

    public boolean start() {
        this.log.log(GUI.tr((String)"starting"));
        int n = 0;
        for (AppWrapper object : this._apps) {
            if (!object.doShow()) continue;
            ++n;
        }
        int n2 = 0;
        for (AppWrapper appWrapper : this._apps) {
            appWrapper.setErrorOnRun(false);
            if (appWrapper.doShow()) {
                this.log.log("  + " + ++n2 + "/" + n + "  " + appWrapper.getAppName() + (appWrapper.doRun() ? (appWrapper.isRunning() ? " (skipped, already running)" : "") : " (skipped)"));
                if (!appWrapper.doRun()) continue;
                if (appWrapper.run()) {
                    this.log.log(GUI.tr((String)"status.running"));
                    continue;
                }
                appWrapper.setErrorOnRun(true);
                this.log.log(GUI.tr((String)"failed"));
                if (!appWrapper.isEssential()) continue;
                this.log.log(GUI.tr((String)"essential.application.stop"));
                return false;
            }
            appWrapper.run();
        }
        this.started_at = WpTimeUtils.date2str((Date)new Date());
        return true;
    }

    public void stop(boolean bl) {
        if (bl) {
            this.log.log(GUI.tr((String)"stopping"));
        }
        int n = 0;
        for (AppWrapper appWrapper : this._apps) {
            if (!appWrapper.doShow()) continue;
            ++n;
        }
        int n2 = n;
        for (int i = this._apps.size() - 1; i >= 0; --i) {
            AppWrapper appWrapper = this._apps.get(i);
            if (appWrapper.doShow()) {
                if (bl) {
                    this.log.log("  + " + n2-- + "/" + n + "  " + appWrapper.getAppName());
                }
                appWrapper.stop();
                if (!bl) continue;
                this.log.log(GUI.tr((String)"status.stopped"));
                continue;
            }
            appWrapper.stop();
        }
    }

    private void check_license() {
        LicenseManager licenseManager = LicenseManager.getManager();
        String string = WpFileUtils.readTextFile((File)new WpFile("${env_var:WIZEPANEL_HOME}/VERSION.txt").getJavaFile());
        logger.info("VERSION: " + string);
        logger.info("LICENSE: " + licenseManager.toString());
        if (licenseManager.exists()) {
            logger.info("LICENSE: " + licenseManager.license().rawString());
        } else {
            logger.info("LICENSE: file not found");
        }
        if (!licenseManager.hasValidLicense() && this.has_valid_license) {
            logger.fatal("NOT VALID LICENSE FOUND. EXITING.");
            System.exit(1);
        }
        this.has_valid_license = licenseManager.hasValidLicense();
    }
}

