/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server;

import de.wilke.wizepanel.server.GUI;
import de.wilke.wizepanel.server.ServerConnection;
import de.wilke.wizepanel.server.winservice.ServiceLauncher;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WPServer {
    private static final Logger logger = LogManager.getLogger(WPServer.class);

    public static void main(String[] stringArray) {
        if (stringArray != null && stringArray.length == 1 && stringArray[0].equals("--nogui")) {
            WPServer.startLocalServer();
        } else {
            WPServer.start_gui();
        }
    }

    private static void start_gui() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl = new ServerConnection(logger).isRunning();
                JFrame jFrame = new JFrame();
                new GUI(jFrame, bl);
                if (jFrame.getState() != 1) {
                    jFrame.setVisible(true);
                }
            }
        });
    }

    public static void startLocalServer() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        ServiceLauncher.windowsService(new String[]{"stop"});
                    }
                });
                ServiceLauncher.windowsService(new String[]{"start"});
            }
        }).start();
    }
}

