/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server;

import de.wilke.wizepanel.core.displays.Display;
import de.wilke.wizepanel.core.license.LicenseManager;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.Warnings;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class WpDataManager {
    private static final WpDataManager m_instance = new WpDataManager();
    private final List<DispatcherItemType> m_dispatchers = new LinkedList<DispatcherItemType>();
    private final Map<Integer, WizePanelItemType> m_wizepanels = new HashMap<Integer, WizePanelItemType>();
    private final Map<Integer, DispatcherItemType> m_wizepanel_dispatchers = new HashMap<Integer, DispatcherItemType>();
    private final int maxwp = LicenseManager.getManager().getLicenseCount(LicenseManager.LicensePackages.WZP_SOFT_BA);

    private WpDataManager() {
        this.reload();
    }

    public static WpDataManager getManager() {
        return m_instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWizePanels(List<WizePanelItemType> list, DispatcherItemType dispatcherItemType) {
        Map<Integer, WizePanelItemType> map = this.m_wizepanels;
        synchronized (map) {
            Calendar calendar = Calendar.getInstance();
            for (WizePanelItemType wizePanelItemType : list) {
                DispatcherItemType dispatcherItemType2;
                DispatcherItemType dispatcherItemType3;
                if (this.static_routing()) {
                    dispatcherItemType3 = this.m_wizepanel_dispatchers.get(wizePanelItemType.getSerialNo());
                    if (dispatcherItemType3 == null || !dispatcherItemType3.getId().equals(dispatcherItemType.getId())) continue;
                    dispatcherItemType2 = this.m_wizepanels.get(wizePanelItemType.getSerialNo());
                    if (dispatcherItemType2 == null) {
                        if (!this.check_maxwp()) {
                            continue;
                        }
                    } else {
                        if (wizePanelItemType.getDisplay().getType() == Display.Type.TYPE_057) {
                            if (wizePanelItemType.params().getBatteryActive() == 0) {
                                wizePanelItemType.params().setBatteryActive(dispatcherItemType2.params().getBatteryActive());
                            }
                            if (wizePanelItemType.params().getBatteryPassive() == 0) {
                                wizePanelItemType.params().setBatteryPassive(dispatcherItemType2.params().getBatteryPassive());
                            }
                        }
                        wizePanelItemType.params().setName(dispatcherItemType2.params().getName());
                        wizePanelItemType.params().setRotation(dispatcherItemType2.params().getRotation());
                        wizePanelItemType.params().setScreenUpdateMethod(dispatcherItemType2.params().getScreenUpdateMethod());
                        wizePanelItemType.params().setRequiredWakeup(dispatcherItemType2.params().getRequiredWakeup());
                        wizePanelItemType.params().setComment(dispatcherItemType2.params().getComment());
                    }
                    wizePanelItemType.setLastUpdate(calendar.getTime());
                    this.m_wizepanels.put(wizePanelItemType.getSerialNo(), wizePanelItemType);
                    continue;
                }
                dispatcherItemType3 = this.m_wizepanels.get(wizePanelItemType.getSerialNo());
                dispatcherItemType2 = dispatcherItemType;
                int n = wizePanelItemType.params().getWakeup() * 60;
                if (dispatcherItemType3 == null) {
                    if (!this.check_maxwp()) {
                        continue;
                    }
                } else if (dispatcherItemType3.getLastUpdate() != null) {
                    Calendar calendar2 = Calendar.getInstance();
                    calendar2.setTime(dispatcherItemType3.getLastUpdate());
                    calendar2.add(13, -dispatcherItemType3.getLastSeen());
                    calendar2.add(13, wizePanelItemType.getLastSeen());
                    if (calendar2.after(calendar)) {
                        n = dispatcherItemType3.params().getWakeup();
                        DispatcherItemType dispatcherItemType4 = this.m_wizepanel_dispatchers.get(wizePanelItemType.getSerialNo());
                        if (dispatcherItemType4 != null) {
                            dispatcherItemType2 = dispatcherItemType4;
                        }
                    }
                }
                wizePanelItemType.setLastUpdate(calendar.getTime());
                wizePanelItemType.params().setWakeup(n);
                if (dispatcherItemType3 != null) {
                    if (wizePanelItemType.params().getBatteryActive() == 0) {
                        wizePanelItemType.params().setBatteryActive(dispatcherItemType3.params().getBatteryActive());
                    }
                    if (wizePanelItemType.params().getBatteryPassive() == 0) {
                        wizePanelItemType.params().setBatteryPassive(dispatcherItemType3.params().getBatteryPassive());
                    }
                }
                this.m_wizepanels.put(wizePanelItemType.getSerialNo(), wizePanelItemType);
                if (dispatcherItemType2 == null) continue;
                this.m_wizepanel_dispatchers.put(wizePanelItemType.getSerialNo(), dispatcherItemType2);
            }
        }
    }

    private boolean check_maxwp() {
        if (this.maxwp > 0 && this.m_wizepanels.size() >= this.maxwp) {
            if (this.m_wizepanels.size() == this.maxwp + 1) {
                Warnings.getInstance().addWarning("WpDataManager", MessageFormat.format("Do not accept targets anymore. Maximum reached: {0}.", this.maxwp));
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatcherItemType getDispatcherById(String string) {
        List<DispatcherItemType> list = this.m_dispatchers;
        synchronized (list) {
            for (DispatcherItemType dispatcherItemType : this.m_dispatchers) {
                if (!dispatcherItemType.getId().equals(string)) continue;
                return dispatcherItemType;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DispatcherItemType getDispatcherByIpAndPort(String string, int n) {
        List<DispatcherItemType> list = this.m_dispatchers;
        synchronized (list) {
            for (DispatcherItemType dispatcherItemType : this.m_dispatchers) {
                if (!dispatcherItemType.params().getIp().equals(string) || dispatcherItemType.params().getPort() != n) continue;
                return dispatcherItemType;
            }
            return null;
        }
    }

    public DispatcherItemType getDispatcherByWizepanelId(int n) {
        return this.m_wizepanel_dispatchers.get(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<WizePanelItemType> getWizepanelsByDispatcher(String string) {
        Map<Integer, DispatcherItemType> map = this.m_wizepanel_dispatchers;
        synchronized (map) {
            LinkedList<WizePanelItemType> linkedList = new LinkedList<WizePanelItemType>();
            for (Integer n : this.m_wizepanel_dispatchers.keySet()) {
                DispatcherItemType dispatcherItemType = this.m_wizepanel_dispatchers.get(n);
                if (!dispatcherItemType.getId().equals(string)) continue;
                linkedList.add(this.m_wizepanels.get(n));
            }
            return linkedList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DispatcherItemType> getDispatchers() {
        List<DispatcherItemType> list = this.m_dispatchers;
        synchronized (list) {
            return this.m_dispatchers;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDispatcher(DispatcherItemType dispatcherItemType) {
        List<DispatcherItemType> list = this.m_dispatchers;
        synchronized (list) {
            DispatcherItemType dispatcherItemType2 = this.getDispatcherById(dispatcherItemType.getId());
            if (dispatcherItemType2 == null) {
                if (!this.static_routing()) {
                    this.m_dispatchers.add(dispatcherItemType);
                }
            } else {
                dispatcherItemType.params().setMaxWP(dispatcherItemType2.params().getMaxWP());
                dispatcherItemType.params().setVersion(dispatcherItemType2.params().getVersion());
                dispatcherItemType.params().setStatus(dispatcherItemType2.params().getStatus());
                dispatcherItemType.params().setTimeZone(dispatcherItemType2.params().getTimeZone());
                dispatcherItemType.params().setDHCP(dispatcherItemType2.params().isDHCP());
                if (WpUpiServerStaticFactory.getRoutingHandler().getRouterById(dispatcherItemType.getId()) != null) {
                    dispatcherItemType.params().setName(dispatcherItemType2.params().getName());
                }
                dispatcherItemType2.copyFrom(dispatcherItemType, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WizePanelItemType getWizepanelById(int n) {
        Map<Integer, WizePanelItemType> map = this.m_wizepanels;
        synchronized (map) {
            return this.m_wizepanels.get(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<WizePanelItemType> getWizepanels() {
        Map<Integer, WizePanelItemType> map = this.m_wizepanels;
        synchronized (map) {
            return this.m_wizepanels.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        List<DispatcherItemType> list = this.m_dispatchers;
        synchronized (list) {
            Map<Integer, WizePanelItemType> map = this.m_wizepanels;
            synchronized (map) {
                Object object = "";
                object = (String)object + "#d:" + this.m_dispatchers.size() + "\n";
                for (DispatcherItemType dispatcherItemType : this.m_dispatchers) {
                    object = (String)object + dispatcherItemType.getId() + " | " + dispatcherItemType.params() + "\n";
                }
                object = (String)object + "#w:" + this.m_wizepanels.size() + "\n";
                for (WizePanelItemType wizePanelItemType : this.m_wizepanels.values()) {
                    object = (String)object + wizePanelItemType.getSerialNo() + " | " + wizePanelItemType.params() + " using dispatcher: " + this.m_wizepanel_dispatchers.get(wizePanelItemType.getSerialNo()).params().getIp() + "\n";
                }
                return object;
            }
        }
    }

    public JSONObject toJSON() throws JSONException {
        HashMap hashMap = new HashMap();
        JSONObject jSONObject = this.m_wizepanel_dispatchers.keySet().iterator();
        while (jSONObject.hasNext()) {
            String string;
            int n = jSONObject.next();
            Object object = this.m_wizepanel_dispatchers.get(n);
            String string2 = string = object == null ? "" : object.getId();
            if (!hashMap.containsKey(string)) {
                hashMap.put(string, new LinkedList());
            }
            ((List)hashMap.get(string)).add(n);
        }
        jSONObject = new JSONObject();
        for (Object object : hashMap.keySet()) {
            jSONObject.put((String)object, (Collection)hashMap.get(object));
        }
        return jSONObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        List<DispatcherItemType> list = this.m_dispatchers;
        synchronized (list) {
            Map<Integer, WizePanelItemType> map = this.m_wizepanels;
            synchronized (map) {
                this.m_dispatchers.clear();
                this.m_wizepanels.clear();
                this.m_wizepanel_dispatchers.clear();
                UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
                for (UpiRouterItem upiRouterItem : upiRoutingHandler.getRouters()) {
                    DispatcherItemType dispatcherItemType = new DispatcherItemType(upiRouterItem.getId());
                    dispatcherItemType.setId(upiRouterItem.getId());
                    dispatcherItemType.setParams(upiRouterItem.getParams());
                    this.m_dispatchers.add(dispatcherItemType);
                    for (UpiTargetItem upiTargetItem : upiRouterItem.getTargets()) {
                        if (!this.check_maxwp()) {
                            return;
                        }
                        upiTargetItem.getParams().setLastSeen(-1);
                        WizePanelItemType wizePanelItemType = new WizePanelItemType();
                        wizePanelItemType.setSerialNo(Integer.parseInt(upiTargetItem.getId()));
                        wizePanelItemType.params().fullCopyFrom(upiTargetItem.getParams());
                        wizePanelItemType.setType(upiTargetItem.getParams().getType());
                        this.m_wizepanels.put(wizePanelItemType.getSerialNo(), wizePanelItemType);
                        this.m_wizepanel_dispatchers.put(wizePanelItemType.getSerialNo(), dispatcherItemType);
                    }
                }
            }
        }
    }

    private boolean static_routing() {
        return WpUpiServerStaticFactory.getServerLocator().getBoolean(WpUpiServerLocator.WpUpiServerLocatorPropType.UPI_WP_SERVER_STATIC_ROUTING);
    }
}

