/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.server.http.adaptertests;

import de.wilke.wizepanel.core.WpUtils;
import de.wilke.wizepanel.core.adapters.types.CsvAdapterFormat;
import de.wilke.wizepanel.eventmanager.adapters.csv.CsvUtils;
import de.wilke.wizepanel.server.http.adaptertests.CsvFile;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class CsvTest {
    CsvTest() {
    }

    public String action(JSONObject jSONObject) throws Exception {
        String string = jSONObject.getString("file");
        Charset charset = Charset.forName(jSONObject.getString("encoding"));
        CsvAdapterFormat csvAdapterFormat = new CsvAdapterFormat(jSONObject.getJSONObject("format"));
        JSONArray jSONArray = jSONObject.getJSONArray("rooms");
        String string2 = CsvUtils.get_file(string, charset, csvAdapterFormat.getCsvEnclosure());
        System.err.println(string2);
        if (string2 == null) {
            throw new Exception("Could not read: " + string);
        }
        CsvFile csvFile = new CsvFile(string2, csvAdapterFormat, 100);
        LinkedList<String> linkedList = new LinkedList<String>();
        LinkedList<String> linkedList2 = new LinkedList<String>();
        this.validate_format(csvFile, jSONArray, linkedList, linkedList2);
        JSONArray jSONArray2 = new JSONArray();
        for (String[] stringArray : csvFile.getLines()) {
            JSONArray jSONArray3 = new JSONArray();
            for (int i = 0; i < stringArray.length; ++i) {
                jSONArray3.put((Object)stringArray[i]);
            }
            jSONArray2.put((Object)jSONArray3);
        }
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("error", (Object)WpUtils.implode((String)",  ", linkedList));
        jSONObject2.put("warning", (Object)WpUtils.implode((String)",  ", linkedList2));
        jSONObject2.put("targets", (Object)new JSONArray(csvFile.getTargets()));
        jSONObject2.put("rows", (Object)jSONArray2);
        return jSONObject2.toString();
    }

    private void validate_format(CsvFile csvFile, JSONArray jSONArray, List<String> list, List<String> list2) throws JSONException {
        CsvAdapterFormat csvAdapterFormat = csvFile.getFormat();
        LinkedList<String> linkedList = new LinkedList<String>();
        if (csvAdapterFormat.getTargetCol() == 0) {
            linkedList.add("Target");
        }
        if (csvAdapterFormat.getStartTimeDateCol() == 0) {
            linkedList.add("Start");
        }
        if (csvAdapterFormat.getEndTimeDateCol() == 0) {
            linkedList.add("End");
        }
        if (csvAdapterFormat.getTemplateCol() == 0) {
            // empty if block
        }
        if (csvAdapterFormat.getAlarmCol() == 0) {
            // empty if block
        }
        if (linkedList.size() > 0) {
            list.add(MessageFormat.format("Select following column(s): {0}", WpUtils.implode((String)", ", linkedList)));
            return;
        }
        if (csvAdapterFormat.getTargetCol() == csvAdapterFormat.getStartTimeDateCol() || csvAdapterFormat.getTargetCol() == csvAdapterFormat.getEndTimeDateCol() || csvAdapterFormat.getTargetCol() == csvAdapterFormat.getTemplateCol() || csvAdapterFormat.getStartTimeDateCol() == csvAdapterFormat.getEndTimeDateCol() || csvAdapterFormat.getStartTimeDateCol() == csvAdapterFormat.getTemplateCol() || csvAdapterFormat.getEndTimeDateCol() == csvAdapterFormat.getTemplateCol()) {
            list.add("Same column for different types.");
            return;
        }
        if (csvFile.getLines().size() == 0) {
            list.add("Could not parse file. Try other CSV options.");
            return;
        }
        String string = csvFile.getFirstInvalidTargetName(jSONArray);
        if (string != null) {
            list2.add(MessageFormat.format("Target not in the list: {0}", string));
            return;
        }
        String string2 = csvFile.getFirstInvalidDate();
        if (string2 != null) {
            list2.add(MessageFormat.format("Invalid date/time: {0}", string2));
            return;
        }
        String string3 = csvFile.getFirstInvalidTemplateName();
        if (string3 != null) {
            list2.add(MessageFormat.format("Template not found: {0}", string3));
            return;
        }
    }
}

