/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.services;

import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.AWpRequest;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import de.wilke.wizepanel.upi.types.TargetParameters;
import org.json.JSONException;

class BackupRoutingTask
extends AWpRequest {
    private int last_hashcode = 0;

    public BackupRoutingTask(int n) {
        super("WP-S-RoutingTable", n);
    }

    @Override
    public void requestBody() {
        WpDataManager wpDataManager = WpDataManager.getManager();
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        for (UpiRouterItem upiRouterItem : upiRoutingHandler.getRouters()) {
            DispatcherItemType dispatcherItemType = wpDataManager.getDispatcherById(upiRouterItem.getId());
            if (dispatcherItemType != null) {
                upiRouterItem.getParams().importFrom(dispatcherItemType.params());
            }
            for (UpiTargetItem upiTargetItem : upiRouterItem.getTargets()) {
                TargetParameters targetParameters;
                int n;
                int n2;
                try {
                    n2 = Integer.parseInt(upiTargetItem.getId());
                }
                catch (NumberFormatException numberFormatException) {
                    continue;
                }
                WizePanelItemType wizePanelItemType = wpDataManager.getWizepanelById(n2);
                if (wizePanelItemType == null || (n = (targetParameters = wizePanelItemType.params()).getLastSeen()) == -1) continue;
                upiTargetItem.getParams().copyFrom(targetParameters);
            }
        }
        try {
            int n = upiRoutingHandler.toJson().toString().hashCode();
            if (this.last_hashcode != n) {
                upiRoutingHandler.saveRoutingTable();
                this.last_hashcode = n;
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
    }
}

