/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.sessions;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.jms.session.WpSession;
import de.wilke.wizepanel.jms.session.WpSessionCommand;
import de.wilke.wizepanel.jms.session.WpSessionResponse;
import de.wilke.wizepanel.server.Warnings;
import de.wilke.wizepanel.server.http.WpUpiServerLocator;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.sessions.ImageNotChanged;
import de.wilke.wizepanel.upi.UpiResDescrNaming;
import de.wilke.wizepanel.upi.UpiUtils;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import de.wilke.wizepanel.upi.engine.proxy.WpUpiServerDataProxy;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class Communicator {
    private static final Logger m_logger = LogManager.getLogger(Communicator.class);
    public static final Communicator instance = new Communicator();
    private final BlockingQueue<WpSession> fifo = new LinkedBlockingQueue<WpSession>();
    private final Map<Integer, Integer> m_last_image = new HashMap<Integer, Integer>();
    private List<WpSession> finished_sessions = Collections.synchronizedList(new LinkedList());
    private static final int START_FINISHED_SESSIONS_CLEANUP_AT_ENTRIES = 110;
    private static final int MAX_NUMBER_OF_FINISHED_SESSIONS = 100;
    private long finished_sessions_timestamp = 0L;
    private final long old_session_secs = 86400L;
    private volatile boolean do_run = true;
    private final WpSession fake_session = new WpSession();

    private Communicator() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (Communicator.this.do_run) {
                    try {
                        WpSession wpSession = Communicator.this.fifo.take();
                        if (wpSession == Communicator.this.fake_session) {
                            Communicator.this.cleanup_old();
                            continue;
                        }
                        WpSessionResponse wpSessionResponse = new WpSessionResponse();
                        wpSessionResponse.setSource(WpSessionResponse.RESPONSE_SOURCE.COMMAND);
                        wpSession.setResponse(wpSessionResponse);
                        try {
                            wpSessionResponse.setResponseData(Communicator.this.action(wpSession));
                        }
                        catch (ImageNotChanged imageNotChanged) {
                            Warnings.getInstance().addTargetInfo(wpSession.getEvent().getTargetStationName(), "Generated image not changed");
                            continue;
                        }
                        catch (Exception exception) {
                            wpSessionResponse.setErrorName(exception.getMessage());
                            m_logger.error(wpSession.toString(4), (Throwable)exception);
                        }
                        Communicator.this.addToFinished(wpSession);
                    }
                    catch (Throwable throwable) {
                        m_logger.fatal("RAGNAROK", throwable);
                    }
                }
            }
        });
        thread.setName("WP-EM-Communicator");
        thread.start();
    }

    public String action(WpSession wpSession) throws Exception {
        Object object;
        Object object2;
        if (wpSession.getCommand() == null) {
            throw new Exception("No session command found");
        }
        WpSessionCommand wpSessionCommand = new WpSessionCommand(wpSession.getCommand());
        Map map = wpSessionCommand.getParams();
        String string = (String)map.get(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_IMAGE.toString());
        if (string != null) {
            object2 = new File(string);
            if (((File)object2).exists()) {
                map.put(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_IMAGE.toString(), UpiUtils.file2base64((String)string));
                map.put(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_DATA_TYPE.toString(), UpiResDescrNaming.UpiResDescrType.TYPE_BASE64.toString());
            } else {
                object = new WpFile(string, WpFile.WpFileType.FINAL_IMG_RESOURCE_FILE);
                if (object.exists()) {
                    map.put(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_IMAGE.toString(), UpiUtils.file2base64((String)object.getResolvedFileName()));
                    map.put(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_DATA_TYPE.toString(), UpiResDescrNaming.UpiResDescrType.TYPE_BASE64.toString());
                }
            }
        }
        if ((object2 = (String)map.get(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_DATA.toString())) != null && ((File)(object = new File((String)object2))).exists()) {
            map.put(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_DATA.toString(), UpiUtils.file2base64((String)object2));
            map.put(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_DATA_TYPE.toString(), UpiResDescrNaming.UpiResDescrType.TYPE_BASE64.toString());
        }
        object = new JSONObject();
        for (Map.Entry entry : map.entrySet()) {
            try {
                object.put((String)entry.getKey(), entry.getValue());
            }
            catch (JSONException jSONException) {}
        }
        switch (wpSessionCommand.getAction()) {
            case "wp_image": {
                int n = Integer.parseInt(wpSessionCommand.getWizePanelID());
                if (!wpSession.getAttributes().isStudio()) {
                    this.check_image_changed(n, object.toString().hashCode());
                }
                return new WpUpiServerDataProxy().setWizepanelImage(n, object.toString());
            }
            case "wp_latency": {
                int n = Integer.parseInt(wpSessionCommand.getWizePanelID());
                return new WpUpiServerDataProxy().setWizepanelWakeupTime(n, object.toString());
            }
            case "wp_screen_update_method": {
                int n = Integer.parseInt(wpSessionCommand.getWizePanelID());
                return new WpUpiServerDataProxy().setWizepanelScreenUpdateMethod(n, object.toString());
            }
            case "dp_address": {
                return new WpUpiServerDataProxy().setDispatcherAddress(wpSessionCommand.getWizePanelID(), object.toString());
            }
            case "dp_firmware": {
                return new WpUpiServerDataProxy().setDispatcherFirmware(wpSessionCommand.getWizePanelID(), object.toString());
            }
            case "dp_restart": {
                return DispatcherPool.getPool().sendReset(wpSessionCommand.getWizePanelID());
            }
        }
        throw new Exception("Unsupported command");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void check_image_changed(int n, int n2) throws ImageNotChanged {
        if (WpUpiServerStaticFactory.getServerLocator().getBoolean(WpUpiServerLocator.WpUpiServerLocatorPropType.IGNORE_DUPLICATE_IMAGES)) {
            Map<Integer, Integer> map = this.m_last_image;
            synchronized (map) {
                Integer n3 = this.m_last_image.get(n);
                if (n3 != null && n3 == n2) {
                    throw new ImageNotChanged();
                }
                this.m_last_image.put(n, n2);
            }
        }
    }

    public void add(WpSession wpSession) {
        m_logger.debug("Add: {}", (Object)wpSession.getAttributes().getID());
        this.fifo.add(wpSession);
    }

    public void stopEverything() {
        this.do_run = false;
        this.fifo.add(this.fake_session);
    }

    public void wakeup() {
        this.fifo.add(this.fake_session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToFinished(WpSession wpSession) {
        List<WpSession> list = this.finished_sessions;
        synchronized (list) {
            this.finished_sessions.add(wpSession);
            this.finished_sessions_timestamp = System.currentTimeMillis();
            if (this.finished_sessions.size() > 110) {
                int n = this.finished_sessions.size();
                Iterator<WpSession> iterator = this.finished_sessions.iterator();
                while (iterator.hasNext() && this.finished_sessions.size() >= 100) {
                    wpSession = iterator.next();
                    m_logger.debug("Removing: {}", (Object)wpSession.getAttributes().getID());
                    iterator.remove();
                }
                m_logger.debug("Cleanup: {} > {}", (Object)n, (Object)110);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanup_old() {
        List<WpSession> list = this.finished_sessions;
        synchronized (list) {
            long l = System.currentTimeMillis() - 86400000L;
            Iterator<WpSession> iterator = this.finished_sessions.iterator();
            while (iterator.hasNext()) {
                WpSession wpSession = iterator.next();
                if (wpSession.getResponse().getTimestamp() >= l) continue;
                m_logger.debug("Removing old: {}", (Object)wpSession.getAttributes().getID());
                iterator.remove();
                this.finished_sessions_timestamp = System.currentTimeMillis();
            }
        }
    }

    public List<WpSession> getFinishedSessions() {
        return this.finished_sessions;
    }

    public long getLastUpdateTimestamp() {
        return this.finished_sessions_timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearHistory(UpiTargetItem upiTargetItem) {
        Map<Integer, Integer> map = this.m_last_image;
        synchronized (map) {
            if (upiTargetItem == null) {
                this.m_last_image.clear();
            } else {
                this.m_last_image.remove(Integer.parseInt(upiTargetItem.getId()));
            }
        }
    }
}

