/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.sessions;

import de.wilke.wizepanel.core.WpFile;
import de.wilke.wizepanel.core.WpFileUtils;
import de.wilke.wizepanel.jms.session.WpSession;
import de.wilke.wizepanel.jms.session.WpSessionCommand;
import de.wilke.wizepanel.jms.session.WpSessionEvent;
import de.wilke.wizepanel.jms.session.WpSessionResource;
import de.wilke.wizepanel.jms.system.WpTemplateFile;
import de.wilke.wizepanel.server.http.WpUpiServerStaticFactory;
import de.wilke.wizepanel.sessions.Communicator;
import de.wilke.wizepanel.upi.UpiResDescrNaming;
import de.wilke.wizepanel.upi.routing.UpiRouterItem;
import de.wilke.wizepanel.upi.routing.UpiRoutingHandler;
import de.wilke.wizepanel.upi.routing.UpiTargetItem;
import java.io.File;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceBuilder {
    private static final Logger m_logger = LogManager.getLogger(ResourceBuilder.class);
    public static final ResourceBuilder instance = new ResourceBuilder();
    private final BlockingQueue<WpSession> fifo = new LinkedBlockingQueue<WpSession>();
    private volatile boolean do_run = true;
    private final WpSession fake_session = new WpSession();

    private ResourceBuilder() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (ResourceBuilder.this.do_run) {
                    try {
                        WpSession wpSession = ResourceBuilder.this.fifo.take();
                        if (wpSession == ResourceBuilder.this.fake_session) continue;
                        try {
                            ResourceBuilder.this.action(wpSession);
                            Communicator.instance.add(wpSession);
                        }
                        catch (Exception exception) {
                            m_logger.error(wpSession.toString(4), (Throwable)exception);
                        }
                    }
                    catch (Throwable throwable) {
                        m_logger.fatal("RAGNAROK", throwable);
                    }
                }
            }
        });
        thread.setName("WP-EM-ResourceBuilder");
        thread.start();
    }

    public void add(WpSession wpSession) {
        m_logger.debug("New {}", (Object)wpSession.toString());
        this.fifo.add(wpSession);
    }

    public void stopEverything() {
        m_logger.info("Leaving");
        this.do_run = false;
        this.fifo.add(this.fake_session);
    }

    private void action(WpSession wpSession) throws Exception {
        if (wpSession.getEvent() == null) {
            throw new Exception("SessionEvent==null");
        }
        WpSessionEvent wpSessionEvent = new WpSessionEvent(wpSession.getEvent());
        UpiRoutingHandler upiRoutingHandler = WpUpiServerStaticFactory.getRoutingHandler();
        UpiTargetItem upiTargetItem = upiRoutingHandler.getTargetByName(wpSessionEvent.getTargetStationName());
        if (upiTargetItem == null) {
            throw new Exception("Target == null");
        }
        WpSessionResource wpSessionResource = wpSession.getResource();
        if (wpSessionResource == null) {
            throw new Exception("Resource is null");
        }
        UpiRouterItem upiRouterItem = upiRoutingHandler.getRouterByTargetId(upiTargetItem.getId());
        String string = upiRouterItem == null ? "" : upiRouterItem.getParams().getTimeZone();
        WpFile wpFile = new WpFile("wpi_.png", WpFile.WpFileType.FINAL_IMG_RESOURCE_FILE);
        File file = WpFileUtils.getUniqueFile((String)wpFile.getResolvedFileName());
        WpTemplateFile wpTemplateFile = wpSessionResource.getImageInFile(file.getAbsolutePath(), string);
        if (wpTemplateFile == null) {
            throw new Exception("getImageInFile==false [" + file.getAbsolutePath() + "]");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_IMAGE.toString(), file.getName());
        hashMap.put(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_DATA_TYPE.toString(), UpiResDescrNaming.UpiResDescrType.TYPE_BASE64.toString());
        hashMap.put(UpiResDescrNaming.UpiResDescrStandardParam.RESPAR_TARGET_CONTENTS_COLOR_DEPTH.toString(), String.valueOf(wpTemplateFile.template.getDisplay().getColorDepth()));
        WpSessionCommand wpSessionCommand = new WpSessionCommand("wp_image", upiTargetItem.getId(), hashMap);
        wpSession.setCommand(wpSessionCommand);
        m_logger.debug("[OK]");
    }
}

