/*
 * Decompiled with CFR 0.152.
 */
package de.wilke.wizepanel.upi.engine.dispatchers;

import de.wilke.wizepanel.core.WizePanelExceptions;
import de.wilke.wizepanel.core.WpTimeUtils;
import de.wilke.wizepanel.prot.comm.ACommCommand;
import de.wilke.wizepanel.prot.comm.CommCmCancelTransactions;
import de.wilke.wizepanel.prot.comm.CommCmDispGetErrors;
import de.wilke.wizepanel.prot.comm.CommCmDispGetSettings;
import de.wilke.wizepanel.prot.comm.CommCmDispGetStats;
import de.wilke.wizepanel.prot.comm.CommCmDispGetTransactions;
import de.wilke.wizepanel.prot.comm.CommCmDispGetWizepanelsAll;
import de.wilke.wizepanel.prot.comm.CommCmDispRestart;
import de.wilke.wizepanel.prot.comm.CommCmDispSubscribeList;
import de.wilke.wizepanel.prot.comm.CommCmWizePanelSendData;
import de.wilke.wizepanel.prot.comm.types.ErrorEntry;
import de.wilke.wizepanel.prot.comm.types.SendDataHeader;
import de.wilke.wizepanel.prot.comm.types.StatsEntry;
import de.wilke.wizepanel.prot.comm.types.TransactionStatus;
import de.wilke.wizepanel.prot.data.DispatcherItemType;
import de.wilke.wizepanel.prot.data.WizePanelDataList;
import de.wilke.wizepanel.prot.data.WizePanelItemType;
import de.wilke.wizepanel.server.Warnings;
import de.wilke.wizepanel.server.WpDataManager;
import de.wilke.wizepanel.upi.engine.dispatchers.DataCommand;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherActions;
import de.wilke.wizepanel.upi.engine.dispatchers.DispatcherPool;
import de.wilke.wizepanel.upi.engine.transactions.Entry;
import de.wilke.wizepanel.upi.engine.transactions.TransactionManager;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;

public class DispatcherActionsV2
extends DispatcherActions {
    private static final int MIN_FREE_DATA_MEMORY = 102400;
    private StatsEntry stats = new StatsEntry();

    public DispatcherActionsV2(DispatcherItemType dispatcherItemType, boolean bl, Logger logger) {
        super(dispatcherItemType, bl, logger);
    }

    @Override
    public int actionProtocolVersion() {
        return 2;
    }

    @Override
    protected DispatcherActions.Reply exec_special(Entry entry) throws WizePanelExceptions {
        DispatcherActions.Reply reply = new DispatcherActions.Reply();
        switch (entry.getCommand()) {
            case WP_DATA: {
                reply.trans_id = this.send_data(entry.getWpid(), entry.getCommandData());
                reply.status = Entry.STATUS.ON_ROUTER;
                break;
            }
            case WP_SCREEN_UPDATE_METHOD: {
                reply.trans_id = this.send_screen_update_method(entry.getWpid(), entry.getCommandData());
                reply.status = Entry.STATUS.ON_ROUTER;
                break;
            }
            default: {
                return super.exec_special(entry);
            }
        }
        return reply;
    }

    @Override
    public Entry get_next_job() {
        List<Entry> list = TransactionManager.getManager().getAllJobs(this.dispatcher.getId(), Entry.STATUS.ON_SERVER);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    @Override
    protected boolean exec_cancel(Entry entry) throws WizePanelExceptions {
        CommCmCancelTransactions commCmCancelTransactions = new CommCmCancelTransactions();
        commCmCancelTransactions.initializeCommandParams();
        commCmCancelTransactions.addTransaction(entry.getDispatcherTransactionId());
        this.send_to_dispatcher((ACommCommand)commCmCancelTransactions);
        return commCmCancelTransactions.getTransactionsCancelled() == 1;
    }

    @Override
    protected void send_get_all_wps() throws WizePanelExceptions {
        CommCmDispGetWizepanelsAll commCmDispGetWizepanelsAll = new CommCmDispGetWizepanelsAll();
        commCmDispGetWizepanelsAll.initializeCommandParams();
        commCmDispGetWizepanelsAll.setExtended(true);
        this.send_to_dispatcher((ACommCommand)commCmDispGetWizepanelsAll);
        WizePanelDataList wizePanelDataList = new WizePanelDataList(commCmDispGetWizepanelsAll.getWizePanelList());
        Date date = new Date();
        for (WizePanelItemType wizePanelItemType : wizePanelDataList.getWpDataList()) {
            wizePanelItemType.setLastUpdate(date);
        }
        this.process_getwpparams(this.dispatcher, wizePanelDataList.getWpDataList());
        DispatcherPool.getPool().updateDispatcher(this.dispatcher, wizePanelDataList, false, false);
    }

    @Override
    public void update_stats() throws WizePanelExceptions {
        CommCmDispGetStats commCmDispGetStats = new CommCmDispGetStats();
        commCmDispGetStats.initializeCommandParams();
        this.send_to_dispatcher((ACommCommand)commCmDispGetStats);
        if (this.stats.uptime_secs != 0L && commCmDispGetStats.getStats().uptime_secs < this.stats.uptime_secs) {
            this.logger.warn("DispatcherReset4: last_uptime:" + this.stats.uptime_secs + " now: " + commCmDispGetStats.getStats().uptime_secs);
            try {
                this.exec_get_errors();
            }
            catch (WizePanelExceptions wizePanelExceptions) {
                // empty catch block
            }
        }
        this.stats = commCmDispGetStats.getStats();
        this.dispatcher.params().setMaxWP(this.stats.max_number_targets);
        DispatcherItemType dispatcherItemType = WpDataManager.getManager().getDispatcherById(this.dispatcher.getId());
        if (dispatcherItemType != null) {
            dispatcherItemType.params().setMaxWP(this.stats.max_number_targets);
        }
        this.data_memory = this.stats.max_data_memory - this.stats.free_data_memory;
        this.logger.info("STATS: " + commCmDispGetStats.getStats().toCondensedString());
    }

    @Override
    public void read_settings() throws WizePanelExceptions {
        CommCmDispGetSettings commCmDispGetSettings = new CommCmDispGetSettings();
        commCmDispGetSettings.initializeCommandParams();
        this.send_to_dispatcher((ACommCommand)commCmDispGetSettings);
        this.dispatcher.params().setDHCP(commCmDispGetSettings.getSettings().DhcpIsOn);
        DispatcherItemType dispatcherItemType = WpDataManager.getManager().getDispatcherById(this.dispatcher.getId());
        if (dispatcherItemType != null) {
            dispatcherItemType.params().setDHCP(commCmDispGetSettings.getSettings().DhcpIsOn);
        }
        this.logger.info("SETTINGS: " + commCmDispGetSettings.getSettings().toCondensedString());
    }

    private long send_data(int n, String string) throws WizePanelExceptions {
        DataCommand dataCommand = new DataCommand(string);
        CommCmWizePanelSendData commCmWizePanelSendData = new CommCmWizePanelSendData(n, dataCommand.bytes());
        commCmWizePanelSendData.header().setType(dataCommand.type());
        if (commCmWizePanelSendData.header().type() == SendDataHeader.Type.IMAGE) {
            commCmWizePanelSendData.header().setCompression(SendDataHeader.Compression.PNG.value);
        }
        this.send_to_dispatcher((ACommCommand)commCmWizePanelSendData);
        return commCmWizePanelSendData.getResponseHeader().getTransactionId();
    }

    private long send_screen_update_method(int n, String string) throws WizePanelExceptions {
        CommCmWizePanelSendData commCmWizePanelSendData = new CommCmWizePanelSendData();
        commCmWizePanelSendData.setWizePanelID(n);
        commCmWizePanelSendData.header().setType(SendDataHeader.Type.DISPLAY_UPDATE.value);
        commCmWizePanelSendData.header().setCompression(SendDataHeader.Compression.NONE.value);
        commCmWizePanelSendData.header().setPayload(string);
        this.send_to_dispatcher((ACommCommand)commCmWizePanelSendData);
        return commCmWizePanelSendData.getResponseHeader().getTransactionId();
    }

    @Override
    public boolean check_is_ready_to_run() {
        try {
            this.update_stats();
        }
        catch (WizePanelExceptions wizePanelExceptions) {
            this.logger.debug((Object)wizePanelExceptions);
            return false;
        }
        if (this.stats.free_data_memory == 0L || this.stats.free_number_commands == 0 || this.stats.free_number_target_data == 0 || this.stats.free_number_targets == 0) {
            this.logger.debug("WAITING: zero");
            return false;
        }
        if (this.stats.free_data_memory <= 102400L) {
            this.logger.debug("WAITING: memory");
            return false;
        }
        return true;
    }

    @Override
    protected void update_job_states() throws WizePanelExceptions {
        List<Entry> list = TransactionManager.getManager().getAllJobs(this.dispatcher.getId(), Entry.STATUS.ON_ROUTER);
        if (list.size() == 0) {
            return;
        }
        this.logger.info("Updating jobs: #" + list.size());
        CommCmDispGetTransactions commCmDispGetTransactions = new CommCmDispGetTransactions();
        commCmDispGetTransactions.initializeCommandParams();
        this.send_to_dispatcher((ACommCommand)commCmDispGetTransactions);
        Map map = commCmDispGetTransactions.getTransactions();
        this.calc_data_memory = 0L;
        for (Entry object : list) {
            TransactionStatus l = (TransactionStatus)map.get(object.getDispatcherTransactionId());
            if (l == null) {
                this.logger.warn("DispatcherReset5(wp: " + object.getWpid() + " transid: " + object.getId() + ")");
                TransactionManager.getManager().setJobStatus(object, Entry.STATUS.ON_SERVER);
                continue;
            }
            if (l.errorCode() == 36 || l.errorCode() == 30) {
                this.kill_all_dispatcher_jobs();
                return;
            }
            if (l.isFinished()) {
                this.logger.info("Updating job-status: for " + object.getId() + " | " + l.toString());
                if (l.errorCode() == 0) {
                    TransactionManager.getManager().setJobStatus(object, Entry.STATUS.ON_TARGET);
                } else {
                    TransactionManager.getManager().setJobStatus(object, Entry.STATUS.ON_SERVER);
                }
            } else {
                String string = object.getCommandData();
                if (string != null) {
                    this.calc_data_memory += (long)(string.length() / 4 * 3);
                }
                if (l.retransmissions() != 0) {
                    this.logger.debug("Retransmission(" + object.getId() + "): " + l.toString());
                }
            }
            map.remove(object.getDispatcherTransactionId());
        }
        if (map.size() != 0) {
            CommCmCancelTransactions commCmCancelTransactions = new CommCmCancelTransactions();
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                long l = (Long)iterator.next();
                this.logger.debug("KILLING unknown job: " + ((TransactionStatus)map.get(l)).toString());
                commCmCancelTransactions.addTransaction(l);
            }
            this.send_to_dispatcher((ACommCommand)commCmCancelTransactions);
        }
        commCmDispGetTransactions = new CommCmDispGetTransactions();
        commCmDispGetTransactions.setCleanUp();
        this.send_to_dispatcher((ACommCommand)commCmDispGetTransactions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exec_get_errors() throws WizePanelExceptions {
        CommCmDispGetErrors commCmDispGetErrors = new CommCmDispGetErrors();
        commCmDispGetErrors.initializeCommandParams();
        try {
            this.send_to_dispatcher((ACommCommand)commCmDispGetErrors);
            if (commCmDispGetErrors.getErrors().size() != 0) {
                Date date = new Date();
                long l = System.currentTimeMillis();
                for (ErrorEntry errorEntry : commCmDispGetErrors.getErrors()) {
                    date.setTime(l - this.stats.uptime_secs * 1000L + errorEntry.getRuntimeSecs() * 1000L);
                    this.logger.info("ERRORLOG(" + WpTimeUtils.date2str((Date)date) + "): " + errorEntry.toString());
                }
            }
        }
        finally {
            commCmDispGetErrors.doCleanup(true);
            this.send_to_dispatcher((ACommCommand)commCmDispGetErrors);
        }
    }

    @Override
    protected void send_reset() throws WizePanelExceptions {
        CommCmDispRestart commCmDispRestart = new CommCmDispRestart();
        commCmDispRestart.initializeCommandParams();
        this.send_to_dispatcher((ACommCommand)commCmDispRestart);
    }

    @Override
    public void register_panels() throws WizePanelExceptions {
        List<WizePanelItemType> list = WpDataManager.getManager().getWizepanelsByDispatcher(this.dispatcher.getId());
        this.logger.info("Registering panels: " + list.size());
        if (list.size() == 0) {
            return;
        }
        this.update_stats();
        if (this.stats.max_number_targets < list.size()) {
            Warnings.getInstance().addWarning(this.dispatcher.getId(), "Trying to register " + list.size() + " panels. Only " + this.stats.max_number_targets + " are allowed and will be registered.");
        }
        CommCmDispSubscribeList commCmDispSubscribeList = new CommCmDispSubscribeList();
        for (int i = 0; i < this.stats.max_number_targets && i < list.size(); ++i) {
            commCmDispSubscribeList.add((long)list.get(i).getSerialNo());
        }
        this.send_to_dispatcher((ACommCommand)commCmDispSubscribeList);
    }

    @Override
    protected void kill_all_dispatcher_jobs() throws WizePanelExceptions {
        this.logger.warn("KILLING ALL JOBS");
        CommCmCancelTransactions commCmCancelTransactions = new CommCmCancelTransactions();
        commCmCancelTransactions.initializeCommandParams();
        this.send_to_dispatcher((ACommCommand)commCmCancelTransactions);
    }
}

